/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The specified parameter is invalid. Review the available parameters for the API request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidParameterException extends EksException implements
        ToCopyableBuilder<InvalidParameterException.Builder, InvalidParameterException> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InvalidParameterException::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> NODEGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InvalidParameterException::nodegroupName)).setter(setter(Builder::nodegroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodegroupName").build()).build();

    private static final SdkField<String> FARGATE_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InvalidParameterException::fargateProfileName)).setter(setter(Builder::fargateProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargateProfileName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            NODEGROUP_NAME_FIELD, FARGATE_PROFILE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clusterName;

    private final String nodegroupName;

    private final String fargateProfileName;

    private InvalidParameterException(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodegroupName = builder.nodegroupName;
        this.fargateProfileName = builder.fargateProfileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The Amazon EKS cluster associated with the exception.
     * </p>
     * 
     * @return The Amazon EKS cluster associated with the exception.
     */
    public String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The Amazon EKS managed node group associated with the exception.
     * </p>
     * 
     * @return The Amazon EKS managed node group associated with the exception.
     */
    public String nodegroupName() {
        return nodegroupName;
    }

    /**
     * <p>
     * The Fargate profile associated with the exception.
     * </p>
     * 
     * @return The Fargate profile associated with the exception.
     */
    public String fargateProfileName() {
        return fargateProfileName;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvalidParameterException, T> g) {
        return obj -> g.apply((InvalidParameterException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidParameterException>, EksException.Builder {
        /**
         * <p>
         * The Amazon EKS cluster associated with the exception.
         * </p>
         * 
         * @param clusterName
         *        The Amazon EKS cluster associated with the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The Amazon EKS managed node group associated with the exception.
         * </p>
         * 
         * @param nodegroupName
         *        The Amazon EKS managed node group associated with the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodegroupName(String nodegroupName);

        /**
         * <p>
         * The Fargate profile associated with the exception.
         * </p>
         * 
         * @param fargateProfileName
         *        The Fargate profile associated with the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fargateProfileName(String fargateProfileName);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends EksException.BuilderImpl implements Builder {
        private String clusterName;

        private String nodegroupName;

        private String fargateProfileName;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidParameterException model) {
            super(model);
            clusterName(model.clusterName);
            nodegroupName(model.nodegroupName);
            fargateProfileName(model.fargateProfileName);
        }

        public final String getClusterName() {
            return clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getNodegroupName() {
            return nodegroupName;
        }

        @Override
        public final Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public final void setNodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
        }

        public final String getFargateProfileName() {
            return fargateProfileName;
        }

        @Override
        public final Builder fargateProfileName(String fargateProfileName) {
            this.fargateProfileName = fargateProfileName;
            return this;
        }

        public final void setFargateProfileName(String fargateProfileName) {
            this.fargateProfileName = fargateProfileName;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public InvalidParameterException build() {
            return new InvalidParameterException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
