/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an Amazon EKS cluster VPC configuration response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcConfigResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcConfigResponse.Builder, VpcConfigResponse> {
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(VpcConfigResponse::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(VpcConfigResponse::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VpcConfigResponse::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final SdkField<Boolean> ENDPOINT_PUBLIC_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(VpcConfigResponse::endpointPublicAccess)).setter(setter(Builder::endpointPublicAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointPublicAccess").build())
            .build();

    private static final SdkField<Boolean> ENDPOINT_PRIVATE_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(VpcConfigResponse::endpointPrivateAccess)).setter(setter(Builder::endpointPrivateAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointPrivateAccess").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDS_FIELD,
            SECURITY_GROUP_IDS_FIELD, VPC_ID_FIELD, ENDPOINT_PUBLIC_ACCESS_FIELD, ENDPOINT_PRIVATE_ACCESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> subnetIds;

    private final List<String> securityGroupIds;

    private final String vpcId;

    private final Boolean endpointPublicAccess;

    private final Boolean endpointPrivateAccess;

    private VpcConfigResponse(BuilderImpl builder) {
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.vpcId = builder.vpcId;
        this.endpointPublicAccess = builder.endpointPublicAccess;
        this.endpointPrivateAccess = builder.endpointPrivateAccess;
    }

    /**
     * <p>
     * The subnets associated with your cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The subnets associated with your cluster.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The security groups associated with the cross-account elastic network interfaces that are used to allow
     * communication between your worker nodes and the Kubernetes control plane.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The security groups associated with the cross-account elastic network interfaces that are used to allow
     *         communication between your worker nodes and the Kubernetes control plane.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The VPC associated with your cluster.
     * </p>
     * 
     * @return The VPC associated with your cluster.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * This parameter indicates whether the Amazon EKS public API server endpoint is enabled. If the Amazon EKS public
     * API server endpoint is disabled, your cluster's Kubernetes API server can receive only requests that originate
     * from within the cluster VPC.
     * </p>
     * 
     * @return This parameter indicates whether the Amazon EKS public API server endpoint is enabled. If the Amazon EKS
     *         public API server endpoint is disabled, your cluster's Kubernetes API server can receive only requests
     *         that originate from within the cluster VPC.
     */
    public Boolean endpointPublicAccess() {
        return endpointPublicAccess;
    }

    /**
     * <p>
     * This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If the Amazon EKS private
     * API server endpoint is enabled, Kubernetes API requests that originate from within your cluster's VPC use the
     * private VPC endpoint instead of traversing the internet.
     * </p>
     * 
     * @return This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If the Amazon EKS
     *         private API server endpoint is enabled, Kubernetes API requests that originate from within your cluster's
     *         VPC use the private VPC endpoint instead of traversing the internet.
     */
    public Boolean endpointPrivateAccess() {
        return endpointPrivateAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(endpointPublicAccess());
        hashCode = 31 * hashCode + Objects.hashCode(endpointPrivateAccess());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfigResponse)) {
            return false;
        }
        VpcConfigResponse other = (VpcConfigResponse) obj;
        return Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(endpointPublicAccess(), other.endpointPublicAccess())
                && Objects.equals(endpointPrivateAccess(), other.endpointPrivateAccess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VpcConfigResponse").add("SubnetIds", subnetIds()).add("SecurityGroupIds", securityGroupIds())
                .add("VpcId", vpcId()).add("EndpointPublicAccess", endpointPublicAccess())
                .add("EndpointPrivateAccess", endpointPrivateAccess()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "vpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "endpointPublicAccess":
            return Optional.ofNullable(clazz.cast(endpointPublicAccess()));
        case "endpointPrivateAccess":
            return Optional.ofNullable(clazz.cast(endpointPrivateAccess()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcConfigResponse, T> g) {
        return obj -> g.apply((VpcConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcConfigResponse> {
        /**
         * <p>
         * The subnets associated with your cluster.
         * </p>
         * 
         * @param subnetIds
         *        The subnets associated with your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The subnets associated with your cluster.
         * </p>
         * 
         * @param subnetIds
         *        The subnets associated with your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The security groups associated with the cross-account elastic network interfaces that are used to allow
         * communication between your worker nodes and the Kubernetes control plane.
         * </p>
         * 
         * @param securityGroupIds
         *        The security groups associated with the cross-account elastic network interfaces that are used to
         *        allow communication between your worker nodes and the Kubernetes control plane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The security groups associated with the cross-account elastic network interfaces that are used to allow
         * communication between your worker nodes and the Kubernetes control plane.
         * </p>
         * 
         * @param securityGroupIds
         *        The security groups associated with the cross-account elastic network interfaces that are used to
         *        allow communication between your worker nodes and the Kubernetes control plane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The VPC associated with your cluster.
         * </p>
         * 
         * @param vpcId
         *        The VPC associated with your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * This parameter indicates whether the Amazon EKS public API server endpoint is enabled. If the Amazon EKS
         * public API server endpoint is disabled, your cluster's Kubernetes API server can receive only requests that
         * originate from within the cluster VPC.
         * </p>
         * 
         * @param endpointPublicAccess
         *        This parameter indicates whether the Amazon EKS public API server endpoint is enabled. If the Amazon
         *        EKS public API server endpoint is disabled, your cluster's Kubernetes API server can receive only
         *        requests that originate from within the cluster VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointPublicAccess(Boolean endpointPublicAccess);

        /**
         * <p>
         * This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If the Amazon EKS
         * private API server endpoint is enabled, Kubernetes API requests that originate from within your cluster's VPC
         * use the private VPC endpoint instead of traversing the internet.
         * </p>
         * 
         * @param endpointPrivateAccess
         *        This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If the Amazon
         *        EKS private API server endpoint is enabled, Kubernetes API requests that originate from within your
         *        cluster's VPC use the private VPC endpoint instead of traversing the internet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointPrivateAccess(Boolean endpointPrivateAccess);
    }

    static final class BuilderImpl implements Builder {
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private Boolean endpointPublicAccess;

        private Boolean endpointPrivateAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConfigResponse model) {
            subnetIds(model.subnetIds);
            securityGroupIds(model.securityGroupIds);
            vpcId(model.vpcId);
            endpointPublicAccess(model.endpointPublicAccess);
            endpointPrivateAccess(model.endpointPrivateAccess);
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Boolean getEndpointPublicAccess() {
            return endpointPublicAccess;
        }

        @Override
        public final Builder endpointPublicAccess(Boolean endpointPublicAccess) {
            this.endpointPublicAccess = endpointPublicAccess;
            return this;
        }

        public final void setEndpointPublicAccess(Boolean endpointPublicAccess) {
            this.endpointPublicAccess = endpointPublicAccess;
        }

        public final Boolean getEndpointPrivateAccess() {
            return endpointPrivateAccess;
        }

        @Override
        public final Builder endpointPrivateAccess(Boolean endpointPrivateAccess) {
            this.endpointPrivateAccess = endpointPrivateAccess;
            return this;
        }

        public final void setEndpointPrivateAccess(Boolean endpointPrivateAccess) {
            this.endpointPrivateAccess = endpointPrivateAccess;
        }

        @Override
        public VpcConfigResponse build() {
            return new VpcConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
