/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceRequest extends EcsRequest implements
        ToCopyableBuilder<UpdateServiceRequest.Builder, UpdateServiceRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(UpdateServiceRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("service")
            .getter(getter(UpdateServiceRequest::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<Integer> DESIRED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("desiredCount").getter(getter(UpdateServiceRequest::desiredCount)).setter(setter(Builder::desiredCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCount").build()).build();

    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskDefinition").getter(getter(UpdateServiceRequest::taskDefinition))
            .setter(setter(Builder::taskDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()).build();

    private static final SdkField<List<CapacityProviderStrategyItem>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField
            .<List<CapacityProviderStrategyItem>> builder(MarshallingType.LIST)
            .memberName("capacityProviderStrategy")
            .getter(getter(UpdateServiceRequest::capacityProviderStrategy))
            .setter(setter(Builder::capacityProviderStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderStrategy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapacityProviderStrategyItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityProviderStrategyItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<DeploymentConfiguration> builder(MarshallingType.SDK_POJO).memberName("deploymentConfiguration")
            .getter(getter(UpdateServiceRequest::deploymentConfiguration)).setter(setter(Builder::deploymentConfiguration))
            .constructor(DeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_REBALANCING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("availabilityZoneRebalancing")
            .getter(getter(UpdateServiceRequest::availabilityZoneRebalancingAsString))
            .setter(setter(Builder::availabilityZoneRebalancing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneRebalancing")
                    .build()).build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(UpdateServiceRequest::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<List<PlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField
            .<List<PlacementConstraint>> builder(MarshallingType.LIST)
            .memberName("placementConstraints")
            .getter(getter(UpdateServiceRequest::placementConstraints))
            .setter(setter(Builder::placementConstraints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementConstraint> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementConstraint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PlacementStrategy>> PLACEMENT_STRATEGY_FIELD = SdkField
            .<List<PlacementStrategy>> builder(MarshallingType.LIST)
            .memberName("placementStrategy")
            .getter(getter(UpdateServiceRequest::placementStrategy))
            .setter(setter(Builder::placementStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementStrategy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementStrategy> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementStrategy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformVersion").getter(getter(UpdateServiceRequest::platformVersion))
            .setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()).build();

    private static final SdkField<Boolean> FORCE_NEW_DEPLOYMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("forceNewDeployment").getter(getter(UpdateServiceRequest::forceNewDeployment))
            .setter(setter(Builder::forceNewDeployment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceNewDeployment").build())
            .build();

    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("healthCheckGracePeriodSeconds")
            .getter(getter(UpdateServiceRequest::healthCheckGracePeriodSeconds))
            .setter(setter(Builder::healthCheckGracePeriodSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckGracePeriodSeconds")
                    .build()).build();

    private static final SdkField<DeploymentController> DEPLOYMENT_CONTROLLER_FIELD = SdkField
            .<DeploymentController> builder(MarshallingType.SDK_POJO).memberName("deploymentController")
            .getter(getter(UpdateServiceRequest::deploymentController)).setter(setter(Builder::deploymentController))
            .constructor(DeploymentController::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentController").build())
            .build();

    private static final SdkField<Boolean> ENABLE_EXECUTE_COMMAND_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableExecuteCommand").getter(getter(UpdateServiceRequest::enableExecuteCommand))
            .setter(setter(Builder::enableExecuteCommand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableExecuteCommand").build())
            .build();

    private static final SdkField<Boolean> ENABLE_ECS_MANAGED_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableECSManagedTags").getter(getter(UpdateServiceRequest::enableECSManagedTags))
            .setter(setter(Builder::enableECSManagedTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableECSManagedTags").build())
            .build();

    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField
            .<List<LoadBalancer>> builder(MarshallingType.LIST)
            .memberName("loadBalancers")
            .getter(getter(UpdateServiceRequest::loadBalancers))
            .setter(setter(Builder::loadBalancers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancer> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propagateTags").getter(getter(UpdateServiceRequest::propagateTagsAsString))
            .setter(setter(Builder::propagateTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()).build();

    private static final SdkField<List<ServiceRegistry>> SERVICE_REGISTRIES_FIELD = SdkField
            .<List<ServiceRegistry>> builder(MarshallingType.LIST)
            .memberName("serviceRegistries")
            .getter(getter(UpdateServiceRequest::serviceRegistries))
            .setter(setter(Builder::serviceRegistries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRegistries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceRegistry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceRegistry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ServiceConnectConfiguration> SERVICE_CONNECT_CONFIGURATION_FIELD = SdkField
            .<ServiceConnectConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("serviceConnectConfiguration")
            .getter(getter(UpdateServiceRequest::serviceConnectConfiguration))
            .setter(setter(Builder::serviceConnectConfiguration))
            .constructor(ServiceConnectConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceConnectConfiguration")
                    .build()).build();

    private static final SdkField<List<ServiceVolumeConfiguration>> VOLUME_CONFIGURATIONS_FIELD = SdkField
            .<List<ServiceVolumeConfiguration>> builder(MarshallingType.LIST)
            .memberName("volumeConfigurations")
            .getter(getter(UpdateServiceRequest::volumeConfigurations))
            .setter(setter(Builder::volumeConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceVolumeConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceVolumeConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<VpcLatticeConfiguration>> VPC_LATTICE_CONFIGURATIONS_FIELD = SdkField
            .<List<VpcLatticeConfiguration>> builder(MarshallingType.LIST)
            .memberName("vpcLatticeConfigurations")
            .getter(getter(UpdateServiceRequest::vpcLatticeConfigurations))
            .setter(setter(Builder::vpcLatticeConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcLatticeConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcLatticeConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcLatticeConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, SERVICE_FIELD,
            DESIRED_COUNT_FIELD, TASK_DEFINITION_FIELD, CAPACITY_PROVIDER_STRATEGY_FIELD, DEPLOYMENT_CONFIGURATION_FIELD,
            AVAILABILITY_ZONE_REBALANCING_FIELD, NETWORK_CONFIGURATION_FIELD, PLACEMENT_CONSTRAINTS_FIELD,
            PLACEMENT_STRATEGY_FIELD, PLATFORM_VERSION_FIELD, FORCE_NEW_DEPLOYMENT_FIELD,
            HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD, DEPLOYMENT_CONTROLLER_FIELD, ENABLE_EXECUTE_COMMAND_FIELD,
            ENABLE_ECS_MANAGED_TAGS_FIELD, LOAD_BALANCERS_FIELD, PROPAGATE_TAGS_FIELD, SERVICE_REGISTRIES_FIELD,
            SERVICE_CONNECT_CONFIGURATION_FIELD, VOLUME_CONFIGURATIONS_FIELD, VPC_LATTICE_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String cluster;

    private final String service;

    private final Integer desiredCount;

    private final String taskDefinition;

    private final List<CapacityProviderStrategyItem> capacityProviderStrategy;

    private final DeploymentConfiguration deploymentConfiguration;

    private final String availabilityZoneRebalancing;

    private final NetworkConfiguration networkConfiguration;

    private final List<PlacementConstraint> placementConstraints;

    private final List<PlacementStrategy> placementStrategy;

    private final String platformVersion;

    private final Boolean forceNewDeployment;

    private final Integer healthCheckGracePeriodSeconds;

    private final DeploymentController deploymentController;

    private final Boolean enableExecuteCommand;

    private final Boolean enableECSManagedTags;

    private final List<LoadBalancer> loadBalancers;

    private final String propagateTags;

    private final List<ServiceRegistry> serviceRegistries;

    private final ServiceConnectConfiguration serviceConnectConfiguration;

    private final List<ServiceVolumeConfiguration> volumeConfigurations;

    private final List<VpcLatticeConfiguration> vpcLatticeConfigurations;

    private UpdateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.service = builder.service;
        this.desiredCount = builder.desiredCount;
        this.taskDefinition = builder.taskDefinition;
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.availabilityZoneRebalancing = builder.availabilityZoneRebalancing;
        this.networkConfiguration = builder.networkConfiguration;
        this.placementConstraints = builder.placementConstraints;
        this.placementStrategy = builder.placementStrategy;
        this.platformVersion = builder.platformVersion;
        this.forceNewDeployment = builder.forceNewDeployment;
        this.healthCheckGracePeriodSeconds = builder.healthCheckGracePeriodSeconds;
        this.deploymentController = builder.deploymentController;
        this.enableExecuteCommand = builder.enableExecuteCommand;
        this.enableECSManagedTags = builder.enableECSManagedTags;
        this.loadBalancers = builder.loadBalancers;
        this.propagateTags = builder.propagateTags;
        this.serviceRegistries = builder.serviceRegistries;
        this.serviceConnectConfiguration = builder.serviceConnectConfiguration;
        this.volumeConfigurations = builder.volumeConfigurations;
        this.vpcLatticeConfigurations = builder.vpcLatticeConfigurations;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that your service runs on. If you do not specify
     * a cluster, the default cluster is assumed.
     * </p>
     * <p>
     * You can't change the cluster name.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that your service runs on. If you do not
     *         specify a cluster, the default cluster is assumed.</p>
     *         <p>
     *         You can't change the cluster name.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The name of the service to update.
     * </p>
     * 
     * @return The name of the service to update.
     */
    public final String service() {
        return service;
    }

    /**
     * <p>
     * The number of instantiations of the task to place and keep running in your service.
     * </p>
     * <p>
     * This parameter doesn't trigger a new service deployment.
     * </p>
     * 
     * @return The number of instantiations of the task to place and keep running in your service.</p>
     *         <p>
     *         This parameter doesn't trigger a new service deployment.
     */
    public final Integer desiredCount() {
        return desiredCount;
    }

    /**
     * <p>
     * The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task
     * definition to run in your service. If a <code>revision</code> is not specified, the latest <code>ACTIVE</code>
     * revision is used. If you modify the task definition with <code>UpdateService</code>, Amazon ECS spawns a task
     * with the new version of the task definition and then stops an old task after the new version is running.
     * </p>
     * <p>
     * This parameter triggers a new service deployment.
     * </p>
     * 
     * @return The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task
     *         definition to run in your service. If a <code>revision</code> is not specified, the latest
     *         <code>ACTIVE</code> revision is used. If you modify the task definition with <code>UpdateService</code>,
     *         Amazon ECS spawns a task with the new version of the task definition and then stops an old task after the
     *         new version is running.</p>
     *         <p>
     *         This parameter triggers a new service deployment.
     */
    public final String taskDefinition() {
        return taskDefinition;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityProviderStrategy property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCapacityProviderStrategy() {
        return capacityProviderStrategy != null && !(capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of a capacity provider strategy. You can set a capacity provider when you create a cluster, run a
     * task, or update a service.
     * </p>
     * <p>
     * When you use Fargate, the capacity providers are <code>FARGATE</code> or <code>FARGATE_SPOT</code>.
     * </p>
     * <p>
     * When you use Amazon EC2, the capacity providers are Auto Scaling groups.
     * </p>
     * <p>
     * You can change capacity providers for rolling deployments and blue/green deployments.
     * </p>
     * <p>
     * The following list provides the valid transitions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Update the Fargate launch type to an Auto Scaling group capacity provider.
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the Amazon EC2 launch type to a Fargate capacity provider.
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the Fargate capacity provider to an Auto Scaling group capacity provider.
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the Amazon EC2 capacity provider to a Fargate capacity provider.
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the Auto Scaling group or Fargate capacity provider back to the launch type.
     * </p>
     * <p>
     * Pass an empty list in the <code>capacityProviderStrategy</code> parameter.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about Amazon Web Services CDK considerations, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/update-service-parameters.html">Amazon Web
     * Services CDK considerations</a>.
     * </p>
     * <p>
     * This parameter doesn't trigger a new service deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityProviderStrategy} method.
     * </p>
     * 
     * @return The details of a capacity provider strategy. You can set a capacity provider when you create a cluster,
     *         run a task, or update a service.</p>
     *         <p>
     *         When you use Fargate, the capacity providers are <code>FARGATE</code> or <code>FARGATE_SPOT</code>.
     *         </p>
     *         <p>
     *         When you use Amazon EC2, the capacity providers are Auto Scaling groups.
     *         </p>
     *         <p>
     *         You can change capacity providers for rolling deployments and blue/green deployments.
     *         </p>
     *         <p>
     *         The following list provides the valid transitions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Update the Fargate launch type to an Auto Scaling group capacity provider.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Update the Amazon EC2 launch type to a Fargate capacity provider.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Update the Fargate capacity provider to an Auto Scaling group capacity provider.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Update the Amazon EC2 capacity provider to a Fargate capacity provider.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Update the Auto Scaling group or Fargate capacity provider back to the launch type.
     *         </p>
     *         <p>
     *         Pass an empty list in the <code>capacityProviderStrategy</code> parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For information about Amazon Web Services CDK considerations, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/update-service-parameters.html">Amazon
     *         Web Services CDK considerations</a>.
     *         </p>
     *         <p>
     *         This parameter doesn't trigger a new service deployment.
     */
    public final List<CapacityProviderStrategyItem> capacityProviderStrategy() {
        return capacityProviderStrategy;
    }

    /**
     * <p>
     * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping
     * and starting tasks.
     * </p>
     * <p>
     * This parameter doesn't trigger a new service deployment.
     * </p>
     * 
     * @return Optional deployment parameters that control how many tasks run during the deployment and the ordering of
     *         stopping and starting tasks.</p>
     *         <p>
     *         This parameter doesn't trigger a new service deployment.
     */
    public final DeploymentConfiguration deploymentConfiguration() {
        return deploymentConfiguration;
    }

    /**
     * <p>
     * Indicates whether to use Availability Zone rebalancing for the service.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an Amazon
     * ECS service across Availability Zones</a> in the <i> <i>Amazon Elastic Container Service Developer Guide</i>
     * </i>.
     * </p>
     * <p>
     * The default behavior of <code>AvailabilityZoneRebalancing</code> differs between create and update requests:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For create service requests, when when no value is specified for <code>AvailabilityZoneRebalancing</code>, Amazon
     * ECS defaults the value to to <code>ENABLED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For update service requests, when no value is specified for <code>AvailabilityZoneRebalancing</code>, Amazon ECS
     * defaults to the existing service’s <code>AvailabilityZoneRebalancing</code> value. If the service never had an
     * <code>AvailabilityZoneRebalancing</code> value set, Amazon ECS treats this as <code>DISABLED</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This parameter doesn't trigger a new service deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #availabilityZoneRebalancing} will return {@link AvailabilityZoneRebalancing#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #availabilityZoneRebalancingAsString}.
     * </p>
     * 
     * @return Indicates whether to use Availability Zone rebalancing for the service.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an
     *         Amazon ECS service across Availability Zones</a> in the <i> <i>Amazon Elastic Container Service Developer
     *         Guide</i> </i>.
     *         </p>
     *         <p>
     *         The default behavior of <code>AvailabilityZoneRebalancing</code> differs between create and update
     *         requests:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For create service requests, when when no value is specified for <code>AvailabilityZoneRebalancing</code>
     *         , Amazon ECS defaults the value to to <code>ENABLED</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For update service requests, when no value is specified for <code>AvailabilityZoneRebalancing</code>,
     *         Amazon ECS defaults to the existing service’s <code>AvailabilityZoneRebalancing</code> value. If the
     *         service never had an <code>AvailabilityZoneRebalancing</code> value set, Amazon ECS treats this as
     *         <code>DISABLED</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This parameter doesn't trigger a new service deployment.
     * @see AvailabilityZoneRebalancing
     */
    public final AvailabilityZoneRebalancing availabilityZoneRebalancing() {
        return AvailabilityZoneRebalancing.fromValue(availabilityZoneRebalancing);
    }

    /**
     * <p>
     * Indicates whether to use Availability Zone rebalancing for the service.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an Amazon
     * ECS service across Availability Zones</a> in the <i> <i>Amazon Elastic Container Service Developer Guide</i>
     * </i>.
     * </p>
     * <p>
     * The default behavior of <code>AvailabilityZoneRebalancing</code> differs between create and update requests:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For create service requests, when when no value is specified for <code>AvailabilityZoneRebalancing</code>, Amazon
     * ECS defaults the value to to <code>ENABLED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For update service requests, when no value is specified for <code>AvailabilityZoneRebalancing</code>, Amazon ECS
     * defaults to the existing service’s <code>AvailabilityZoneRebalancing</code> value. If the service never had an
     * <code>AvailabilityZoneRebalancing</code> value set, Amazon ECS treats this as <code>DISABLED</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This parameter doesn't trigger a new service deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #availabilityZoneRebalancing} will return {@link AvailabilityZoneRebalancing#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #availabilityZoneRebalancingAsString}.
     * </p>
     * 
     * @return Indicates whether to use Availability Zone rebalancing for the service.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an
     *         Amazon ECS service across Availability Zones</a> in the <i> <i>Amazon Elastic Container Service Developer
     *         Guide</i> </i>.
     *         </p>
     *         <p>
     *         The default behavior of <code>AvailabilityZoneRebalancing</code> differs between create and update
     *         requests:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For create service requests, when when no value is specified for <code>AvailabilityZoneRebalancing</code>
     *         , Amazon ECS defaults the value to to <code>ENABLED</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For update service requests, when no value is specified for <code>AvailabilityZoneRebalancing</code>,
     *         Amazon ECS defaults to the existing service’s <code>AvailabilityZoneRebalancing</code> value. If the
     *         service never had an <code>AvailabilityZoneRebalancing</code> value set, Amazon ECS treats this as
     *         <code>DISABLED</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This parameter doesn't trigger a new service deployment.
     * @see AvailabilityZoneRebalancing
     */
    public final String availabilityZoneRebalancingAsString() {
        return availabilityZoneRebalancing;
    }

    /**
     * <p>
     * An object representing the network configuration for the service.
     * </p>
     * <p>
     * This parameter triggers a new service deployment.
     * </p>
     * 
     * @return An object representing the network configuration for the service.</p>
     *         <p>
     *         This parameter triggers a new service deployment.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlacementConstraints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPlacementConstraints() {
        return placementConstraints != null && !(placementConstraints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of task placement constraint objects to update the service to use. If no value is specified, the
     * existing placement constraints for the service will remain unchanged. If this value is specified, it will
     * override any existing placement constraints defined for the service. To remove all existing placement
     * constraints, specify an empty array.
     * </p>
     * <p>
     * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition
     * and those specified at runtime.
     * </p>
     * <p>
     * This parameter doesn't trigger a new service deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlacementConstraints} method.
     * </p>
     * 
     * @return An array of task placement constraint objects to update the service to use. If no value is specified, the
     *         existing placement constraints for the service will remain unchanged. If this value is specified, it will
     *         override any existing placement constraints defined for the service. To remove all existing placement
     *         constraints, specify an empty array.</p>
     *         <p>
     *         You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task
     *         definition and those specified at runtime.
     *         </p>
     *         <p>
     *         This parameter doesn't trigger a new service deployment.
     */
    public final List<PlacementConstraint> placementConstraints() {
        return placementConstraints;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlacementStrategy property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPlacementStrategy() {
        return placementStrategy != null && !(placementStrategy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The task placement strategy objects to update the service to use. If no value is specified, the existing
     * placement strategy for the service will remain unchanged. If this value is specified, it will override the
     * existing placement strategy defined for the service. To remove an existing placement strategy, specify an empty
     * object.
     * </p>
     * <p>
     * You can specify a maximum of five strategy rules for each service.
     * </p>
     * <p>
     * This parameter doesn't trigger a new service deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlacementStrategy} method.
     * </p>
     * 
     * @return The task placement strategy objects to update the service to use. If no value is specified, the existing
     *         placement strategy for the service will remain unchanged. If this value is specified, it will override
     *         the existing placement strategy defined for the service. To remove an existing placement strategy,
     *         specify an empty object.</p>
     *         <p>
     *         You can specify a maximum of five strategy rules for each service.
     *         </p>
     *         <p>
     *         This parameter doesn't trigger a new service deployment.
     */
    public final List<PlacementStrategy> placementStrategy() {
        return placementStrategy;
    }

    /**
     * <p>
     * The platform version that your tasks in the service run on. A platform version is only specified for tasks using
     * the Fargate launch type. If a platform version is not specified, the <code>LATEST</code> platform version is
     * used. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
     * Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * This parameter triggers a new service deployment.
     * </p>
     * 
     * @return The platform version that your tasks in the service run on. A platform version is only specified for
     *         tasks using the Fargate launch type. If a platform version is not specified, the <code>LATEST</code>
     *         platform version is used. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate
     *         Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
     *         <p>
     *         This parameter triggers a new service deployment.
     */
    public final String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * Determines whether to force a new deployment of the service. By default, deployments aren't forced. You can use
     * this option to start a new deployment with no service definition changes. For example, you can update a service's
     * tasks to use a newer Docker image with the same image/tag combination (<code>my_image:latest</code>) or to roll
     * Fargate tasks onto a newer platform version.
     * </p>
     * 
     * @return Determines whether to force a new deployment of the service. By default, deployments aren't forced. You
     *         can use this option to start a new deployment with no service definition changes. For example, you can
     *         update a service's tasks to use a newer Docker image with the same image/tag combination (
     *         <code>my_image:latest</code>) or to roll Fargate tasks onto a newer platform version.
     */
    public final Boolean forceNewDeployment() {
        return forceNewDeployment;
    }

    /**
     * <p>
     * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing,
     * VPC Lattice, and container health checks after a task has first started. If you don't specify a health check
     * grace period value, the default value of <code>0</code> is used. If you don't use any of the health checks, then
     * <code>healthCheckGracePeriodSeconds</code> is unused.
     * </p>
     * <p>
     * If your service's tasks take a while to start and respond to health checks, you can specify a health check grace
     * period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS service scheduler
     * ignores health check status. This grace period can prevent the service scheduler from marking tasks as unhealthy
     * and stopping them before they have time to come up.
     * </p>
     * <p>
     * This parameter doesn't trigger a new service deployment.
     * </p>
     * 
     * @return The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load
     *         Balancing, VPC Lattice, and container health checks after a task has first started. If you don't specify
     *         a health check grace period value, the default value of <code>0</code> is used. If you don't use any of
     *         the health checks, then <code>healthCheckGracePeriodSeconds</code> is unused.</p>
     *         <p>
     *         If your service's tasks take a while to start and respond to health checks, you can specify a health
     *         check grace period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS
     *         service scheduler ignores health check status. This grace period can prevent the service scheduler from
     *         marking tasks as unhealthy and stopping them before they have time to come up.
     *         </p>
     *         <p>
     *         This parameter doesn't trigger a new service deployment.
     */
    public final Integer healthCheckGracePeriodSeconds() {
        return healthCheckGracePeriodSeconds;
    }

    /**
     * Returns the value of the DeploymentController property for this object.
     * 
     * @return The value of the DeploymentController property for this object.
     */
    public final DeploymentController deploymentController() {
        return deploymentController;
    }

    /**
     * <p>
     * If <code>true</code>, this enables execute command functionality on all task containers.
     * </p>
     * <p>
     * If you do not want to override the value that was set when the service was created, you can set this to
     * <code>null</code> when performing this action.
     * </p>
     * <p>
     * This parameter doesn't trigger a new service deployment.
     * </p>
     * 
     * @return If <code>true</code>, this enables execute command functionality on all task containers.</p>
     *         <p>
     *         If you do not want to override the value that was set when the service was created, you can set this to
     *         <code>null</code> when performing this action.
     *         </p>
     *         <p>
     *         This parameter doesn't trigger a new service deployment.
     */
    public final Boolean enableExecuteCommand() {
        return enableExecuteCommand;
    }

    /**
     * <p>
     * Determines whether to turn on Amazon ECS managed tags for the tasks in the service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
     * Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
     * <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated tags.
     * </p>
     * <p>
     * This parameter doesn't trigger a new service deployment.
     * </p>
     * 
     * @return Determines whether to turn on Amazon ECS managed tags for the tasks in the service. For more information,
     *         see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging
     *         Your Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
     *         <p>
     *         Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
     *         <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the
     *         updated tags.
     *         </p>
     *         <p>
     *         This parameter doesn't trigger a new service deployment.
     */
    public final Boolean enableECSManagedTags() {
        return enableECSManagedTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoadBalancers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLoadBalancers() {
        return loadBalancers != null && !(loadBalancers instanceof SdkAutoConstructList);
    }

    /**
     * <note>
     * <p>
     * You must have a service-linked role when you update this property
     * </p>
     * </note>
     * <p>
     * A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container name,
     * and the container port to access from the load balancer. The container name is as it appears in a container
     * definition.
     * </p>
     * <p>
     * When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the updated
     * Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are running.
     * </p>
     * <p>
     * For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target groups. You
     * can update from a single target group to multiple target groups and from multiple target groups to a single
     * target group.
     * </p>
     * <p>
     * For services that use blue/green deployments, you can update Elastic Load Balancing target groups by using
     * <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code>
     * through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For more
     * information see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Register
     * multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * For services that use the external deployment controller, you can add, update, or remove load balancers by using
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet</a>.
     * Note that multiple target groups are not supported for external deployments. For more information see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Register
     * multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * You can remove existing <code>loadBalancers</code> by passing an empty list.
     * </p>
     * <p>
     * This parameter triggers a new service deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoadBalancers} method.
     * </p>
     * 
     * @return <p>
     *         You must have a service-linked role when you update this property
     *         </p>
     *         </note>
     *         <p>
     *         A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container
     *         name, and the container port to access from the load balancer. The container name is as it appears in a
     *         container definition.
     *         </p>
     *         <p>
     *         When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the
     *         updated Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are
     *         running.
     *         </p>
     *         <p>
     *         For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target
     *         groups. You can update from a single target group to multiple target groups and from multiple target
     *         groups to a single target group.
     *         </p>
     *         <p>
     *         For services that use blue/green deployments, you can update Elastic Load Balancing target groups by
     *         using
     *         <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code>
     *         through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For
     *         more information see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
     *         >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer
     *         Guide</i>.
     *         </p>
     *         <p>
     *         For services that use the external deployment controller, you can add, update, or remove load balancers
     *         by using <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet
     *         </a>. Note that multiple target groups are not supported for external deployments. For more information
     *         see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
     *         >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer
     *         Guide</i>.
     *         </p>
     *         <p>
     *         You can remove existing <code>loadBalancers</code> by passing an empty list.
     *         </p>
     *         <p>
     *         This parameter triggers a new service deployment.
     */
    public final List<LoadBalancer> loadBalancers() {
        return loadBalancers;
    }

    /**
     * <p>
     * Determines whether to propagate the tags from the task definition or the service to the task. If no value is
     * specified, the tags aren't propagated.
     * </p>
     * <p>
     * Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
     * <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated tags.
     * </p>
     * <p>
     * This parameter doesn't trigger a new service deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propagateTags}
     * will return {@link PropagateTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propagateTagsAsString}.
     * </p>
     * 
     * @return Determines whether to propagate the tags from the task definition or the service to the task. If no value
     *         is specified, the tags aren't propagated.</p>
     *         <p>
     *         Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
     *         <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the
     *         updated tags.
     *         </p>
     *         <p>
     *         This parameter doesn't trigger a new service deployment.
     * @see PropagateTags
     */
    public final PropagateTags propagateTags() {
        return PropagateTags.fromValue(propagateTags);
    }

    /**
     * <p>
     * Determines whether to propagate the tags from the task definition or the service to the task. If no value is
     * specified, the tags aren't propagated.
     * </p>
     * <p>
     * Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
     * <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated tags.
     * </p>
     * <p>
     * This parameter doesn't trigger a new service deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propagateTags}
     * will return {@link PropagateTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propagateTagsAsString}.
     * </p>
     * 
     * @return Determines whether to propagate the tags from the task definition or the service to the task. If no value
     *         is specified, the tags aren't propagated.</p>
     *         <p>
     *         Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
     *         <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the
     *         updated tags.
     *         </p>
     *         <p>
     *         This parameter doesn't trigger a new service deployment.
     * @see PropagateTags
     */
    public final String propagateTagsAsString() {
        return propagateTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceRegistries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceRegistries() {
        return serviceRegistries != null && !(serviceRegistries instanceof SdkAutoConstructList);
    }

    /**
     * <note>
     * <p>
     * You must have a service-linked role when you update this property.
     * </p>
     * <p>
     * For more information about the role see the <code>CreateService</code> request parameter <a href=
     * "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html#ECS-CreateService-request-role"
     * > <code>role</code> </a>.
     * </p>
     * </note>
     * <p>
     * The details for the service discovery registries to assign to this service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery</a>.
     * </p>
     * <p>
     * When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with the
     * updated service registries configuration, and then stops the old tasks when the new tasks are running.
     * </p>
     * <p>
     * You can remove existing <code>serviceRegistries</code> by passing an empty list.
     * </p>
     * <p>
     * This parameter triggers a new service deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceRegistries} method.
     * </p>
     * 
     * @return <p>
     *         You must have a service-linked role when you update this property.
     *         </p>
     *         <p>
     *         For more information about the role see the <code>CreateService</code> request parameter <a href=
     *         "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html#ECS-CreateService-request-role"
     *         > <code>role</code> </a>.
     *         </p>
     *         </note>
     *         <p>
     *         The details for the service discovery registries to assign to this service. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
     *         Discovery</a>.
     *         </p>
     *         <p>
     *         When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with
     *         the updated service registries configuration, and then stops the old tasks when the new tasks are
     *         running.
     *         </p>
     *         <p>
     *         You can remove existing <code>serviceRegistries</code> by passing an empty list.
     *         </p>
     *         <p>
     *         This parameter triggers a new service deployment.
     */
    public final List<ServiceRegistry> serviceRegistries() {
        return serviceRegistries;
    }

    /**
     * <p>
     * The configuration for this service to discover and connect to services, and be discovered by, and connected from,
     * other services within a namespace.
     * </p>
     * <p>
     * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to
     * services across all of the clusters in the namespace. Tasks connect through a managed proxy container that
     * collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported
     * with Service Connect. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * This parameter triggers a new service deployment.
     * </p>
     * 
     * @return The configuration for this service to discover and connect to services, and be discovered by, and
     *         connected from, other services within a namespace.</p>
     *         <p>
     *         Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can
     *         connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy
     *         container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS
     *         services create are supported with Service Connect. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service
     *         Connect</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     *         <p>
     *         This parameter triggers a new service deployment.
     */
    public final ServiceConnectConfiguration serviceConnectConfiguration() {
        return serviceConnectConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the VolumeConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVolumeConfigurations() {
        return volumeConfigurations != null && !(volumeConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the volume that was <code>configuredAtLaunch</code>. You can configure the size, volumeType, IOPS,
     * throughput, snapshot and encryption in <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ServiceManagedEBSVolumeConfiguration.html"
     * >ServiceManagedEBSVolumeConfiguration</a>. The <code>name</code> of the volume must match the <code>name</code>
     * from the task definition. If set to null, no new deployment is triggered. Otherwise, if this configuration
     * differs from the existing one, it triggers a new deployment.
     * </p>
     * <p>
     * This parameter triggers a new service deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumeConfigurations} method.
     * </p>
     * 
     * @return The details of the volume that was <code>configuredAtLaunch</code>. You can configure the size,
     *         volumeType, IOPS, throughput, snapshot and encryption in <a href=
     *         "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ServiceManagedEBSVolumeConfiguration.html"
     *         >ServiceManagedEBSVolumeConfiguration</a>. The <code>name</code> of the volume must match the
     *         <code>name</code> from the task definition. If set to null, no new deployment is triggered. Otherwise, if
     *         this configuration differs from the existing one, it triggers a new deployment.</p>
     *         <p>
     *         This parameter triggers a new service deployment.
     */
    public final List<ServiceVolumeConfiguration> volumeConfigurations() {
        return volumeConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcLatticeConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVpcLatticeConfigurations() {
        return vpcLatticeConfigurations != null && !(vpcLatticeConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object representing the VPC Lattice configuration for the service being updated.
     * </p>
     * <p>
     * This parameter triggers a new service deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcLatticeConfigurations} method.
     * </p>
     * 
     * @return An object representing the VPC Lattice configuration for the service being updated.</p>
     *         <p>
     *         This parameter triggers a new service deployment.
     */
    public final List<VpcLatticeConfiguration> vpcLatticeConfigurations() {
        return vpcLatticeConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityProviderStrategy() ? capacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneRebalancingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementConstraints() ? placementConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementStrategy() ? placementStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(forceNewDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckGracePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentController());
        hashCode = 31 * hashCode + Objects.hashCode(enableExecuteCommand());
        hashCode = 31 * hashCode + Objects.hashCode(enableECSManagedTags());
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancers() ? loadBalancers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(propagateTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceRegistries() ? serviceRegistries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceConnectConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumeConfigurations() ? volumeConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcLatticeConfigurations() ? vpcLatticeConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceRequest)) {
            return false;
        }
        UpdateServiceRequest other = (UpdateServiceRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(service(), other.service())
                && Objects.equals(desiredCount(), other.desiredCount())
                && Objects.equals(taskDefinition(), other.taskDefinition())
                && hasCapacityProviderStrategy() == other.hasCapacityProviderStrategy()
                && Objects.equals(capacityProviderStrategy(), other.capacityProviderStrategy())
                && Objects.equals(deploymentConfiguration(), other.deploymentConfiguration())
                && Objects.equals(availabilityZoneRebalancingAsString(), other.availabilityZoneRebalancingAsString())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && hasPlacementConstraints() == other.hasPlacementConstraints()
                && Objects.equals(placementConstraints(), other.placementConstraints())
                && hasPlacementStrategy() == other.hasPlacementStrategy()
                && Objects.equals(placementStrategy(), other.placementStrategy())
                && Objects.equals(platformVersion(), other.platformVersion())
                && Objects.equals(forceNewDeployment(), other.forceNewDeployment())
                && Objects.equals(healthCheckGracePeriodSeconds(), other.healthCheckGracePeriodSeconds())
                && Objects.equals(deploymentController(), other.deploymentController())
                && Objects.equals(enableExecuteCommand(), other.enableExecuteCommand())
                && Objects.equals(enableECSManagedTags(), other.enableECSManagedTags())
                && hasLoadBalancers() == other.hasLoadBalancers() && Objects.equals(loadBalancers(), other.loadBalancers())
                && Objects.equals(propagateTagsAsString(), other.propagateTagsAsString())
                && hasServiceRegistries() == other.hasServiceRegistries()
                && Objects.equals(serviceRegistries(), other.serviceRegistries())
                && Objects.equals(serviceConnectConfiguration(), other.serviceConnectConfiguration())
                && hasVolumeConfigurations() == other.hasVolumeConfigurations()
                && Objects.equals(volumeConfigurations(), other.volumeConfigurations())
                && hasVpcLatticeConfigurations() == other.hasVpcLatticeConfigurations()
                && Objects.equals(vpcLatticeConfigurations(), other.vpcLatticeConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceRequest").add("Cluster", cluster()).add("Service", service())
                .add("DesiredCount", desiredCount()).add("TaskDefinition", taskDefinition())
                .add("CapacityProviderStrategy", hasCapacityProviderStrategy() ? capacityProviderStrategy() : null)
                .add("DeploymentConfiguration", deploymentConfiguration())
                .add("AvailabilityZoneRebalancing", availabilityZoneRebalancingAsString())
                .add("NetworkConfiguration", networkConfiguration())
                .add("PlacementConstraints", hasPlacementConstraints() ? placementConstraints() : null)
                .add("PlacementStrategy", hasPlacementStrategy() ? placementStrategy() : null)
                .add("PlatformVersion", platformVersion()).add("ForceNewDeployment", forceNewDeployment())
                .add("HealthCheckGracePeriodSeconds", healthCheckGracePeriodSeconds())
                .add("DeploymentController", deploymentController()).add("EnableExecuteCommand", enableExecuteCommand())
                .add("EnableECSManagedTags", enableECSManagedTags())
                .add("LoadBalancers", hasLoadBalancers() ? loadBalancers() : null).add("PropagateTags", propagateTagsAsString())
                .add("ServiceRegistries", hasServiceRegistries() ? serviceRegistries() : null)
                .add("ServiceConnectConfiguration", serviceConnectConfiguration())
                .add("VolumeConfigurations", hasVolumeConfigurations() ? volumeConfigurations() : null)
                .add("VpcLatticeConfigurations", hasVpcLatticeConfigurations() ? vpcLatticeConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        case "desiredCount":
            return Optional.ofNullable(clazz.cast(desiredCount()));
        case "taskDefinition":
            return Optional.ofNullable(clazz.cast(taskDefinition()));
        case "capacityProviderStrategy":
            return Optional.ofNullable(clazz.cast(capacityProviderStrategy()));
        case "deploymentConfiguration":
            return Optional.ofNullable(clazz.cast(deploymentConfiguration()));
        case "availabilityZoneRebalancing":
            return Optional.ofNullable(clazz.cast(availabilityZoneRebalancingAsString()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "placementConstraints":
            return Optional.ofNullable(clazz.cast(placementConstraints()));
        case "placementStrategy":
            return Optional.ofNullable(clazz.cast(placementStrategy()));
        case "platformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "forceNewDeployment":
            return Optional.ofNullable(clazz.cast(forceNewDeployment()));
        case "healthCheckGracePeriodSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckGracePeriodSeconds()));
        case "deploymentController":
            return Optional.ofNullable(clazz.cast(deploymentController()));
        case "enableExecuteCommand":
            return Optional.ofNullable(clazz.cast(enableExecuteCommand()));
        case "enableECSManagedTags":
            return Optional.ofNullable(clazz.cast(enableECSManagedTags()));
        case "loadBalancers":
            return Optional.ofNullable(clazz.cast(loadBalancers()));
        case "propagateTags":
            return Optional.ofNullable(clazz.cast(propagateTagsAsString()));
        case "serviceRegistries":
            return Optional.ofNullable(clazz.cast(serviceRegistries()));
        case "serviceConnectConfiguration":
            return Optional.ofNullable(clazz.cast(serviceConnectConfiguration()));
        case "volumeConfigurations":
            return Optional.ofNullable(clazz.cast(volumeConfigurations()));
        case "vpcLatticeConfigurations":
            return Optional.ofNullable(clazz.cast(vpcLatticeConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cluster", CLUSTER_FIELD);
        map.put("service", SERVICE_FIELD);
        map.put("desiredCount", DESIRED_COUNT_FIELD);
        map.put("taskDefinition", TASK_DEFINITION_FIELD);
        map.put("capacityProviderStrategy", CAPACITY_PROVIDER_STRATEGY_FIELD);
        map.put("deploymentConfiguration", DEPLOYMENT_CONFIGURATION_FIELD);
        map.put("availabilityZoneRebalancing", AVAILABILITY_ZONE_REBALANCING_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("placementConstraints", PLACEMENT_CONSTRAINTS_FIELD);
        map.put("placementStrategy", PLACEMENT_STRATEGY_FIELD);
        map.put("platformVersion", PLATFORM_VERSION_FIELD);
        map.put("forceNewDeployment", FORCE_NEW_DEPLOYMENT_FIELD);
        map.put("healthCheckGracePeriodSeconds", HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD);
        map.put("deploymentController", DEPLOYMENT_CONTROLLER_FIELD);
        map.put("enableExecuteCommand", ENABLE_EXECUTE_COMMAND_FIELD);
        map.put("enableECSManagedTags", ENABLE_ECS_MANAGED_TAGS_FIELD);
        map.put("loadBalancers", LOAD_BALANCERS_FIELD);
        map.put("propagateTags", PROPAGATE_TAGS_FIELD);
        map.put("serviceRegistries", SERVICE_REGISTRIES_FIELD);
        map.put("serviceConnectConfiguration", SERVICE_CONNECT_CONFIGURATION_FIELD);
        map.put("volumeConfigurations", VOLUME_CONFIGURATIONS_FIELD);
        map.put("vpcLatticeConfigurations", VPC_LATTICE_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceRequest, T> g) {
        return obj -> g.apply((UpdateServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServiceRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that your service runs on. If you do not
         * specify a cluster, the default cluster is assumed.
         * </p>
         * <p>
         * You can't change the cluster name.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that your service runs on. If you do
         *        not specify a cluster, the default cluster is assumed.</p>
         *        <p>
         *        You can't change the cluster name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The name of the service to update.
         * </p>
         * 
         * @param service
         *        The name of the service to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * The number of instantiations of the task to place and keep running in your service.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * 
         * @param desiredCount
         *        The number of instantiations of the task to place and keep running in your service.</p>
         *        <p>
         *        This parameter doesn't trigger a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCount(Integer desiredCount);

        /**
         * <p>
         * The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task
         * definition to run in your service. If a <code>revision</code> is not specified, the latest
         * <code>ACTIVE</code> revision is used. If you modify the task definition with <code>UpdateService</code>,
         * Amazon ECS spawns a task with the new version of the task definition and then stops an old task after the new
         * version is running.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * 
         * @param taskDefinition
         *        The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the
         *        task definition to run in your service. If a <code>revision</code> is not specified, the latest
         *        <code>ACTIVE</code> revision is used. If you modify the task definition with
         *        <code>UpdateService</code>, Amazon ECS spawns a task with the new version of the task definition and
         *        then stops an old task after the new version is running.</p>
         *        <p>
         *        This parameter triggers a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinition(String taskDefinition);

        /**
         * <p>
         * The details of a capacity provider strategy. You can set a capacity provider when you create a cluster, run a
         * task, or update a service.
         * </p>
         * <p>
         * When you use Fargate, the capacity providers are <code>FARGATE</code> or <code>FARGATE_SPOT</code>.
         * </p>
         * <p>
         * When you use Amazon EC2, the capacity providers are Auto Scaling groups.
         * </p>
         * <p>
         * You can change capacity providers for rolling deployments and blue/green deployments.
         * </p>
         * <p>
         * The following list provides the valid transitions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Update the Fargate launch type to an Auto Scaling group capacity provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the Amazon EC2 launch type to a Fargate capacity provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the Fargate capacity provider to an Auto Scaling group capacity provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the Amazon EC2 capacity provider to a Fargate capacity provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the Auto Scaling group or Fargate capacity provider back to the launch type.
         * </p>
         * <p>
         * Pass an empty list in the <code>capacityProviderStrategy</code> parameter.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For information about Amazon Web Services CDK considerations, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/update-service-parameters.html">Amazon Web
         * Services CDK considerations</a>.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * 
         * @param capacityProviderStrategy
         *        The details of a capacity provider strategy. You can set a capacity provider when you create a
         *        cluster, run a task, or update a service.</p>
         *        <p>
         *        When you use Fargate, the capacity providers are <code>FARGATE</code> or <code>FARGATE_SPOT</code>.
         *        </p>
         *        <p>
         *        When you use Amazon EC2, the capacity providers are Auto Scaling groups.
         *        </p>
         *        <p>
         *        You can change capacity providers for rolling deployments and blue/green deployments.
         *        </p>
         *        <p>
         *        The following list provides the valid transitions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Update the Fargate launch type to an Auto Scaling group capacity provider.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Update the Amazon EC2 launch type to a Fargate capacity provider.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Update the Fargate capacity provider to an Auto Scaling group capacity provider.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Update the Amazon EC2 capacity provider to a Fargate capacity provider.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Update the Auto Scaling group or Fargate capacity provider back to the launch type.
         *        </p>
         *        <p>
         *        Pass an empty list in the <code>capacityProviderStrategy</code> parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For information about Amazon Web Services CDK considerations, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/update-service-parameters.html"
         *        >Amazon Web Services CDK considerations</a>.
         *        </p>
         *        <p>
         *        This parameter doesn't trigger a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy);

        /**
         * <p>
         * The details of a capacity provider strategy. You can set a capacity provider when you create a cluster, run a
         * task, or update a service.
         * </p>
         * <p>
         * When you use Fargate, the capacity providers are <code>FARGATE</code> or <code>FARGATE_SPOT</code>.
         * </p>
         * <p>
         * When you use Amazon EC2, the capacity providers are Auto Scaling groups.
         * </p>
         * <p>
         * You can change capacity providers for rolling deployments and blue/green deployments.
         * </p>
         * <p>
         * The following list provides the valid transitions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Update the Fargate launch type to an Auto Scaling group capacity provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the Amazon EC2 launch type to a Fargate capacity provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the Fargate capacity provider to an Auto Scaling group capacity provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the Amazon EC2 capacity provider to a Fargate capacity provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the Auto Scaling group or Fargate capacity provider back to the launch type.
         * </p>
         * <p>
         * Pass an empty list in the <code>capacityProviderStrategy</code> parameter.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For information about Amazon Web Services CDK considerations, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/update-service-parameters.html">Amazon Web
         * Services CDK considerations</a>.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * 
         * @param capacityProviderStrategy
         *        The details of a capacity provider strategy. You can set a capacity provider when you create a
         *        cluster, run a task, or update a service.</p>
         *        <p>
         *        When you use Fargate, the capacity providers are <code>FARGATE</code> or <code>FARGATE_SPOT</code>.
         *        </p>
         *        <p>
         *        When you use Amazon EC2, the capacity providers are Auto Scaling groups.
         *        </p>
         *        <p>
         *        You can change capacity providers for rolling deployments and blue/green deployments.
         *        </p>
         *        <p>
         *        The following list provides the valid transitions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Update the Fargate launch type to an Auto Scaling group capacity provider.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Update the Amazon EC2 launch type to a Fargate capacity provider.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Update the Fargate capacity provider to an Auto Scaling group capacity provider.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Update the Amazon EC2 capacity provider to a Fargate capacity provider.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Update the Auto Scaling group or Fargate capacity provider back to the launch type.
         *        </p>
         *        <p>
         *        Pass an empty list in the <code>capacityProviderStrategy</code> parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For information about Amazon Web Services CDK considerations, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/update-service-parameters.html"
         *        >Amazon Web Services CDK considerations</a>.
         *        </p>
         *        <p>
         *        This parameter doesn't trigger a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderStrategy(CapacityProviderStrategyItem... capacityProviderStrategy);

        /**
         * <p>
         * The details of a capacity provider strategy. You can set a capacity provider when you create a cluster, run a
         * task, or update a service.
         * </p>
         * <p>
         * When you use Fargate, the capacity providers are <code>FARGATE</code> or <code>FARGATE_SPOT</code>.
         * </p>
         * <p>
         * When you use Amazon EC2, the capacity providers are Auto Scaling groups.
         * </p>
         * <p>
         * You can change capacity providers for rolling deployments and blue/green deployments.
         * </p>
         * <p>
         * The following list provides the valid transitions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Update the Fargate launch type to an Auto Scaling group capacity provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the Amazon EC2 launch type to a Fargate capacity provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the Fargate capacity provider to an Auto Scaling group capacity provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the Amazon EC2 capacity provider to a Fargate capacity provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the Auto Scaling group or Fargate capacity provider back to the launch type.
         * </p>
         * <p>
         * Pass an empty list in the <code>capacityProviderStrategy</code> parameter.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For information about Amazon Web Services CDK considerations, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/update-service-parameters.html">Amazon Web
         * Services CDK considerations</a>.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem.Builder#build()} is called
         * immediately and its result is passed to {@link #capacityProviderStrategy(List<CapacityProviderStrategyItem>)}.
         * 
         * @param capacityProviderStrategy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityProviderStrategy(java.util.Collection<CapacityProviderStrategyItem>)
         */
        Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder>... capacityProviderStrategy);

        /**
         * <p>
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of
         * stopping and starting tasks.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * 
         * @param deploymentConfiguration
         *        Optional deployment parameters that control how many tasks run during the deployment and the ordering
         *        of stopping and starting tasks.</p>
         *        <p>
         *        This parameter doesn't trigger a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration);

        /**
         * <p>
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of
         * stopping and starting tasks.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentConfiguration.Builder} avoiding
         * the need to create one manually via {@link DeploymentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #deploymentConfiguration(DeploymentConfiguration)}.
         * 
         * @param deploymentConfiguration
         *        a consumer that will call methods on {@link DeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfiguration(DeploymentConfiguration)
         */
        default Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return deploymentConfiguration(DeploymentConfiguration.builder().applyMutation(deploymentConfiguration).build());
        }

        /**
         * <p>
         * Indicates whether to use Availability Zone rebalancing for the service.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an
         * Amazon ECS service across Availability Zones</a> in the <i> <i>Amazon Elastic Container Service Developer
         * Guide</i> </i>.
         * </p>
         * <p>
         * The default behavior of <code>AvailabilityZoneRebalancing</code> differs between create and update requests:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For create service requests, when when no value is specified for <code>AvailabilityZoneRebalancing</code>,
         * Amazon ECS defaults the value to to <code>ENABLED</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For update service requests, when no value is specified for <code>AvailabilityZoneRebalancing</code>, Amazon
         * ECS defaults to the existing service’s <code>AvailabilityZoneRebalancing</code> value. If the service never
         * had an <code>AvailabilityZoneRebalancing</code> value set, Amazon ECS treats this as <code>DISABLED</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * 
         * @param availabilityZoneRebalancing
         *        Indicates whether to use Availability Zone rebalancing for the service.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing
         *        an Amazon ECS service across Availability Zones</a> in the <i> <i>Amazon Elastic Container Service
         *        Developer Guide</i> </i>.
         *        </p>
         *        <p>
         *        The default behavior of <code>AvailabilityZoneRebalancing</code> differs between create and update
         *        requests:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For create service requests, when when no value is specified for
         *        <code>AvailabilityZoneRebalancing</code>, Amazon ECS defaults the value to to <code>ENABLED</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For update service requests, when no value is specified for <code>AvailabilityZoneRebalancing</code>,
         *        Amazon ECS defaults to the existing service’s <code>AvailabilityZoneRebalancing</code> value. If the
         *        service never had an <code>AvailabilityZoneRebalancing</code> value set, Amazon ECS treats this as
         *        <code>DISABLED</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This parameter doesn't trigger a new service deployment.
         * @see AvailabilityZoneRebalancing
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityZoneRebalancing
         */
        Builder availabilityZoneRebalancing(String availabilityZoneRebalancing);

        /**
         * <p>
         * Indicates whether to use Availability Zone rebalancing for the service.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an
         * Amazon ECS service across Availability Zones</a> in the <i> <i>Amazon Elastic Container Service Developer
         * Guide</i> </i>.
         * </p>
         * <p>
         * The default behavior of <code>AvailabilityZoneRebalancing</code> differs between create and update requests:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For create service requests, when when no value is specified for <code>AvailabilityZoneRebalancing</code>,
         * Amazon ECS defaults the value to to <code>ENABLED</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For update service requests, when no value is specified for <code>AvailabilityZoneRebalancing</code>, Amazon
         * ECS defaults to the existing service’s <code>AvailabilityZoneRebalancing</code> value. If the service never
         * had an <code>AvailabilityZoneRebalancing</code> value set, Amazon ECS treats this as <code>DISABLED</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * 
         * @param availabilityZoneRebalancing
         *        Indicates whether to use Availability Zone rebalancing for the service.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing
         *        an Amazon ECS service across Availability Zones</a> in the <i> <i>Amazon Elastic Container Service
         *        Developer Guide</i> </i>.
         *        </p>
         *        <p>
         *        The default behavior of <code>AvailabilityZoneRebalancing</code> differs between create and update
         *        requests:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For create service requests, when when no value is specified for
         *        <code>AvailabilityZoneRebalancing</code>, Amazon ECS defaults the value to to <code>ENABLED</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For update service requests, when no value is specified for <code>AvailabilityZoneRebalancing</code>,
         *        Amazon ECS defaults to the existing service’s <code>AvailabilityZoneRebalancing</code> value. If the
         *        service never had an <code>AvailabilityZoneRebalancing</code> value set, Amazon ECS treats this as
         *        <code>DISABLED</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This parameter doesn't trigger a new service deployment.
         * @see AvailabilityZoneRebalancing
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityZoneRebalancing
         */
        Builder availabilityZoneRebalancing(AvailabilityZoneRebalancing availabilityZoneRebalancing);

        /**
         * <p>
         * An object representing the network configuration for the service.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * 
         * @param networkConfiguration
         *        An object representing the network configuration for the service.</p>
         *        <p>
         *        This parameter triggers a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * An object representing the network configuration for the service.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * An array of task placement constraint objects to update the service to use. If no value is specified, the
         * existing placement constraints for the service will remain unchanged. If this value is specified, it will
         * override any existing placement constraints defined for the service. To remove all existing placement
         * constraints, specify an empty array.
         * </p>
         * <p>
         * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task
         * definition and those specified at runtime.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * 
         * @param placementConstraints
         *        An array of task placement constraint objects to update the service to use. If no value is specified,
         *        the existing placement constraints for the service will remain unchanged. If this value is specified,
         *        it will override any existing placement constraints defined for the service. To remove all existing
         *        placement constraints, specify an empty array.</p>
         *        <p>
         *        You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task
         *        definition and those specified at runtime.
         *        </p>
         *        <p>
         *        This parameter doesn't trigger a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(Collection<PlacementConstraint> placementConstraints);

        /**
         * <p>
         * An array of task placement constraint objects to update the service to use. If no value is specified, the
         * existing placement constraints for the service will remain unchanged. If this value is specified, it will
         * override any existing placement constraints defined for the service. To remove all existing placement
         * constraints, specify an empty array.
         * </p>
         * <p>
         * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task
         * definition and those specified at runtime.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * 
         * @param placementConstraints
         *        An array of task placement constraint objects to update the service to use. If no value is specified,
         *        the existing placement constraints for the service will remain unchanged. If this value is specified,
         *        it will override any existing placement constraints defined for the service. To remove all existing
         *        placement constraints, specify an empty array.</p>
         *        <p>
         *        You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task
         *        definition and those specified at runtime.
         *        </p>
         *        <p>
         *        This parameter doesn't trigger a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(PlacementConstraint... placementConstraints);

        /**
         * <p>
         * An array of task placement constraint objects to update the service to use. If no value is specified, the
         * existing placement constraints for the service will remain unchanged. If this value is specified, it will
         * override any existing placement constraints defined for the service. To remove all existing placement
         * constraints, specify an empty array.
         * </p>
         * <p>
         * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task
         * definition and those specified at runtime.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.PlacementConstraint.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.PlacementConstraint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.PlacementConstraint.Builder#build()} is called immediately
         * and its result is passed to {@link #placementConstraints(List<PlacementConstraint>)}.
         * 
         * @param placementConstraints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.PlacementConstraint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementConstraints(java.util.Collection<PlacementConstraint>)
         */
        Builder placementConstraints(Consumer<PlacementConstraint.Builder>... placementConstraints);

        /**
         * <p>
         * The task placement strategy objects to update the service to use. If no value is specified, the existing
         * placement strategy for the service will remain unchanged. If this value is specified, it will override the
         * existing placement strategy defined for the service. To remove an existing placement strategy, specify an
         * empty object.
         * </p>
         * <p>
         * You can specify a maximum of five strategy rules for each service.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * 
         * @param placementStrategy
         *        The task placement strategy objects to update the service to use. If no value is specified, the
         *        existing placement strategy for the service will remain unchanged. If this value is specified, it will
         *        override the existing placement strategy defined for the service. To remove an existing placement
         *        strategy, specify an empty object.</p>
         *        <p>
         *        You can specify a maximum of five strategy rules for each service.
         *        </p>
         *        <p>
         *        This parameter doesn't trigger a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStrategy(Collection<PlacementStrategy> placementStrategy);

        /**
         * <p>
         * The task placement strategy objects to update the service to use. If no value is specified, the existing
         * placement strategy for the service will remain unchanged. If this value is specified, it will override the
         * existing placement strategy defined for the service. To remove an existing placement strategy, specify an
         * empty object.
         * </p>
         * <p>
         * You can specify a maximum of five strategy rules for each service.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * 
         * @param placementStrategy
         *        The task placement strategy objects to update the service to use. If no value is specified, the
         *        existing placement strategy for the service will remain unchanged. If this value is specified, it will
         *        override the existing placement strategy defined for the service. To remove an existing placement
         *        strategy, specify an empty object.</p>
         *        <p>
         *        You can specify a maximum of five strategy rules for each service.
         *        </p>
         *        <p>
         *        This parameter doesn't trigger a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStrategy(PlacementStrategy... placementStrategy);

        /**
         * <p>
         * The task placement strategy objects to update the service to use. If no value is specified, the existing
         * placement strategy for the service will remain unchanged. If this value is specified, it will override the
         * existing placement strategy defined for the service. To remove an existing placement strategy, specify an
         * empty object.
         * </p>
         * <p>
         * You can specify a maximum of five strategy rules for each service.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.PlacementStrategy.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.PlacementStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.PlacementStrategy.Builder#build()} is called immediately and
         * its result is passed to {@link #placementStrategy(List<PlacementStrategy>)}.
         * 
         * @param placementStrategy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.PlacementStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementStrategy(java.util.Collection<PlacementStrategy>)
         */
        Builder placementStrategy(Consumer<PlacementStrategy.Builder>... placementStrategy);

        /**
         * <p>
         * The platform version that your tasks in the service run on. A platform version is only specified for tasks
         * using the Fargate launch type. If a platform version is not specified, the <code>LATEST</code> platform
         * version is used. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
         * Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * 
         * @param platformVersion
         *        The platform version that your tasks in the service run on. A platform version is only specified for
         *        tasks using the Fargate launch type. If a platform version is not specified, the <code>LATEST</code>
         *        platform version is used. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate
         *        Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
         *        <p>
         *        This parameter triggers a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * Determines whether to force a new deployment of the service. By default, deployments aren't forced. You can
         * use this option to start a new deployment with no service definition changes. For example, you can update a
         * service's tasks to use a newer Docker image with the same image/tag combination (<code>my_image:latest</code>
         * ) or to roll Fargate tasks onto a newer platform version.
         * </p>
         * 
         * @param forceNewDeployment
         *        Determines whether to force a new deployment of the service. By default, deployments aren't forced.
         *        You can use this option to start a new deployment with no service definition changes. For example, you
         *        can update a service's tasks to use a newer Docker image with the same image/tag combination (
         *        <code>my_image:latest</code>) or to roll Fargate tasks onto a newer platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceNewDeployment(Boolean forceNewDeployment);

        /**
         * <p>
         * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load
         * Balancing, VPC Lattice, and container health checks after a task has first started. If you don't specify a
         * health check grace period value, the default value of <code>0</code> is used. If you don't use any of the
         * health checks, then <code>healthCheckGracePeriodSeconds</code> is unused.
         * </p>
         * <p>
         * If your service's tasks take a while to start and respond to health checks, you can specify a health check
         * grace period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS service
         * scheduler ignores health check status. This grace period can prevent the service scheduler from marking tasks
         * as unhealthy and stopping them before they have time to come up.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * 
         * @param healthCheckGracePeriodSeconds
         *        The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load
         *        Balancing, VPC Lattice, and container health checks after a task has first started. If you don't
         *        specify a health check grace period value, the default value of <code>0</code> is used. If you don't
         *        use any of the health checks, then <code>healthCheckGracePeriodSeconds</code> is unused.</p>
         *        <p>
         *        If your service's tasks take a while to start and respond to health checks, you can specify a health
         *        check grace period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS
         *        service scheduler ignores health check status. This grace period can prevent the service scheduler
         *        from marking tasks as unhealthy and stopping them before they have time to come up.
         *        </p>
         *        <p>
         *        This parameter doesn't trigger a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds);

        /**
         * Sets the value of the DeploymentController property for this object.
         *
         * @param deploymentController
         *        The new value for the DeploymentController property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentController(DeploymentController deploymentController);

        /**
         * Sets the value of the DeploymentController property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DeploymentController.Builder} avoiding
         * the need to create one manually via {@link DeploymentController#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentController.Builder#build()} is called immediately and
         * its result is passed to {@link #deploymentController(DeploymentController)}.
         * 
         * @param deploymentController
         *        a consumer that will call methods on {@link DeploymentController.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentController(DeploymentController)
         */
        default Builder deploymentController(Consumer<DeploymentController.Builder> deploymentController) {
            return deploymentController(DeploymentController.builder().applyMutation(deploymentController).build());
        }

        /**
         * <p>
         * If <code>true</code>, this enables execute command functionality on all task containers.
         * </p>
         * <p>
         * If you do not want to override the value that was set when the service was created, you can set this to
         * <code>null</code> when performing this action.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * 
         * @param enableExecuteCommand
         *        If <code>true</code>, this enables execute command functionality on all task containers.</p>
         *        <p>
         *        If you do not want to override the value that was set when the service was created, you can set this
         *        to <code>null</code> when performing this action.
         *        </p>
         *        <p>
         *        This parameter doesn't trigger a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableExecuteCommand(Boolean enableExecuteCommand);

        /**
         * <p>
         * Determines whether to turn on Amazon ECS managed tags for the tasks in the service. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon
         * ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
         * <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated
         * tags.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * 
         * @param enableECSManagedTags
         *        Determines whether to turn on Amazon ECS managed tags for the tasks in the service. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your
         *        Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
         *        <p>
         *        Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
         *        <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the
         *        updated tags.
         *        </p>
         *        <p>
         *        This parameter doesn't trigger a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableECSManagedTags(Boolean enableECSManagedTags);

        /**
         * <note>
         * <p>
         * You must have a service-linked role when you update this property
         * </p>
         * </note>
         * <p>
         * A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container
         * name, and the container port to access from the load balancer. The container name is as it appears in a
         * container definition.
         * </p>
         * <p>
         * When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the updated
         * Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are running.
         * </p>
         * <p>
         * For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target groups.
         * You can update from a single target group to multiple target groups and from multiple target groups to a
         * single target group.
         * </p>
         * <p>
         * For services that use blue/green deployments, you can update Elastic Load Balancing target groups by using
         * <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code>
         * through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For more
         * information see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
         * >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer
         * Guide</i>.
         * </p>
         * <p>
         * For services that use the external deployment controller, you can add, update, or remove load balancers by
         * using <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet</a>.
         * Note that multiple target groups are not supported for external deployments. For more information see <a
         * href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Register
         * multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * You can remove existing <code>loadBalancers</code> by passing an empty list.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * 
         * @param loadBalancers
         *        <p>
         *        You must have a service-linked role when you update this property
         *        </p>
         *        </note>
         *        <p>
         *        A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the
         *        container name, and the container port to access from the load balancer. The container name is as it
         *        appears in a container definition.
         *        </p>
         *        <p>
         *        When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the
         *        updated Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are
         *        running.
         *        </p>
         *        <p>
         *        For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target
         *        groups. You can update from a single target group to multiple target groups and from multiple target
         *        groups to a single target group.
         *        </p>
         *        <p>
         *        For services that use blue/green deployments, you can update Elastic Load Balancing target groups by
         *        using
         *        <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code>
         *        through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For
         *        more information see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
         *        >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service
         *        Developer Guide</i>.
         *        </p>
         *        <p>
         *        For services that use the external deployment controller, you can add, update, or remove load
         *        balancers by using <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html"
         *        >CreateTaskSet</a>. Note that multiple target groups are not supported for external deployments. For
         *        more information see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
         *        >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service
         *        Developer Guide</i>.
         *        </p>
         *        <p>
         *        You can remove existing <code>loadBalancers</code> by passing an empty list.
         *        </p>
         *        <p>
         *        This parameter triggers a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(Collection<LoadBalancer> loadBalancers);

        /**
         * <note>
         * <p>
         * You must have a service-linked role when you update this property
         * </p>
         * </note>
         * <p>
         * A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container
         * name, and the container port to access from the load balancer. The container name is as it appears in a
         * container definition.
         * </p>
         * <p>
         * When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the updated
         * Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are running.
         * </p>
         * <p>
         * For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target groups.
         * You can update from a single target group to multiple target groups and from multiple target groups to a
         * single target group.
         * </p>
         * <p>
         * For services that use blue/green deployments, you can update Elastic Load Balancing target groups by using
         * <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code>
         * through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For more
         * information see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
         * >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer
         * Guide</i>.
         * </p>
         * <p>
         * For services that use the external deployment controller, you can add, update, or remove load balancers by
         * using <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet</a>.
         * Note that multiple target groups are not supported for external deployments. For more information see <a
         * href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Register
         * multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * You can remove existing <code>loadBalancers</code> by passing an empty list.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * 
         * @param loadBalancers
         *        <p>
         *        You must have a service-linked role when you update this property
         *        </p>
         *        </note>
         *        <p>
         *        A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the
         *        container name, and the container port to access from the load balancer. The container name is as it
         *        appears in a container definition.
         *        </p>
         *        <p>
         *        When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the
         *        updated Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are
         *        running.
         *        </p>
         *        <p>
         *        For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target
         *        groups. You can update from a single target group to multiple target groups and from multiple target
         *        groups to a single target group.
         *        </p>
         *        <p>
         *        For services that use blue/green deployments, you can update Elastic Load Balancing target groups by
         *        using
         *        <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code>
         *        through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For
         *        more information see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
         *        >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service
         *        Developer Guide</i>.
         *        </p>
         *        <p>
         *        For services that use the external deployment controller, you can add, update, or remove load
         *        balancers by using <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html"
         *        >CreateTaskSet</a>. Note that multiple target groups are not supported for external deployments. For
         *        more information see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
         *        >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service
         *        Developer Guide</i>.
         *        </p>
         *        <p>
         *        You can remove existing <code>loadBalancers</code> by passing an empty list.
         *        </p>
         *        <p>
         *        This parameter triggers a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(LoadBalancer... loadBalancers);

        /**
         * <note>
         * <p>
         * You must have a service-linked role when you update this property
         * </p>
         * </note>
         * <p>
         * A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container
         * name, and the container port to access from the load balancer. The container name is as it appears in a
         * container definition.
         * </p>
         * <p>
         * When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the updated
         * Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are running.
         * </p>
         * <p>
         * For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target groups.
         * You can update from a single target group to multiple target groups and from multiple target groups to a
         * single target group.
         * </p>
         * <p>
         * For services that use blue/green deployments, you can update Elastic Load Balancing target groups by using
         * <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code>
         * through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For more
         * information see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
         * >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer
         * Guide</i>.
         * </p>
         * <p>
         * For services that use the external deployment controller, you can add, update, or remove load balancers by
         * using <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet</a>.
         * Note that multiple target groups are not supported for external deployments. For more information see <a
         * href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Register
         * multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * You can remove existing <code>loadBalancers</code> by passing an empty list.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.LoadBalancer.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.LoadBalancer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.LoadBalancer.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancers(List<LoadBalancer>)}.
         * 
         * @param loadBalancers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.LoadBalancer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancers(java.util.Collection<LoadBalancer>)
         */
        Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers);

        /**
         * <p>
         * Determines whether to propagate the tags from the task definition or the service to the task. If no value is
         * specified, the tags aren't propagated.
         * </p>
         * <p>
         * Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
         * <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated
         * tags.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * 
         * @param propagateTags
         *        Determines whether to propagate the tags from the task definition or the service to the task. If no
         *        value is specified, the tags aren't propagated.</p>
         *        <p>
         *        Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
         *        <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the
         *        updated tags.
         *        </p>
         *        <p>
         *        This parameter doesn't trigger a new service deployment.
         * @see PropagateTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropagateTags
         */
        Builder propagateTags(String propagateTags);

        /**
         * <p>
         * Determines whether to propagate the tags from the task definition or the service to the task. If no value is
         * specified, the tags aren't propagated.
         * </p>
         * <p>
         * Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
         * <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated
         * tags.
         * </p>
         * <p>
         * This parameter doesn't trigger a new service deployment.
         * </p>
         * 
         * @param propagateTags
         *        Determines whether to propagate the tags from the task definition or the service to the task. If no
         *        value is specified, the tags aren't propagated.</p>
         *        <p>
         *        Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
         *        <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the
         *        updated tags.
         *        </p>
         *        <p>
         *        This parameter doesn't trigger a new service deployment.
         * @see PropagateTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropagateTags
         */
        Builder propagateTags(PropagateTags propagateTags);

        /**
         * <note>
         * <p>
         * You must have a service-linked role when you update this property.
         * </p>
         * <p>
         * For more information about the role see the <code>CreateService</code> request parameter <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html#ECS-CreateService-request-role"
         * > <code>role</code> </a>.
         * </p>
         * </note>
         * <p>
         * The details for the service discovery registries to assign to this service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * <p>
         * When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with the
         * updated service registries configuration, and then stops the old tasks when the new tasks are running.
         * </p>
         * <p>
         * You can remove existing <code>serviceRegistries</code> by passing an empty list.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * 
         * @param serviceRegistries
         *        <p>
         *        You must have a service-linked role when you update this property.
         *        </p>
         *        <p>
         *        For more information about the role see the <code>CreateService</code> request parameter <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html#ECS-CreateService-request-role"
         *        > <code>role</code> </a>.
         *        </p>
         *        </note>
         *        <p>
         *        The details for the service discovery registries to assign to this service. For more information, see
         *        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         *        Discovery</a>.
         *        </p>
         *        <p>
         *        When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with
         *        the updated service registries configuration, and then stops the old tasks when the new tasks are
         *        running.
         *        </p>
         *        <p>
         *        You can remove existing <code>serviceRegistries</code> by passing an empty list.
         *        </p>
         *        <p>
         *        This parameter triggers a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries);

        /**
         * <note>
         * <p>
         * You must have a service-linked role when you update this property.
         * </p>
         * <p>
         * For more information about the role see the <code>CreateService</code> request parameter <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html#ECS-CreateService-request-role"
         * > <code>role</code> </a>.
         * </p>
         * </note>
         * <p>
         * The details for the service discovery registries to assign to this service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * <p>
         * When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with the
         * updated service registries configuration, and then stops the old tasks when the new tasks are running.
         * </p>
         * <p>
         * You can remove existing <code>serviceRegistries</code> by passing an empty list.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * 
         * @param serviceRegistries
         *        <p>
         *        You must have a service-linked role when you update this property.
         *        </p>
         *        <p>
         *        For more information about the role see the <code>CreateService</code> request parameter <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html#ECS-CreateService-request-role"
         *        > <code>role</code> </a>.
         *        </p>
         *        </note>
         *        <p>
         *        The details for the service discovery registries to assign to this service. For more information, see
         *        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         *        Discovery</a>.
         *        </p>
         *        <p>
         *        When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with
         *        the updated service registries configuration, and then stops the old tasks when the new tasks are
         *        running.
         *        </p>
         *        <p>
         *        You can remove existing <code>serviceRegistries</code> by passing an empty list.
         *        </p>
         *        <p>
         *        This parameter triggers a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegistries(ServiceRegistry... serviceRegistries);

        /**
         * <note>
         * <p>
         * You must have a service-linked role when you update this property.
         * </p>
         * <p>
         * For more information about the role see the <code>CreateService</code> request parameter <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html#ECS-CreateService-request-role"
         * > <code>role</code> </a>.
         * </p>
         * </note>
         * <p>
         * The details for the service discovery registries to assign to this service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * <p>
         * When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with the
         * updated service registries configuration, and then stops the old tasks when the new tasks are running.
         * </p>
         * <p>
         * You can remove existing <code>serviceRegistries</code> by passing an empty list.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ServiceRegistry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.ServiceRegistry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ServiceRegistry.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceRegistries(List<ServiceRegistry>)}.
         * 
         * @param serviceRegistries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ServiceRegistry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceRegistries(java.util.Collection<ServiceRegistry>)
         */
        Builder serviceRegistries(Consumer<ServiceRegistry.Builder>... serviceRegistries);

        /**
         * <p>
         * The configuration for this service to discover and connect to services, and be discovered by, and connected
         * from, other services within a namespace.
         * </p>
         * <p>
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect
         * to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that
         * collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are
         * supported with Service Connect. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a>
         * in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * 
         * @param serviceConnectConfiguration
         *        The configuration for this service to discover and connect to services, and be discovered by, and
         *        connected from, other services within a namespace.</p>
         *        <p>
         *        Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can
         *        connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy
         *        container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS
         *        services create are supported with Service Connect. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service
         *        Connect</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        This parameter triggers a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceConnectConfiguration(ServiceConnectConfiguration serviceConnectConfiguration);

        /**
         * <p>
         * The configuration for this service to discover and connect to services, and be discovered by, and connected
         * from, other services within a namespace.
         * </p>
         * <p>
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect
         * to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that
         * collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are
         * supported with Service Connect. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a>
         * in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceConnectConfiguration.Builder}
         * avoiding the need to create one manually via {@link ServiceConnectConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceConnectConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceConnectConfiguration(ServiceConnectConfiguration)}.
         * 
         * @param serviceConnectConfiguration
         *        a consumer that will call methods on {@link ServiceConnectConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceConnectConfiguration(ServiceConnectConfiguration)
         */
        default Builder serviceConnectConfiguration(Consumer<ServiceConnectConfiguration.Builder> serviceConnectConfiguration) {
            return serviceConnectConfiguration(ServiceConnectConfiguration.builder().applyMutation(serviceConnectConfiguration)
                    .build());
        }

        /**
         * <p>
         * The details of the volume that was <code>configuredAtLaunch</code>. You can configure the size, volumeType,
         * IOPS, throughput, snapshot and encryption in <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ServiceManagedEBSVolumeConfiguration.html"
         * >ServiceManagedEBSVolumeConfiguration</a>. The <code>name</code> of the volume must match the
         * <code>name</code> from the task definition. If set to null, no new deployment is triggered. Otherwise, if
         * this configuration differs from the existing one, it triggers a new deployment.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * 
         * @param volumeConfigurations
         *        The details of the volume that was <code>configuredAtLaunch</code>. You can configure the size,
         *        volumeType, IOPS, throughput, snapshot and encryption in <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ServiceManagedEBSVolumeConfiguration.html"
         *        >ServiceManagedEBSVolumeConfiguration</a>. The <code>name</code> of the volume must match the
         *        <code>name</code> from the task definition. If set to null, no new deployment is triggered. Otherwise,
         *        if this configuration differs from the existing one, it triggers a new deployment.</p>
         *        <p>
         *        This parameter triggers a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeConfigurations(Collection<ServiceVolumeConfiguration> volumeConfigurations);

        /**
         * <p>
         * The details of the volume that was <code>configuredAtLaunch</code>. You can configure the size, volumeType,
         * IOPS, throughput, snapshot and encryption in <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ServiceManagedEBSVolumeConfiguration.html"
         * >ServiceManagedEBSVolumeConfiguration</a>. The <code>name</code> of the volume must match the
         * <code>name</code> from the task definition. If set to null, no new deployment is triggered. Otherwise, if
         * this configuration differs from the existing one, it triggers a new deployment.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * 
         * @param volumeConfigurations
         *        The details of the volume that was <code>configuredAtLaunch</code>. You can configure the size,
         *        volumeType, IOPS, throughput, snapshot and encryption in <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ServiceManagedEBSVolumeConfiguration.html"
         *        >ServiceManagedEBSVolumeConfiguration</a>. The <code>name</code> of the volume must match the
         *        <code>name</code> from the task definition. If set to null, no new deployment is triggered. Otherwise,
         *        if this configuration differs from the existing one, it triggers a new deployment.</p>
         *        <p>
         *        This parameter triggers a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeConfigurations(ServiceVolumeConfiguration... volumeConfigurations);

        /**
         * <p>
         * The details of the volume that was <code>configuredAtLaunch</code>. You can configure the size, volumeType,
         * IOPS, throughput, snapshot and encryption in <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ServiceManagedEBSVolumeConfiguration.html"
         * >ServiceManagedEBSVolumeConfiguration</a>. The <code>name</code> of the volume must match the
         * <code>name</code> from the task definition. If set to null, no new deployment is triggered. Otherwise, if
         * this configuration differs from the existing one, it triggers a new deployment.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ServiceVolumeConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ecs.model.ServiceVolumeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ServiceVolumeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #volumeConfigurations(List<ServiceVolumeConfiguration>)}.
         * 
         * @param volumeConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ServiceVolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeConfigurations(java.util.Collection<ServiceVolumeConfiguration>)
         */
        Builder volumeConfigurations(Consumer<ServiceVolumeConfiguration.Builder>... volumeConfigurations);

        /**
         * <p>
         * An object representing the VPC Lattice configuration for the service being updated.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * 
         * @param vpcLatticeConfigurations
         *        An object representing the VPC Lattice configuration for the service being updated.</p>
         *        <p>
         *        This parameter triggers a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcLatticeConfigurations(Collection<VpcLatticeConfiguration> vpcLatticeConfigurations);

        /**
         * <p>
         * An object representing the VPC Lattice configuration for the service being updated.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * 
         * @param vpcLatticeConfigurations
         *        An object representing the VPC Lattice configuration for the service being updated.</p>
         *        <p>
         *        This parameter triggers a new service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcLatticeConfigurations(VpcLatticeConfiguration... vpcLatticeConfigurations);

        /**
         * <p>
         * An object representing the VPC Lattice configuration for the service being updated.
         * </p>
         * <p>
         * This parameter triggers a new service deployment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.VpcLatticeConfiguration.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ecs.model.VpcLatticeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.VpcLatticeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcLatticeConfigurations(List<VpcLatticeConfiguration>)}.
         * 
         * @param vpcLatticeConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.VpcLatticeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcLatticeConfigurations(java.util.Collection<VpcLatticeConfiguration>)
         */
        Builder vpcLatticeConfigurations(Consumer<VpcLatticeConfiguration.Builder>... vpcLatticeConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String service;

        private Integer desiredCount;

        private String taskDefinition;

        private List<CapacityProviderStrategyItem> capacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();

        private DeploymentConfiguration deploymentConfiguration;

        private String availabilityZoneRebalancing;

        private NetworkConfiguration networkConfiguration;

        private List<PlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();

        private List<PlacementStrategy> placementStrategy = DefaultSdkAutoConstructList.getInstance();

        private String platformVersion;

        private Boolean forceNewDeployment;

        private Integer healthCheckGracePeriodSeconds;

        private DeploymentController deploymentController;

        private Boolean enableExecuteCommand;

        private Boolean enableECSManagedTags;

        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();

        private String propagateTags;

        private List<ServiceRegistry> serviceRegistries = DefaultSdkAutoConstructList.getInstance();

        private ServiceConnectConfiguration serviceConnectConfiguration;

        private List<ServiceVolumeConfiguration> volumeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<VpcLatticeConfiguration> vpcLatticeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceRequest model) {
            super(model);
            cluster(model.cluster);
            service(model.service);
            desiredCount(model.desiredCount);
            taskDefinition(model.taskDefinition);
            capacityProviderStrategy(model.capacityProviderStrategy);
            deploymentConfiguration(model.deploymentConfiguration);
            availabilityZoneRebalancing(model.availabilityZoneRebalancing);
            networkConfiguration(model.networkConfiguration);
            placementConstraints(model.placementConstraints);
            placementStrategy(model.placementStrategy);
            platformVersion(model.platformVersion);
            forceNewDeployment(model.forceNewDeployment);
            healthCheckGracePeriodSeconds(model.healthCheckGracePeriodSeconds);
            deploymentController(model.deploymentController);
            enableExecuteCommand(model.enableExecuteCommand);
            enableECSManagedTags(model.enableECSManagedTags);
            loadBalancers(model.loadBalancers);
            propagateTags(model.propagateTags);
            serviceRegistries(model.serviceRegistries);
            serviceConnectConfiguration(model.serviceConnectConfiguration);
            volumeConfigurations(model.volumeConfigurations);
            vpcLatticeConfigurations(model.vpcLatticeConfigurations);
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Integer getDesiredCount() {
            return desiredCount;
        }

        public final void setDesiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
        }

        @Override
        public final Builder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final String getTaskDefinition() {
            return taskDefinition;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final List<CapacityProviderStrategyItem.Builder> getCapacityProviderStrategy() {
            List<CapacityProviderStrategyItem.Builder> result = CapacityProviderStrategyCopier
                    .copyToBuilder(this.capacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityProviderStrategy(
                Collection<CapacityProviderStrategyItem.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(capacityProviderStrategy);
        }

        @Override
        public final Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(CapacityProviderStrategyItem... capacityProviderStrategy) {
            capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder>... capacityProviderStrategy) {
            capacityProviderStrategy(Stream.of(capacityProviderStrategy)
                    .map(c -> CapacityProviderStrategyItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return deploymentConfiguration != null ? deploymentConfiguration.toBuilder() : null;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final String getAvailabilityZoneRebalancing() {
            return availabilityZoneRebalancing;
        }

        public final void setAvailabilityZoneRebalancing(String availabilityZoneRebalancing) {
            this.availabilityZoneRebalancing = availabilityZoneRebalancing;
        }

        @Override
        public final Builder availabilityZoneRebalancing(String availabilityZoneRebalancing) {
            this.availabilityZoneRebalancing = availabilityZoneRebalancing;
            return this;
        }

        @Override
        public final Builder availabilityZoneRebalancing(AvailabilityZoneRebalancing availabilityZoneRebalancing) {
            this.availabilityZoneRebalancing(availabilityZoneRebalancing == null ? null : availabilityZoneRebalancing.toString());
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final List<PlacementConstraint.Builder> getPlacementConstraints() {
            List<PlacementConstraint.Builder> result = PlacementConstraintsCopier.copyToBuilder(this.placementConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementConstraints(Collection<PlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        @Override
        public final Builder placementConstraints(Collection<PlacementConstraint> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(PlacementConstraint... placementConstraints) {
            placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<PlacementConstraint.Builder>... placementConstraints) {
            placementConstraints(Stream.of(placementConstraints).map(c -> PlacementConstraint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PlacementStrategy.Builder> getPlacementStrategy() {
            List<PlacementStrategy.Builder> result = PlacementStrategiesCopier.copyToBuilder(this.placementStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementStrategy(Collection<PlacementStrategy.BuilderImpl> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copyFromBuilder(placementStrategy);
        }

        @Override
        public final Builder placementStrategy(Collection<PlacementStrategy> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copy(placementStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(PlacementStrategy... placementStrategy) {
            placementStrategy(Arrays.asList(placementStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(Consumer<PlacementStrategy.Builder>... placementStrategy) {
            placementStrategy(Stream.of(placementStrategy).map(c -> PlacementStrategy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final Boolean getForceNewDeployment() {
            return forceNewDeployment;
        }

        public final void setForceNewDeployment(Boolean forceNewDeployment) {
            this.forceNewDeployment = forceNewDeployment;
        }

        @Override
        public final Builder forceNewDeployment(Boolean forceNewDeployment) {
            this.forceNewDeployment = forceNewDeployment;
            return this;
        }

        public final Integer getHealthCheckGracePeriodSeconds() {
            return healthCheckGracePeriodSeconds;
        }

        public final void setHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
        }

        @Override
        public final Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
            return this;
        }

        public final DeploymentController.Builder getDeploymentController() {
            return deploymentController != null ? deploymentController.toBuilder() : null;
        }

        public final void setDeploymentController(DeploymentController.BuilderImpl deploymentController) {
            this.deploymentController = deploymentController != null ? deploymentController.build() : null;
        }

        @Override
        public final Builder deploymentController(DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        public final Boolean getEnableExecuteCommand() {
            return enableExecuteCommand;
        }

        public final void setEnableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
        }

        @Override
        public final Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        public final Boolean getEnableECSManagedTags() {
            return enableECSManagedTags;
        }

        public final void setEnableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
        }

        @Override
        public final Builder enableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
            return this;
        }

        public final List<LoadBalancer.Builder> getLoadBalancers() {
            List<LoadBalancer.Builder> result = LoadBalancersCopier.copyToBuilder(this.loadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer... loadBalancers) {
            loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers) {
            loadBalancers(Stream.of(loadBalancers).map(c -> LoadBalancer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPropagateTags() {
            return propagateTags;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(PropagateTags propagateTags) {
            this.propagateTags(propagateTags == null ? null : propagateTags.toString());
            return this;
        }

        public final List<ServiceRegistry.Builder> getServiceRegistries() {
            List<ServiceRegistry.Builder> result = ServiceRegistriesCopier.copyToBuilder(this.serviceRegistries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceRegistries(Collection<ServiceRegistry.BuilderImpl> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copyFromBuilder(serviceRegistries);
        }

        @Override
        public final Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copy(serviceRegistries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(ServiceRegistry... serviceRegistries) {
            serviceRegistries(Arrays.asList(serviceRegistries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(Consumer<ServiceRegistry.Builder>... serviceRegistries) {
            serviceRegistries(Stream.of(serviceRegistries).map(c -> ServiceRegistry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ServiceConnectConfiguration.Builder getServiceConnectConfiguration() {
            return serviceConnectConfiguration != null ? serviceConnectConfiguration.toBuilder() : null;
        }

        public final void setServiceConnectConfiguration(ServiceConnectConfiguration.BuilderImpl serviceConnectConfiguration) {
            this.serviceConnectConfiguration = serviceConnectConfiguration != null ? serviceConnectConfiguration.build() : null;
        }

        @Override
        public final Builder serviceConnectConfiguration(ServiceConnectConfiguration serviceConnectConfiguration) {
            this.serviceConnectConfiguration = serviceConnectConfiguration;
            return this;
        }

        public final List<ServiceVolumeConfiguration.Builder> getVolumeConfigurations() {
            List<ServiceVolumeConfiguration.Builder> result = ServiceVolumeConfigurationsCopier
                    .copyToBuilder(this.volumeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumeConfigurations(Collection<ServiceVolumeConfiguration.BuilderImpl> volumeConfigurations) {
            this.volumeConfigurations = ServiceVolumeConfigurationsCopier.copyFromBuilder(volumeConfigurations);
        }

        @Override
        public final Builder volumeConfigurations(Collection<ServiceVolumeConfiguration> volumeConfigurations) {
            this.volumeConfigurations = ServiceVolumeConfigurationsCopier.copy(volumeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(ServiceVolumeConfiguration... volumeConfigurations) {
            volumeConfigurations(Arrays.asList(volumeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(Consumer<ServiceVolumeConfiguration.Builder>... volumeConfigurations) {
            volumeConfigurations(Stream.of(volumeConfigurations)
                    .map(c -> ServiceVolumeConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VpcLatticeConfiguration.Builder> getVpcLatticeConfigurations() {
            List<VpcLatticeConfiguration.Builder> result = VpcLatticeConfigurationsCopier
                    .copyToBuilder(this.vpcLatticeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcLatticeConfigurations(Collection<VpcLatticeConfiguration.BuilderImpl> vpcLatticeConfigurations) {
            this.vpcLatticeConfigurations = VpcLatticeConfigurationsCopier.copyFromBuilder(vpcLatticeConfigurations);
        }

        @Override
        public final Builder vpcLatticeConfigurations(Collection<VpcLatticeConfiguration> vpcLatticeConfigurations) {
            this.vpcLatticeConfigurations = VpcLatticeConfigurationsCopier.copy(vpcLatticeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcLatticeConfigurations(VpcLatticeConfiguration... vpcLatticeConfigurations) {
            vpcLatticeConfigurations(Arrays.asList(vpcLatticeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcLatticeConfigurations(Consumer<VpcLatticeConfiguration.Builder>... vpcLatticeConfigurations) {
            vpcLatticeConfigurations(Stream.of(vpcLatticeConfigurations)
                    .map(c -> VpcLatticeConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceRequest build() {
            return new UpdateServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
