/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AgentUpdateStatus {
    PENDING("PENDING"),
    STAGING("STAGING"),
    STAGED("STAGED"),
    UPDATING("UPDATING"),
    UPDATED("UPDATED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AgentUpdateStatus> VALUE_MAP;
    private final String value;

    private AgentUpdateStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AgentUpdateStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AgentUpdateStatus> knownValues() {
        EnumSet<AgentUpdateStatus> knownValues = EnumSet.allOf(AgentUpdateStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AgentUpdateStatus.class, AgentUpdateStatus::toString);
    }
}

