/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Resource> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Resource.getter(Resource::name)).setter(Resource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Resource.getter(Resource::type)).setter(Resource.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("doubleValue").getter(Resource.getter(Resource::doubleValue)).setter(Resource.setter(Builder::doubleValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()}).build();
    private static final SdkField<Long> LONG_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("longValue").getter(Resource.getter(Resource::longValue)).setter(Resource.setter(Builder::longValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longValue").build()}).build();
    private static final SdkField<Integer> INTEGER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("integerValue").getter(Resource.getter(Resource::integerValue)).setter(Resource.setter(Builder::integerValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerValue").build()}).build();
    private static final SdkField<List<String>> STRING_SET_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stringSetValue").getter(Resource.getter(Resource::stringSetValue)).setter(Resource.setter(Builder::stringSetValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringSetValue").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, DOUBLE_VALUE_FIELD, LONG_VALUE_FIELD, INTEGER_VALUE_FIELD, STRING_SET_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Resource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final Double doubleValue;
    private final Long longValue;
    private final Integer integerValue;
    private final List<String> stringSetValue;

    private Resource(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.doubleValue = builder.doubleValue;
        this.longValue = builder.longValue;
        this.integerValue = builder.integerValue;
        this.stringSetValue = builder.stringSetValue;
    }

    public final String name() {
        return this.name;
    }

    public final String type() {
        return this.type;
    }

    public final Double doubleValue() {
        return this.doubleValue;
    }

    public final Long longValue() {
        return this.longValue;
    }

    public final Integer integerValue() {
        return this.integerValue;
    }

    public final boolean hasStringSetValue() {
        return this.stringSetValue != null && !(this.stringSetValue instanceof SdkAutoConstructList);
    }

    public final List<String> stringSetValue() {
        return this.stringSetValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.longValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringSetValue() ? this.stringSetValue() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.doubleValue(), other.doubleValue()) && Objects.equals(this.longValue(), other.longValue()) && Objects.equals(this.integerValue(), other.integerValue()) && this.hasStringSetValue() == other.hasStringSetValue() && Objects.equals(this.stringSetValue(), other.stringSetValue());
    }

    public final String toString() {
        return ToString.builder((String)"Resource").add("Name", (Object)this.name()).add("Type", (Object)this.type()).add("DoubleValue", (Object)this.doubleValue()).add("LongValue", (Object)this.longValue()).add("IntegerValue", (Object)this.integerValue()).add("StringSetValue", this.hasStringSetValue() ? this.stringSetValue() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "doubleValue": {
                return Optional.ofNullable(clazz.cast(this.doubleValue()));
            }
            case "longValue": {
                return Optional.ofNullable(clazz.cast(this.longValue()));
            }
            case "integerValue": {
                return Optional.ofNullable(clazz.cast(this.integerValue()));
            }
            case "stringSetValue": {
                return Optional.ofNullable(clazz.cast(this.stringSetValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("doubleValue", DOUBLE_VALUE_FIELD);
        map.put("longValue", LONG_VALUE_FIELD);
        map.put("integerValue", INTEGER_VALUE_FIELD);
        map.put("stringSetValue", STRING_SET_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private Double doubleValue;
        private Long longValue;
        private Integer integerValue;
        private List<String> stringSetValue = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            this.name(model.name);
            this.type(model.type);
            this.doubleValue(model.doubleValue);
            this.longValue(model.longValue);
            this.integerValue(model.integerValue);
            this.stringSetValue(model.stringSetValue);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Double getDoubleValue() {
            return this.doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
            return this;
        }

        public final Long getLongValue() {
            return this.longValue;
        }

        public final void setLongValue(Long longValue) {
            this.longValue = longValue;
        }

        @Override
        public final Builder longValue(Long longValue) {
            this.longValue = longValue;
            return this;
        }

        public final Integer getIntegerValue() {
            return this.integerValue;
        }

        public final void setIntegerValue(Integer integerValue) {
            this.integerValue = integerValue;
        }

        @Override
        public final Builder integerValue(Integer integerValue) {
            this.integerValue = integerValue;
            return this;
        }

        public final Collection<String> getStringSetValue() {
            if (this.stringSetValue instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stringSetValue;
        }

        public final void setStringSetValue(Collection<String> stringSetValue) {
            this.stringSetValue = StringListCopier.copy(stringSetValue);
        }

        @Override
        public final Builder stringSetValue(Collection<String> stringSetValue) {
            this.stringSetValue = StringListCopier.copy(stringSetValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringSetValue(String ... stringSetValue) {
            this.stringSetValue(Arrays.asList(stringSetValue));
            return this;
        }

        public Resource build() {
            return new Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Resource> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder doubleValue(Double var1);

        public Builder longValue(Long var1);

        public Builder integerValue(Integer var1);

        public Builder stringSetValue(Collection<String> var1);

        public Builder stringSetValue(String ... var1);
    }
}

