/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UlimitName {
    CORE("core"),
    CPU("cpu"),
    DATA("data"),
    FSIZE("fsize"),
    LOCKS("locks"),
    MEMLOCK("memlock"),
    MSGQUEUE("msgqueue"),
    NICE("nice"),
    NOFILE("nofile"),
    NPROC("nproc"),
    RSS("rss"),
    RTPRIO("rtprio"),
    RTTIME("rttime"),
    SIGPENDING("sigpending"),
    STACK("stack"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UlimitName> VALUE_MAP;
    private final String value;

    private UlimitName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UlimitName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UlimitName> knownValues() {
        EnumSet<UlimitName> knownValues = EnumSet.allOf(UlimitName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UlimitName.class, UlimitName::toString);
    }
}

