/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.ServiceConnectTlsCertificateAuthority;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceConnectTlsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceConnectTlsConfiguration> {
    private static final SdkField<ServiceConnectTlsCertificateAuthority> ISSUER_CERTIFICATE_AUTHORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("issuerCertificateAuthority").getter(ServiceConnectTlsConfiguration.getter(ServiceConnectTlsConfiguration::issuerCertificateAuthority)).setter(ServiceConnectTlsConfiguration.setter(Builder::issuerCertificateAuthority)).constructor(ServiceConnectTlsCertificateAuthority::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuerCertificateAuthority").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKey").getter(ServiceConnectTlsConfiguration.getter(ServiceConnectTlsConfiguration::kmsKey)).setter(ServiceConnectTlsConfiguration.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKey").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(ServiceConnectTlsConfiguration.getter(ServiceConnectTlsConfiguration::roleArn)).setter(ServiceConnectTlsConfiguration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUER_CERTIFICATE_AUTHORITY_FIELD, KMS_KEY_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceConnectTlsConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ServiceConnectTlsCertificateAuthority issuerCertificateAuthority;
    private final String kmsKey;
    private final String roleArn;

    private ServiceConnectTlsConfiguration(BuilderImpl builder) {
        this.issuerCertificateAuthority = builder.issuerCertificateAuthority;
        this.kmsKey = builder.kmsKey;
        this.roleArn = builder.roleArn;
    }

    public final ServiceConnectTlsCertificateAuthority issuerCertificateAuthority() {
        return this.issuerCertificateAuthority;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.issuerCertificateAuthority());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConnectTlsConfiguration)) {
            return false;
        }
        ServiceConnectTlsConfiguration other = (ServiceConnectTlsConfiguration)obj;
        return Objects.equals(this.issuerCertificateAuthority(), other.issuerCertificateAuthority()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceConnectTlsConfiguration").add("IssuerCertificateAuthority", (Object)this.issuerCertificateAuthority()).add("KmsKey", (Object)this.kmsKey()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "issuerCertificateAuthority": {
                return Optional.ofNullable(clazz.cast(this.issuerCertificateAuthority()));
            }
            case "kmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("issuerCertificateAuthority", ISSUER_CERTIFICATE_AUTHORITY_FIELD);
        map.put("kmsKey", KMS_KEY_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceConnectTlsConfiguration, T> g) {
        return obj -> g.apply((ServiceConnectTlsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ServiceConnectTlsCertificateAuthority issuerCertificateAuthority;
        private String kmsKey;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConnectTlsConfiguration model) {
            this.issuerCertificateAuthority(model.issuerCertificateAuthority);
            this.kmsKey(model.kmsKey);
            this.roleArn(model.roleArn);
        }

        public final ServiceConnectTlsCertificateAuthority.Builder getIssuerCertificateAuthority() {
            return this.issuerCertificateAuthority != null ? this.issuerCertificateAuthority.toBuilder() : null;
        }

        public final void setIssuerCertificateAuthority(ServiceConnectTlsCertificateAuthority.BuilderImpl issuerCertificateAuthority) {
            this.issuerCertificateAuthority = issuerCertificateAuthority != null ? issuerCertificateAuthority.build() : null;
        }

        @Override
        public final Builder issuerCertificateAuthority(ServiceConnectTlsCertificateAuthority issuerCertificateAuthority) {
            this.issuerCertificateAuthority = issuerCertificateAuthority;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public ServiceConnectTlsConfiguration build() {
            return new ServiceConnectTlsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceConnectTlsConfiguration> {
        public Builder issuerCertificateAuthority(ServiceConnectTlsCertificateAuthority var1);

        default public Builder issuerCertificateAuthority(Consumer<ServiceConnectTlsCertificateAuthority.Builder> issuerCertificateAuthority) {
            return this.issuerCertificateAuthority((ServiceConnectTlsCertificateAuthority)((ServiceConnectTlsCertificateAuthority.Builder)ServiceConnectTlsCertificateAuthority.builder().applyMutation(issuerCertificateAuthority)).build());
        }

        public Builder kmsKey(String var1);

        public Builder roleArn(String var1);
    }
}

