/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteTaskDefinitionsRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, DeleteTaskDefinitionsRequest> {
    private static final SdkField<List<String>> TASK_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("taskDefinitions").getter(DeleteTaskDefinitionsRequest.getter(DeleteTaskDefinitionsRequest::taskDefinitions)).setter(DeleteTaskDefinitionsRequest.setter(Builder::taskDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_DEFINITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteTaskDefinitionsRequest.memberNameToFieldInitializer();
    private final List<String> taskDefinitions;

    private DeleteTaskDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.taskDefinitions = builder.taskDefinitions;
    }

    public final boolean hasTaskDefinitions() {
        return this.taskDefinitions != null && !(this.taskDefinitions instanceof SdkAutoConstructList);
    }

    public final List<String> taskDefinitions() {
        return this.taskDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskDefinitions() ? this.taskDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTaskDefinitionsRequest)) {
            return false;
        }
        DeleteTaskDefinitionsRequest other = (DeleteTaskDefinitionsRequest)((Object)obj);
        return this.hasTaskDefinitions() == other.hasTaskDefinitions() && Objects.equals(this.taskDefinitions(), other.taskDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteTaskDefinitionsRequest").add("TaskDefinitions", this.hasTaskDefinitions() ? this.taskDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskDefinitions": {
                return Optional.ofNullable(clazz.cast(this.taskDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("taskDefinitions", TASK_DEFINITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteTaskDefinitionsRequest, T> g) {
        return obj -> g.apply((DeleteTaskDefinitionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private List<String> taskDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTaskDefinitionsRequest model) {
            super(model);
            this.taskDefinitions(model.taskDefinitions);
        }

        public final Collection<String> getTaskDefinitions() {
            if (this.taskDefinitions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.taskDefinitions;
        }

        public final void setTaskDefinitions(Collection<String> taskDefinitions) {
            this.taskDefinitions = StringListCopier.copy(taskDefinitions);
        }

        @Override
        public final Builder taskDefinitions(Collection<String> taskDefinitions) {
            this.taskDefinitions = StringListCopier.copy(taskDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskDefinitions(String ... taskDefinitions) {
            this.taskDefinitions(Arrays.asList(taskDefinitions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTaskDefinitionsRequest build() {
            return new DeleteTaskDefinitionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteTaskDefinitionsRequest> {
        public Builder taskDefinitions(Collection<String> var1);

        public Builder taskDefinitions(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

