/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TaskDefinitionField {
    TAGS("TAGS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TaskDefinitionField> VALUE_MAP;
    private final String value;

    private TaskDefinitionField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TaskDefinitionField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TaskDefinitionField> knownValues() {
        EnumSet<TaskDefinitionField> knownValues = EnumSet.allOf(TaskDefinitionField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TaskDefinitionField.class, TaskDefinitionField::toString);
    }
}

