/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfig;
import software.amazon.awssdk.services.ecs.model.EFSTransitEncryption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EFSVolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EFSVolumeConfiguration> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileSystemId").getter(EFSVolumeConfiguration.getter(EFSVolumeConfiguration::fileSystemId)).setter(EFSVolumeConfiguration.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemId").build()}).build();
    private static final SdkField<String> ROOT_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rootDirectory").getter(EFSVolumeConfiguration.getter(EFSVolumeConfiguration::rootDirectory)).setter(EFSVolumeConfiguration.setter(Builder::rootDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootDirectory").build()}).build();
    private static final SdkField<String> TRANSIT_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transitEncryption").getter(EFSVolumeConfiguration.getter(EFSVolumeConfiguration::transitEncryptionAsString)).setter(EFSVolumeConfiguration.setter(Builder::transitEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitEncryption").build()}).build();
    private static final SdkField<Integer> TRANSIT_ENCRYPTION_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("transitEncryptionPort").getter(EFSVolumeConfiguration.getter(EFSVolumeConfiguration::transitEncryptionPort)).setter(EFSVolumeConfiguration.setter(Builder::transitEncryptionPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitEncryptionPort").build()}).build();
    private static final SdkField<EFSAuthorizationConfig> AUTHORIZATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authorizationConfig").getter(EFSVolumeConfiguration.getter(EFSVolumeConfiguration::authorizationConfig)).setter(EFSVolumeConfiguration.setter(Builder::authorizationConfig)).constructor(EFSAuthorizationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD, ROOT_DIRECTORY_FIELD, TRANSIT_ENCRYPTION_FIELD, TRANSIT_ENCRYPTION_PORT_FIELD, AUTHORIZATION_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fileSystemId;
    private final String rootDirectory;
    private final String transitEncryption;
    private final Integer transitEncryptionPort;
    private final EFSAuthorizationConfig authorizationConfig;

    private EFSVolumeConfiguration(BuilderImpl builder) {
        this.fileSystemId = builder.fileSystemId;
        this.rootDirectory = builder.rootDirectory;
        this.transitEncryption = builder.transitEncryption;
        this.transitEncryptionPort = builder.transitEncryptionPort;
        this.authorizationConfig = builder.authorizationConfig;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final String rootDirectory() {
        return this.rootDirectory;
    }

    public final EFSTransitEncryption transitEncryption() {
        return EFSTransitEncryption.fromValue(this.transitEncryption);
    }

    public final String transitEncryptionAsString() {
        return this.transitEncryption;
    }

    public final Integer transitEncryptionPort() {
        return this.transitEncryptionPort;
    }

    public final EFSAuthorizationConfig authorizationConfig() {
        return this.authorizationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EFSVolumeConfiguration)) {
            return false;
        }
        EFSVolumeConfiguration other = (EFSVolumeConfiguration)obj;
        return Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.rootDirectory(), other.rootDirectory()) && Objects.equals(this.transitEncryptionAsString(), other.transitEncryptionAsString()) && Objects.equals(this.transitEncryptionPort(), other.transitEncryptionPort()) && Objects.equals(this.authorizationConfig(), other.authorizationConfig());
    }

    public final String toString() {
        return ToString.builder((String)"EFSVolumeConfiguration").add("FileSystemId", (Object)this.fileSystemId()).add("RootDirectory", (Object)this.rootDirectory()).add("TransitEncryption", (Object)this.transitEncryptionAsString()).add("TransitEncryptionPort", (Object)this.transitEncryptionPort()).add("AuthorizationConfig", (Object)this.authorizationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "rootDirectory": {
                return Optional.ofNullable(clazz.cast(this.rootDirectory()));
            }
            case "transitEncryption": {
                return Optional.ofNullable(clazz.cast(this.transitEncryptionAsString()));
            }
            case "transitEncryptionPort": {
                return Optional.ofNullable(clazz.cast(this.transitEncryptionPort()));
            }
            case "authorizationConfig": {
                return Optional.ofNullable(clazz.cast(this.authorizationConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EFSVolumeConfiguration, T> g) {
        return obj -> g.apply((EFSVolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileSystemId;
        private String rootDirectory;
        private String transitEncryption;
        private Integer transitEncryptionPort;
        private EFSAuthorizationConfig authorizationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EFSVolumeConfiguration model) {
            this.fileSystemId(model.fileSystemId);
            this.rootDirectory(model.rootDirectory);
            this.transitEncryption(model.transitEncryption);
            this.transitEncryptionPort(model.transitEncryptionPort);
            this.authorizationConfig(model.authorizationConfig);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getRootDirectory() {
            return this.rootDirectory;
        }

        public final void setRootDirectory(String rootDirectory) {
            this.rootDirectory = rootDirectory;
        }

        @Override
        public final Builder rootDirectory(String rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        public final String getTransitEncryption() {
            return this.transitEncryption;
        }

        public final void setTransitEncryption(String transitEncryption) {
            this.transitEncryption = transitEncryption;
        }

        @Override
        public final Builder transitEncryption(String transitEncryption) {
            this.transitEncryption = transitEncryption;
            return this;
        }

        @Override
        public final Builder transitEncryption(EFSTransitEncryption transitEncryption) {
            this.transitEncryption(transitEncryption == null ? null : transitEncryption.toString());
            return this;
        }

        public final Integer getTransitEncryptionPort() {
            return this.transitEncryptionPort;
        }

        public final void setTransitEncryptionPort(Integer transitEncryptionPort) {
            this.transitEncryptionPort = transitEncryptionPort;
        }

        @Override
        public final Builder transitEncryptionPort(Integer transitEncryptionPort) {
            this.transitEncryptionPort = transitEncryptionPort;
            return this;
        }

        public final EFSAuthorizationConfig.Builder getAuthorizationConfig() {
            return this.authorizationConfig != null ? this.authorizationConfig.toBuilder() : null;
        }

        public final void setAuthorizationConfig(EFSAuthorizationConfig.BuilderImpl authorizationConfig) {
            this.authorizationConfig = authorizationConfig != null ? authorizationConfig.build() : null;
        }

        @Override
        public final Builder authorizationConfig(EFSAuthorizationConfig authorizationConfig) {
            this.authorizationConfig = authorizationConfig;
            return this;
        }

        public EFSVolumeConfiguration build() {
            return new EFSVolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EFSVolumeConfiguration> {
        public Builder fileSystemId(String var1);

        public Builder rootDirectory(String var1);

        public Builder transitEncryption(String var1);

        public Builder transitEncryption(EFSTransitEncryption var1);

        public Builder transitEncryptionPort(Integer var1);

        public Builder authorizationConfig(EFSAuthorizationConfig var1);

        default public Builder authorizationConfig(Consumer<EFSAuthorizationConfig.Builder> authorizationConfig) {
            return this.authorizationConfig((EFSAuthorizationConfig)((EFSAuthorizationConfig.Builder)EFSAuthorizationConfig.builder().applyMutation(authorizationConfig)).build());
        }
    }
}

