/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecs.EcsClient;
import software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceRequest;
import software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceResponse;

public class ListServicesByNamespaceIterable
implements SdkIterable<ListServicesByNamespaceResponse> {
    private final EcsClient client;
    private final ListServicesByNamespaceRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServicesByNamespaceIterable(EcsClient client, ListServicesByNamespaceRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListServicesByNamespaceResponseFetcher();
    }

    public Iterator<ListServicesByNamespaceResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> serviceArns() {
        Function<ListServicesByNamespaceResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceArns() != null) {
                return response.serviceArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServicesByNamespaceResponseFetcher
    implements SyncPageFetcher<ListServicesByNamespaceResponse> {
        private ListServicesByNamespaceResponseFetcher() {
        }

        public boolean hasNextPage(ListServicesByNamespaceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServicesByNamespaceResponse nextPage(ListServicesByNamespaceResponse previousPage) {
            if (previousPage == null) {
                return ListServicesByNamespaceIterable.this.client.listServicesByNamespace(ListServicesByNamespaceIterable.this.firstRequest);
            }
            return ListServicesByNamespaceIterable.this.client.listServicesByNamespace((ListServicesByNamespaceRequest)((Object)ListServicesByNamespaceIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

