/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.Compatibility;
import software.amazon.awssdk.services.ecs.model.CompatibilityListCopier;
import software.amazon.awssdk.services.ecs.model.ContainerDefinition;
import software.amazon.awssdk.services.ecs.model.ContainerDefinitionsCopier;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.EphemeralStorage;
import software.amazon.awssdk.services.ecs.model.InferenceAccelerator;
import software.amazon.awssdk.services.ecs.model.InferenceAcceleratorsCopier;
import software.amazon.awssdk.services.ecs.model.IpcMode;
import software.amazon.awssdk.services.ecs.model.NetworkMode;
import software.amazon.awssdk.services.ecs.model.PidMode;
import software.amazon.awssdk.services.ecs.model.ProxyConfiguration;
import software.amazon.awssdk.services.ecs.model.RuntimePlatform;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.services.ecs.model.TaskDefinitionPlacementConstraint;
import software.amazon.awssdk.services.ecs.model.TaskDefinitionPlacementConstraintsCopier;
import software.amazon.awssdk.services.ecs.model.Volume;
import software.amazon.awssdk.services.ecs.model.VolumeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterTaskDefinitionRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, RegisterTaskDefinitionRequest> {
    private static final SdkField<String> FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("family").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::family)).setter(RegisterTaskDefinitionRequest.setter(Builder::family)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("family").build()}).build();
    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskRoleArn").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::taskRoleArn)).setter(RegisterTaskDefinitionRequest.setter(Builder::taskRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRoleArn").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::executionRoleArn)).setter(RegisterTaskDefinitionRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<String> NETWORK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkMode").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::networkModeAsString)).setter(RegisterTaskDefinitionRequest.setter(Builder::networkMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkMode").build()}).build();
    private static final SdkField<List<ContainerDefinition>> CONTAINER_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containerDefinitions").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::containerDefinitions)).setter(RegisterTaskDefinitionRequest.setter(Builder::containerDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Volume>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumes").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::volumes)).setter(RegisterTaskDefinitionRequest.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Volume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TaskDefinitionPlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("placementConstraints").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::placementConstraints)).setter(RegisterTaskDefinitionRequest.setter(Builder::placementConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskDefinitionPlacementConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REQUIRES_COMPATIBILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("requiresCompatibilities").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::requiresCompatibilitiesAsStrings)).setter(RegisterTaskDefinitionRequest.setter(Builder::requiresCompatibilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiresCompatibilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cpu").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::cpu)).setter(RegisterTaskDefinitionRequest.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()}).build();
    private static final SdkField<String> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memory").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::memory)).setter(RegisterTaskDefinitionRequest.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::tags)).setter(RegisterTaskDefinitionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PID_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pidMode").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::pidModeAsString)).setter(RegisterTaskDefinitionRequest.setter(Builder::pidMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pidMode").build()}).build();
    private static final SdkField<String> IPC_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipcMode").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::ipcModeAsString)).setter(RegisterTaskDefinitionRequest.setter(Builder::ipcMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipcMode").build()}).build();
    private static final SdkField<ProxyConfiguration> PROXY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("proxyConfiguration").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::proxyConfiguration)).setter(RegisterTaskDefinitionRequest.setter(Builder::proxyConfiguration)).constructor(ProxyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proxyConfiguration").build()}).build();
    private static final SdkField<List<InferenceAccelerator>> INFERENCE_ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inferenceAccelerators").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::inferenceAccelerators)).setter(RegisterTaskDefinitionRequest.setter(Builder::inferenceAccelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceAccelerators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InferenceAccelerator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EphemeralStorage> EPHEMERAL_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ephemeralStorage").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::ephemeralStorage)).setter(RegisterTaskDefinitionRequest.setter(Builder::ephemeralStorage)).constructor(EphemeralStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemeralStorage").build()}).build();
    private static final SdkField<RuntimePlatform> RUNTIME_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("runtimePlatform").getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::runtimePlatform)).setter(RegisterTaskDefinitionRequest.setter(Builder::runtimePlatform)).constructor(RuntimePlatform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimePlatform").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILY_FIELD, TASK_ROLE_ARN_FIELD, EXECUTION_ROLE_ARN_FIELD, NETWORK_MODE_FIELD, CONTAINER_DEFINITIONS_FIELD, VOLUMES_FIELD, PLACEMENT_CONSTRAINTS_FIELD, REQUIRES_COMPATIBILITIES_FIELD, CPU_FIELD, MEMORY_FIELD, TAGS_FIELD, PID_MODE_FIELD, IPC_MODE_FIELD, PROXY_CONFIGURATION_FIELD, INFERENCE_ACCELERATORS_FIELD, EPHEMERAL_STORAGE_FIELD, RUNTIME_PLATFORM_FIELD));
    private final String family;
    private final String taskRoleArn;
    private final String executionRoleArn;
    private final String networkMode;
    private final List<ContainerDefinition> containerDefinitions;
    private final List<Volume> volumes;
    private final List<TaskDefinitionPlacementConstraint> placementConstraints;
    private final List<String> requiresCompatibilities;
    private final String cpu;
    private final String memory;
    private final List<Tag> tags;
    private final String pidMode;
    private final String ipcMode;
    private final ProxyConfiguration proxyConfiguration;
    private final List<InferenceAccelerator> inferenceAccelerators;
    private final EphemeralStorage ephemeralStorage;
    private final RuntimePlatform runtimePlatform;

    private RegisterTaskDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.family = builder.family;
        this.taskRoleArn = builder.taskRoleArn;
        this.executionRoleArn = builder.executionRoleArn;
        this.networkMode = builder.networkMode;
        this.containerDefinitions = builder.containerDefinitions;
        this.volumes = builder.volumes;
        this.placementConstraints = builder.placementConstraints;
        this.requiresCompatibilities = builder.requiresCompatibilities;
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.tags = builder.tags;
        this.pidMode = builder.pidMode;
        this.ipcMode = builder.ipcMode;
        this.proxyConfiguration = builder.proxyConfiguration;
        this.inferenceAccelerators = builder.inferenceAccelerators;
        this.ephemeralStorage = builder.ephemeralStorage;
        this.runtimePlatform = builder.runtimePlatform;
    }

    public final String family() {
        return this.family;
    }

    public final String taskRoleArn() {
        return this.taskRoleArn;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final NetworkMode networkMode() {
        return NetworkMode.fromValue(this.networkMode);
    }

    public final String networkModeAsString() {
        return this.networkMode;
    }

    public final boolean hasContainerDefinitions() {
        return this.containerDefinitions != null && !(this.containerDefinitions instanceof SdkAutoConstructList);
    }

    public final List<ContainerDefinition> containerDefinitions() {
        return this.containerDefinitions;
    }

    public final boolean hasVolumes() {
        return this.volumes != null && !(this.volumes instanceof SdkAutoConstructList);
    }

    public final List<Volume> volumes() {
        return this.volumes;
    }

    public final boolean hasPlacementConstraints() {
        return this.placementConstraints != null && !(this.placementConstraints instanceof SdkAutoConstructList);
    }

    public final List<TaskDefinitionPlacementConstraint> placementConstraints() {
        return this.placementConstraints;
    }

    public final List<Compatibility> requiresCompatibilities() {
        return CompatibilityListCopier.copyStringToEnum(this.requiresCompatibilities);
    }

    public final boolean hasRequiresCompatibilities() {
        return this.requiresCompatibilities != null && !(this.requiresCompatibilities instanceof SdkAutoConstructList);
    }

    public final List<String> requiresCompatibilitiesAsStrings() {
        return this.requiresCompatibilities;
    }

    public final String cpu() {
        return this.cpu;
    }

    public final String memory() {
        return this.memory;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final PidMode pidMode() {
        return PidMode.fromValue(this.pidMode);
    }

    public final String pidModeAsString() {
        return this.pidMode;
    }

    public final IpcMode ipcMode() {
        return IpcMode.fromValue(this.ipcMode);
    }

    public final String ipcModeAsString() {
        return this.ipcMode;
    }

    public final ProxyConfiguration proxyConfiguration() {
        return this.proxyConfiguration;
    }

    public final boolean hasInferenceAccelerators() {
        return this.inferenceAccelerators != null && !(this.inferenceAccelerators instanceof SdkAutoConstructList);
    }

    public final List<InferenceAccelerator> inferenceAccelerators() {
        return this.inferenceAccelerators;
    }

    public final EphemeralStorage ephemeralStorage() {
        return this.ephemeralStorage;
    }

    public final RuntimePlatform runtimePlatform() {
        return this.runtimePlatform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.family());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerDefinitions() ? this.containerDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumes() ? this.volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlacementConstraints() ? this.placementConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiresCompatibilities() ? this.requiresCompatibilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pidModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipcModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferenceAccelerators() ? this.inferenceAccelerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemeralStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimePlatform());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTaskDefinitionRequest)) {
            return false;
        }
        RegisterTaskDefinitionRequest other = (RegisterTaskDefinitionRequest)((Object)obj);
        return Objects.equals(this.family(), other.family()) && Objects.equals(this.taskRoleArn(), other.taskRoleArn()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.networkModeAsString(), other.networkModeAsString()) && this.hasContainerDefinitions() == other.hasContainerDefinitions() && Objects.equals(this.containerDefinitions(), other.containerDefinitions()) && this.hasVolumes() == other.hasVolumes() && Objects.equals(this.volumes(), other.volumes()) && this.hasPlacementConstraints() == other.hasPlacementConstraints() && Objects.equals(this.placementConstraints(), other.placementConstraints()) && this.hasRequiresCompatibilities() == other.hasRequiresCompatibilities() && Objects.equals(this.requiresCompatibilitiesAsStrings(), other.requiresCompatibilitiesAsStrings()) && Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.memory(), other.memory()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.pidModeAsString(), other.pidModeAsString()) && Objects.equals(this.ipcModeAsString(), other.ipcModeAsString()) && Objects.equals(this.proxyConfiguration(), other.proxyConfiguration()) && this.hasInferenceAccelerators() == other.hasInferenceAccelerators() && Objects.equals(this.inferenceAccelerators(), other.inferenceAccelerators()) && Objects.equals(this.ephemeralStorage(), other.ephemeralStorage()) && Objects.equals(this.runtimePlatform(), other.runtimePlatform());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterTaskDefinitionRequest").add("Family", (Object)this.family()).add("TaskRoleArn", (Object)this.taskRoleArn()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("NetworkMode", (Object)this.networkModeAsString()).add("ContainerDefinitions", this.hasContainerDefinitions() ? this.containerDefinitions() : null).add("Volumes", this.hasVolumes() ? this.volumes() : null).add("PlacementConstraints", this.hasPlacementConstraints() ? this.placementConstraints() : null).add("RequiresCompatibilities", this.hasRequiresCompatibilities() ? this.requiresCompatibilitiesAsStrings() : null).add("Cpu", (Object)this.cpu()).add("Memory", (Object)this.memory()).add("Tags", this.hasTags() ? this.tags() : null).add("PidMode", (Object)this.pidModeAsString()).add("IpcMode", (Object)this.ipcModeAsString()).add("ProxyConfiguration", (Object)this.proxyConfiguration()).add("InferenceAccelerators", this.hasInferenceAccelerators() ? this.inferenceAccelerators() : null).add("EphemeralStorage", (Object)this.ephemeralStorage()).add("RuntimePlatform", (Object)this.runtimePlatform()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "family": {
                return Optional.ofNullable(clazz.cast(this.family()));
            }
            case "taskRoleArn": {
                return Optional.ofNullable(clazz.cast(this.taskRoleArn()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "networkMode": {
                return Optional.ofNullable(clazz.cast(this.networkModeAsString()));
            }
            case "containerDefinitions": {
                return Optional.ofNullable(clazz.cast(this.containerDefinitions()));
            }
            case "volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
            case "placementConstraints": {
                return Optional.ofNullable(clazz.cast(this.placementConstraints()));
            }
            case "requiresCompatibilities": {
                return Optional.ofNullable(clazz.cast(this.requiresCompatibilitiesAsStrings()));
            }
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "pidMode": {
                return Optional.ofNullable(clazz.cast(this.pidModeAsString()));
            }
            case "ipcMode": {
                return Optional.ofNullable(clazz.cast(this.ipcModeAsString()));
            }
            case "proxyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.proxyConfiguration()));
            }
            case "inferenceAccelerators": {
                return Optional.ofNullable(clazz.cast(this.inferenceAccelerators()));
            }
            case "ephemeralStorage": {
                return Optional.ofNullable(clazz.cast(this.ephemeralStorage()));
            }
            case "runtimePlatform": {
                return Optional.ofNullable(clazz.cast(this.runtimePlatform()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterTaskDefinitionRequest, T> g) {
        return obj -> g.apply((RegisterTaskDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String family;
        private String taskRoleArn;
        private String executionRoleArn;
        private String networkMode;
        private List<ContainerDefinition> containerDefinitions = DefaultSdkAutoConstructList.getInstance();
        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();
        private List<TaskDefinitionPlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();
        private List<String> requiresCompatibilities = DefaultSdkAutoConstructList.getInstance();
        private String cpu;
        private String memory;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String pidMode;
        private String ipcMode;
        private ProxyConfiguration proxyConfiguration;
        private List<InferenceAccelerator> inferenceAccelerators = DefaultSdkAutoConstructList.getInstance();
        private EphemeralStorage ephemeralStorage;
        private RuntimePlatform runtimePlatform;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTaskDefinitionRequest model) {
            super(model);
            this.family(model.family);
            this.taskRoleArn(model.taskRoleArn);
            this.executionRoleArn(model.executionRoleArn);
            this.networkMode(model.networkMode);
            this.containerDefinitions(model.containerDefinitions);
            this.volumes(model.volumes);
            this.placementConstraints(model.placementConstraints);
            this.requiresCompatibilitiesWithStrings(model.requiresCompatibilities);
            this.cpu(model.cpu);
            this.memory(model.memory);
            this.tags(model.tags);
            this.pidMode(model.pidMode);
            this.ipcMode(model.ipcMode);
            this.proxyConfiguration(model.proxyConfiguration);
            this.inferenceAccelerators(model.inferenceAccelerators);
            this.ephemeralStorage(model.ephemeralStorage);
            this.runtimePlatform(model.runtimePlatform);
        }

        public final String getFamily() {
            return this.family;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final String getTaskRoleArn() {
            return this.taskRoleArn;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getNetworkMode() {
            return this.networkMode;
        }

        public final void setNetworkMode(String networkMode) {
            this.networkMode = networkMode;
        }

        @Override
        public final Builder networkMode(String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        @Override
        public final Builder networkMode(NetworkMode networkMode) {
            this.networkMode(networkMode == null ? null : networkMode.toString());
            return this;
        }

        public final List<ContainerDefinition.Builder> getContainerDefinitions() {
            List<ContainerDefinition.Builder> result = ContainerDefinitionsCopier.copyToBuilder(this.containerDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerDefinitions(Collection<ContainerDefinition.BuilderImpl> containerDefinitions) {
            this.containerDefinitions = ContainerDefinitionsCopier.copyFromBuilder(containerDefinitions);
        }

        @Override
        public final Builder containerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
            this.containerDefinitions = ContainerDefinitionsCopier.copy(containerDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(ContainerDefinition ... containerDefinitions) {
            this.containerDefinitions(Arrays.asList(containerDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(Consumer<ContainerDefinition.Builder> ... containerDefinitions) {
            this.containerDefinitions(Stream.of(containerDefinitions).map(c -> (ContainerDefinition)((ContainerDefinition.Builder)ContainerDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Volume.Builder> getVolumes() {
            List<Volume.Builder> result = VolumeListCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumeListCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumeListCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (Volume)((Volume.Builder)Volume.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TaskDefinitionPlacementConstraint.Builder> getPlacementConstraints() {
            List<TaskDefinitionPlacementConstraint.Builder> result = TaskDefinitionPlacementConstraintsCopier.copyToBuilder(this.placementConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementConstraints(Collection<TaskDefinitionPlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = TaskDefinitionPlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        @Override
        public final Builder placementConstraints(Collection<TaskDefinitionPlacementConstraint> placementConstraints) {
            this.placementConstraints = TaskDefinitionPlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(TaskDefinitionPlacementConstraint ... placementConstraints) {
            this.placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<TaskDefinitionPlacementConstraint.Builder> ... placementConstraints) {
            this.placementConstraints(Stream.of(placementConstraints).map(c -> (TaskDefinitionPlacementConstraint)((TaskDefinitionPlacementConstraint.Builder)TaskDefinitionPlacementConstraint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRequiresCompatibilities() {
            if (this.requiresCompatibilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requiresCompatibilities;
        }

        public final void setRequiresCompatibilities(Collection<String> requiresCompatibilities) {
            this.requiresCompatibilities = CompatibilityListCopier.copy(requiresCompatibilities);
        }

        @Override
        public final Builder requiresCompatibilitiesWithStrings(Collection<String> requiresCompatibilities) {
            this.requiresCompatibilities = CompatibilityListCopier.copy(requiresCompatibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiresCompatibilitiesWithStrings(String ... requiresCompatibilities) {
            this.requiresCompatibilitiesWithStrings(Arrays.asList(requiresCompatibilities));
            return this;
        }

        @Override
        public final Builder requiresCompatibilities(Collection<Compatibility> requiresCompatibilities) {
            this.requiresCompatibilities = CompatibilityListCopier.copyEnumToString(requiresCompatibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiresCompatibilities(Compatibility ... requiresCompatibilities) {
            this.requiresCompatibilities(Arrays.asList(requiresCompatibilities));
            return this;
        }

        public final String getCpu() {
            return this.cpu;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final String getMemory() {
            return this.memory;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPidMode() {
            return this.pidMode;
        }

        public final void setPidMode(String pidMode) {
            this.pidMode = pidMode;
        }

        @Override
        public final Builder pidMode(String pidMode) {
            this.pidMode = pidMode;
            return this;
        }

        @Override
        public final Builder pidMode(PidMode pidMode) {
            this.pidMode(pidMode == null ? null : pidMode.toString());
            return this;
        }

        public final String getIpcMode() {
            return this.ipcMode;
        }

        public final void setIpcMode(String ipcMode) {
            this.ipcMode = ipcMode;
        }

        @Override
        public final Builder ipcMode(String ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        @Override
        public final Builder ipcMode(IpcMode ipcMode) {
            this.ipcMode(ipcMode == null ? null : ipcMode.toString());
            return this;
        }

        public final ProxyConfiguration.Builder getProxyConfiguration() {
            return this.proxyConfiguration != null ? this.proxyConfiguration.toBuilder() : null;
        }

        public final void setProxyConfiguration(ProxyConfiguration.BuilderImpl proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration != null ? proxyConfiguration.build() : null;
        }

        @Override
        public final Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public final List<InferenceAccelerator.Builder> getInferenceAccelerators() {
            List<InferenceAccelerator.Builder> result = InferenceAcceleratorsCopier.copyToBuilder(this.inferenceAccelerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceAccelerators(Collection<InferenceAccelerator.BuilderImpl> inferenceAccelerators) {
            this.inferenceAccelerators = InferenceAcceleratorsCopier.copyFromBuilder(inferenceAccelerators);
        }

        @Override
        public final Builder inferenceAccelerators(Collection<InferenceAccelerator> inferenceAccelerators) {
            this.inferenceAccelerators = InferenceAcceleratorsCopier.copy(inferenceAccelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAccelerators(InferenceAccelerator ... inferenceAccelerators) {
            this.inferenceAccelerators(Arrays.asList(inferenceAccelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAccelerators(Consumer<InferenceAccelerator.Builder> ... inferenceAccelerators) {
            this.inferenceAccelerators(Stream.of(inferenceAccelerators).map(c -> (InferenceAccelerator)((InferenceAccelerator.Builder)InferenceAccelerator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EphemeralStorage.Builder getEphemeralStorage() {
            return this.ephemeralStorage != null ? this.ephemeralStorage.toBuilder() : null;
        }

        public final void setEphemeralStorage(EphemeralStorage.BuilderImpl ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage != null ? ephemeralStorage.build() : null;
        }

        @Override
        public final Builder ephemeralStorage(EphemeralStorage ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        public final RuntimePlatform.Builder getRuntimePlatform() {
            return this.runtimePlatform != null ? this.runtimePlatform.toBuilder() : null;
        }

        public final void setRuntimePlatform(RuntimePlatform.BuilderImpl runtimePlatform) {
            this.runtimePlatform = runtimePlatform != null ? runtimePlatform.build() : null;
        }

        @Override
        public final Builder runtimePlatform(RuntimePlatform runtimePlatform) {
            this.runtimePlatform = runtimePlatform;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterTaskDefinitionRequest build() {
            return new RegisterTaskDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterTaskDefinitionRequest> {
        public Builder family(String var1);

        public Builder taskRoleArn(String var1);

        public Builder executionRoleArn(String var1);

        public Builder networkMode(String var1);

        public Builder networkMode(NetworkMode var1);

        public Builder containerDefinitions(Collection<ContainerDefinition> var1);

        public Builder containerDefinitions(ContainerDefinition ... var1);

        public Builder containerDefinitions(Consumer<ContainerDefinition.Builder> ... var1);

        public Builder volumes(Collection<Volume> var1);

        public Builder volumes(Volume ... var1);

        public Builder volumes(Consumer<Volume.Builder> ... var1);

        public Builder placementConstraints(Collection<TaskDefinitionPlacementConstraint> var1);

        public Builder placementConstraints(TaskDefinitionPlacementConstraint ... var1);

        public Builder placementConstraints(Consumer<TaskDefinitionPlacementConstraint.Builder> ... var1);

        public Builder requiresCompatibilitiesWithStrings(Collection<String> var1);

        public Builder requiresCompatibilitiesWithStrings(String ... var1);

        public Builder requiresCompatibilities(Collection<Compatibility> var1);

        public Builder requiresCompatibilities(Compatibility ... var1);

        public Builder cpu(String var1);

        public Builder memory(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder pidMode(String var1);

        public Builder pidMode(PidMode var1);

        public Builder ipcMode(String var1);

        public Builder ipcMode(IpcMode var1);

        public Builder proxyConfiguration(ProxyConfiguration var1);

        default public Builder proxyConfiguration(Consumer<ProxyConfiguration.Builder> proxyConfiguration) {
            return this.proxyConfiguration((ProxyConfiguration)((ProxyConfiguration.Builder)ProxyConfiguration.builder().applyMutation(proxyConfiguration)).build());
        }

        public Builder inferenceAccelerators(Collection<InferenceAccelerator> var1);

        public Builder inferenceAccelerators(InferenceAccelerator ... var1);

        public Builder inferenceAccelerators(Consumer<InferenceAccelerator.Builder> ... var1);

        public Builder ephemeralStorage(EphemeralStorage var1);

        default public Builder ephemeralStorage(Consumer<EphemeralStorage.Builder> ephemeralStorage) {
            return this.ephemeralStorage((EphemeralStorage)((EphemeralStorage.Builder)EphemeralStorage.builder().applyMutation(ephemeralStorage)).build());
        }

        public Builder runtimePlatform(RuntimePlatform var1);

        default public Builder runtimePlatform(Consumer<RuntimePlatform.Builder> runtimePlatform) {
            return this.runtimePlatform((RuntimePlatform)((RuntimePlatform.Builder)RuntimePlatform.builder().applyMutation(runtimePlatform)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

