/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.CapacityProvider;
import software.amazon.awssdk.services.ecs.model.CapacityProvidersCopier;
import software.amazon.awssdk.services.ecs.model.EcsResponse;
import software.amazon.awssdk.services.ecs.model.Failure;
import software.amazon.awssdk.services.ecs.model.FailuresCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCapacityProvidersResponse
extends EcsResponse
implements ToCopyableBuilder<Builder, DescribeCapacityProvidersResponse> {
    private static final SdkField<List<CapacityProvider>> CAPACITY_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capacityProviders").getter(DescribeCapacityProvidersResponse.getter(DescribeCapacityProvidersResponse::capacityProviders)).setter(DescribeCapacityProvidersResponse.setter(Builder::capacityProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Failure>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failures").getter(DescribeCapacityProvidersResponse.getter(DescribeCapacityProvidersResponse::failures)).setter(DescribeCapacityProvidersResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Failure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeCapacityProvidersResponse.getter(DescribeCapacityProvidersResponse::nextToken)).setter(DescribeCapacityProvidersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDERS_FIELD, FAILURES_FIELD, NEXT_TOKEN_FIELD));
    private final List<CapacityProvider> capacityProviders;
    private final List<Failure> failures;
    private final String nextToken;

    private DescribeCapacityProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.capacityProviders = builder.capacityProviders;
        this.failures = builder.failures;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCapacityProviders() {
        return this.capacityProviders != null && !(this.capacityProviders instanceof SdkAutoConstructList);
    }

    public final List<CapacityProvider> capacityProviders() {
        return this.capacityProviders;
    }

    public final boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public final List<Failure> failures() {
        return this.failures;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityProviders() ? this.capacityProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailures() ? this.failures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityProvidersResponse)) {
            return false;
        }
        DescribeCapacityProvidersResponse other = (DescribeCapacityProvidersResponse)((Object)obj);
        return this.hasCapacityProviders() == other.hasCapacityProviders() && Objects.equals(this.capacityProviders(), other.capacityProviders()) && this.hasFailures() == other.hasFailures() && Objects.equals(this.failures(), other.failures()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCapacityProvidersResponse").add("CapacityProviders", this.hasCapacityProviders() ? this.capacityProviders() : null).add("Failures", this.hasFailures() ? this.failures() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "capacityProviders": {
                return Optional.ofNullable(clazz.cast(this.capacityProviders()));
            }
            case "failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityProvidersResponse, T> g) {
        return obj -> g.apply((DescribeCapacityProvidersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsResponse.BuilderImpl
    implements Builder {
        private List<CapacityProvider> capacityProviders = DefaultSdkAutoConstructList.getInstance();
        private List<Failure> failures = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityProvidersResponse model) {
            super(model);
            this.capacityProviders(model.capacityProviders);
            this.failures(model.failures);
            this.nextToken(model.nextToken);
        }

        public final List<CapacityProvider.Builder> getCapacityProviders() {
            List<CapacityProvider.Builder> result = CapacityProvidersCopier.copyToBuilder(this.capacityProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityProviders(Collection<CapacityProvider.BuilderImpl> capacityProviders) {
            this.capacityProviders = CapacityProvidersCopier.copyFromBuilder(capacityProviders);
        }

        @Override
        public final Builder capacityProviders(Collection<CapacityProvider> capacityProviders) {
            this.capacityProviders = CapacityProvidersCopier.copy(capacityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviders(CapacityProvider ... capacityProviders) {
            this.capacityProviders(Arrays.asList(capacityProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviders(Consumer<CapacityProvider.Builder> ... capacityProviders) {
            this.capacityProviders(Stream.of(capacityProviders).map(c -> (CapacityProvider)((CapacityProvider.Builder)CapacityProvider.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Failure.Builder> getFailures() {
            List<Failure.Builder> result = FailuresCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<Failure.BuilderImpl> failures) {
            this.failures = FailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<Failure> failures) {
            this.failures = FailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Failure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<Failure.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (Failure)((Failure.Builder)Failure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCapacityProvidersResponse build() {
            return new DescribeCapacityProvidersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCapacityProvidersResponse> {
        public Builder capacityProviders(Collection<CapacityProvider> var1);

        public Builder capacityProviders(CapacityProvider ... var1);

        public Builder capacityProviders(Consumer<CapacityProvider.Builder> ... var1);

        public Builder failures(Collection<Failure> var1);

        public Builder failures(Failure ... var1);

        public Builder failures(Consumer<Failure.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

