/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.Attachment;
import software.amazon.awssdk.services.ecs.model.AttachmentsCopier;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyCopier;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem;
import software.amazon.awssdk.services.ecs.model.ClusterSetting;
import software.amazon.awssdk.services.ecs.model.ClusterSettingsCopier;
import software.amazon.awssdk.services.ecs.model.KeyValuePair;
import software.amazon.awssdk.services.ecs.model.StatisticsCopier;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cluster> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Cluster.getter(Cluster::clusterArn)).setter(Cluster.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Cluster.getter(Cluster::clusterName)).setter(Cluster.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Cluster.getter(Cluster::status)).setter(Cluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Cluster.getter(Cluster::registeredContainerInstancesCount)).setter(Cluster.setter(Builder::registeredContainerInstancesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredContainerInstancesCount").build()}).build();
    private static final SdkField<Integer> RUNNING_TASKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Cluster.getter(Cluster::runningTasksCount)).setter(Cluster.setter(Builder::runningTasksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningTasksCount").build()}).build();
    private static final SdkField<Integer> PENDING_TASKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Cluster.getter(Cluster::pendingTasksCount)).setter(Cluster.setter(Builder::pendingTasksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingTasksCount").build()}).build();
    private static final SdkField<Integer> ACTIVE_SERVICES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Cluster.getter(Cluster::activeServicesCount)).setter(Cluster.setter(Builder::activeServicesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeServicesCount").build()}).build();
    private static final SdkField<List<KeyValuePair>> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Cluster.getter(Cluster::statistics)).setter(Cluster.setter(Builder::statistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Cluster.getter(Cluster::tags)).setter(Cluster.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ClusterSetting>> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Cluster.getter(Cluster::settings)).setter(Cluster.setter(Builder::settings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CAPACITY_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Cluster.getter(Cluster::capacityProviders)).setter(Cluster.setter(Builder::capacityProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CapacityProviderStrategyItem>> DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Cluster.getter(Cluster::defaultCapacityProviderStrategy)).setter(Cluster.setter(Builder::defaultCapacityProviderStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultCapacityProviderStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityProviderStrategyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Attachment>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Cluster.getter(Cluster::attachments)).setter(Cluster.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ATTACHMENTS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Cluster.getter(Cluster::attachmentsStatus)).setter(Cluster.setter(Builder::attachmentsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentsStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CLUSTER_NAME_FIELD, STATUS_FIELD, REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD, RUNNING_TASKS_COUNT_FIELD, PENDING_TASKS_COUNT_FIELD, ACTIVE_SERVICES_COUNT_FIELD, STATISTICS_FIELD, TAGS_FIELD, SETTINGS_FIELD, CAPACITY_PROVIDERS_FIELD, DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD, ATTACHMENTS_FIELD, ATTACHMENTS_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clusterArn;
    private final String clusterName;
    private final String status;
    private final Integer registeredContainerInstancesCount;
    private final Integer runningTasksCount;
    private final Integer pendingTasksCount;
    private final Integer activeServicesCount;
    private final List<KeyValuePair> statistics;
    private final List<Tag> tags;
    private final List<ClusterSetting> settings;
    private final List<String> capacityProviders;
    private final List<CapacityProviderStrategyItem> defaultCapacityProviderStrategy;
    private final List<Attachment> attachments;
    private final String attachmentsStatus;

    private Cluster(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.status = builder.status;
        this.registeredContainerInstancesCount = builder.registeredContainerInstancesCount;
        this.runningTasksCount = builder.runningTasksCount;
        this.pendingTasksCount = builder.pendingTasksCount;
        this.activeServicesCount = builder.activeServicesCount;
        this.statistics = builder.statistics;
        this.tags = builder.tags;
        this.settings = builder.settings;
        this.capacityProviders = builder.capacityProviders;
        this.defaultCapacityProviderStrategy = builder.defaultCapacityProviderStrategy;
        this.attachments = builder.attachments;
        this.attachmentsStatus = builder.attachmentsStatus;
    }

    public String clusterArn() {
        return this.clusterArn;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String status() {
        return this.status;
    }

    public Integer registeredContainerInstancesCount() {
        return this.registeredContainerInstancesCount;
    }

    public Integer runningTasksCount() {
        return this.runningTasksCount;
    }

    public Integer pendingTasksCount() {
        return this.pendingTasksCount;
    }

    public Integer activeServicesCount() {
        return this.activeServicesCount;
    }

    public boolean hasStatistics() {
        return this.statistics != null && !(this.statistics instanceof SdkAutoConstructList);
    }

    public List<KeyValuePair> statistics() {
        return this.statistics;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public boolean hasSettings() {
        return this.settings != null && !(this.settings instanceof SdkAutoConstructList);
    }

    public List<ClusterSetting> settings() {
        return this.settings;
    }

    public boolean hasCapacityProviders() {
        return this.capacityProviders != null && !(this.capacityProviders instanceof SdkAutoConstructList);
    }

    public List<String> capacityProviders() {
        return this.capacityProviders;
    }

    public boolean hasDefaultCapacityProviderStrategy() {
        return this.defaultCapacityProviderStrategy != null && !(this.defaultCapacityProviderStrategy instanceof SdkAutoConstructList);
    }

    public List<CapacityProviderStrategyItem> defaultCapacityProviderStrategy() {
        return this.defaultCapacityProviderStrategy;
    }

    public boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public List<Attachment> attachments() {
        return this.attachments;
    }

    public String attachmentsStatus() {
        return this.attachmentsStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredContainerInstancesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeServicesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProviders());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCapacityProviderStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentsStatus());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.registeredContainerInstancesCount(), other.registeredContainerInstancesCount()) && Objects.equals(this.runningTasksCount(), other.runningTasksCount()) && Objects.equals(this.pendingTasksCount(), other.pendingTasksCount()) && Objects.equals(this.activeServicesCount(), other.activeServicesCount()) && Objects.equals(this.statistics(), other.statistics()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.capacityProviders(), other.capacityProviders()) && Objects.equals(this.defaultCapacityProviderStrategy(), other.defaultCapacityProviderStrategy()) && Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.attachmentsStatus(), other.attachmentsStatus());
    }

    public String toString() {
        return ToString.builder((String)"Cluster").add("ClusterArn", (Object)this.clusterArn()).add("ClusterName", (Object)this.clusterName()).add("Status", (Object)this.status()).add("RegisteredContainerInstancesCount", (Object)this.registeredContainerInstancesCount()).add("RunningTasksCount", (Object)this.runningTasksCount()).add("PendingTasksCount", (Object)this.pendingTasksCount()).add("ActiveServicesCount", (Object)this.activeServicesCount()).add("Statistics", this.statistics()).add("Tags", this.tags()).add("Settings", this.settings()).add("CapacityProviders", this.capacityProviders()).add("DefaultCapacityProviderStrategy", this.defaultCapacityProviderStrategy()).add("Attachments", this.attachments()).add("AttachmentsStatus", (Object)this.attachmentsStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "registeredContainerInstancesCount": {
                return Optional.ofNullable(clazz.cast(this.registeredContainerInstancesCount()));
            }
            case "runningTasksCount": {
                return Optional.ofNullable(clazz.cast(this.runningTasksCount()));
            }
            case "pendingTasksCount": {
                return Optional.ofNullable(clazz.cast(this.pendingTasksCount()));
            }
            case "activeServicesCount": {
                return Optional.ofNullable(clazz.cast(this.activeServicesCount()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "capacityProviders": {
                return Optional.ofNullable(clazz.cast(this.capacityProviders()));
            }
            case "defaultCapacityProviderStrategy": {
                return Optional.ofNullable(clazz.cast(this.defaultCapacityProviderStrategy()));
            }
            case "attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "attachmentsStatus": {
                return Optional.ofNullable(clazz.cast(this.attachmentsStatus()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterArn;
        private String clusterName;
        private String status;
        private Integer registeredContainerInstancesCount;
        private Integer runningTasksCount;
        private Integer pendingTasksCount;
        private Integer activeServicesCount;
        private List<KeyValuePair> statistics = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<ClusterSetting> settings = DefaultSdkAutoConstructList.getInstance();
        private List<String> capacityProviders = DefaultSdkAutoConstructList.getInstance();
        private List<CapacityProviderStrategyItem> defaultCapacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();
        private List<Attachment> attachments = DefaultSdkAutoConstructList.getInstance();
        private String attachmentsStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.clusterArn(model.clusterArn);
            this.clusterName(model.clusterName);
            this.status(model.status);
            this.registeredContainerInstancesCount(model.registeredContainerInstancesCount);
            this.runningTasksCount(model.runningTasksCount);
            this.pendingTasksCount(model.pendingTasksCount);
            this.activeServicesCount(model.activeServicesCount);
            this.statistics(model.statistics);
            this.tags(model.tags);
            this.settings(model.settings);
            this.capacityProviders(model.capacityProviders);
            this.defaultCapacityProviderStrategy(model.defaultCapacityProviderStrategy);
            this.attachments(model.attachments);
            this.attachmentsStatus(model.attachmentsStatus);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getRegisteredContainerInstancesCount() {
            return this.registeredContainerInstancesCount;
        }

        @Override
        public final Builder registeredContainerInstancesCount(Integer registeredContainerInstancesCount) {
            this.registeredContainerInstancesCount = registeredContainerInstancesCount;
            return this;
        }

        public final void setRegisteredContainerInstancesCount(Integer registeredContainerInstancesCount) {
            this.registeredContainerInstancesCount = registeredContainerInstancesCount;
        }

        public final Integer getRunningTasksCount() {
            return this.runningTasksCount;
        }

        @Override
        public final Builder runningTasksCount(Integer runningTasksCount) {
            this.runningTasksCount = runningTasksCount;
            return this;
        }

        public final void setRunningTasksCount(Integer runningTasksCount) {
            this.runningTasksCount = runningTasksCount;
        }

        public final Integer getPendingTasksCount() {
            return this.pendingTasksCount;
        }

        @Override
        public final Builder pendingTasksCount(Integer pendingTasksCount) {
            this.pendingTasksCount = pendingTasksCount;
            return this;
        }

        public final void setPendingTasksCount(Integer pendingTasksCount) {
            this.pendingTasksCount = pendingTasksCount;
        }

        public final Integer getActiveServicesCount() {
            return this.activeServicesCount;
        }

        @Override
        public final Builder activeServicesCount(Integer activeServicesCount) {
            this.activeServicesCount = activeServicesCount;
            return this;
        }

        public final void setActiveServicesCount(Integer activeServicesCount) {
            this.activeServicesCount = activeServicesCount;
        }

        public final Collection<KeyValuePair.Builder> getStatistics() {
            return this.statistics != null ? (Collection)this.statistics.stream().map(KeyValuePair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statistics(Collection<KeyValuePair> statistics) {
            this.statistics = StatisticsCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(KeyValuePair ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(Consumer<KeyValuePair.Builder> ... statistics) {
            this.statistics(Stream.of(statistics).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatistics(Collection<KeyValuePair.BuilderImpl> statistics) {
            this.statistics = StatisticsCopier.copyFromBuilder(statistics);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final Collection<ClusterSetting.Builder> getSettings() {
            return this.settings != null ? (Collection)this.settings.stream().map(ClusterSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder settings(Collection<ClusterSetting> settings) {
            this.settings = ClusterSettingsCopier.copy(settings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder settings(ClusterSetting ... settings) {
            this.settings(Arrays.asList(settings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder settings(Consumer<ClusterSetting.Builder> ... settings) {
            this.settings(Stream.of(settings).map(c -> (ClusterSetting)((ClusterSetting.Builder)ClusterSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSettings(Collection<ClusterSetting.BuilderImpl> settings) {
            this.settings = ClusterSettingsCopier.copyFromBuilder(settings);
        }

        public final Collection<String> getCapacityProviders() {
            return this.capacityProviders;
        }

        @Override
        public final Builder capacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = StringListCopier.copy(capacityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviders(String ... capacityProviders) {
            this.capacityProviders(Arrays.asList(capacityProviders));
            return this;
        }

        public final void setCapacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = StringListCopier.copy(capacityProviders);
        }

        public final Collection<CapacityProviderStrategyItem.Builder> getDefaultCapacityProviderStrategy() {
            return this.defaultCapacityProviderStrategy != null ? (Collection)this.defaultCapacityProviderStrategy.stream().map(CapacityProviderStrategyItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder defaultCapacityProviderStrategy(Collection<CapacityProviderStrategyItem> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = CapacityProviderStrategyCopier.copy(defaultCapacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultCapacityProviderStrategy(CapacityProviderStrategyItem ... defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy(Arrays.asList(defaultCapacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultCapacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy(Stream.of(defaultCapacityProviderStrategy).map(c -> (CapacityProviderStrategyItem)((CapacityProviderStrategyItem.Builder)CapacityProviderStrategyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDefaultCapacityProviderStrategy(Collection<CapacityProviderStrategyItem.BuilderImpl> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(defaultCapacityProviderStrategy);
        }

        public final Collection<Attachment.Builder> getAttachments() {
            return this.attachments != null ? (Collection)this.attachments.stream().map(Attachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachments(Collection<Attachment> attachments) {
            this.attachments = AttachmentsCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Attachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<Attachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (Attachment)((Attachment.Builder)Attachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachments(Collection<Attachment.BuilderImpl> attachments) {
            this.attachments = AttachmentsCopier.copyFromBuilder(attachments);
        }

        public final String getAttachmentsStatus() {
            return this.attachmentsStatus;
        }

        @Override
        public final Builder attachmentsStatus(String attachmentsStatus) {
            this.attachmentsStatus = attachmentsStatus;
            return this;
        }

        public final void setAttachmentsStatus(String attachmentsStatus) {
            this.attachmentsStatus = attachmentsStatus;
        }

        public Cluster build() {
            return new Cluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cluster> {
        public Builder clusterArn(String var1);

        public Builder clusterName(String var1);

        public Builder status(String var1);

        public Builder registeredContainerInstancesCount(Integer var1);

        public Builder runningTasksCount(Integer var1);

        public Builder pendingTasksCount(Integer var1);

        public Builder activeServicesCount(Integer var1);

        public Builder statistics(Collection<KeyValuePair> var1);

        public Builder statistics(KeyValuePair ... var1);

        public Builder statistics(Consumer<KeyValuePair.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder settings(Collection<ClusterSetting> var1);

        public Builder settings(ClusterSetting ... var1);

        public Builder settings(Consumer<ClusterSetting.Builder> ... var1);

        public Builder capacityProviders(Collection<String> var1);

        public Builder capacityProviders(String ... var1);

        public Builder defaultCapacityProviderStrategy(Collection<CapacityProviderStrategyItem> var1);

        public Builder defaultCapacityProviderStrategy(CapacityProviderStrategyItem ... var1);

        public Builder defaultCapacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... var1);

        public Builder attachments(Collection<Attachment> var1);

        public Builder attachments(Attachment ... var1);

        public Builder attachments(Consumer<Attachment.Builder> ... var1);

        public Builder attachmentsStatus(String var1);
    }
}

