/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecs.EcsAsyncClient;
import software.amazon.awssdk.services.ecs.model.ListTasksRequest;
import software.amazon.awssdk.services.ecs.model.ListTasksResponse;

public class ListTasksPublisher
implements SdkPublisher<ListTasksResponse> {
    private final EcsAsyncClient client;
    private final ListTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTasksPublisher(EcsAsyncClient client, ListTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTasksPublisher(EcsAsyncClient client, ListTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> taskArns() {
        Function<ListTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskArns() != null) {
                return response.taskArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTasksResponseFetcher
    implements AsyncPageFetcher<ListTasksResponse> {
        private ListTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTasksResponse> nextPage(ListTasksResponse previousPage) {
            if (previousPage == null) {
                return ListTasksPublisher.this.client.listTasks(ListTasksPublisher.this.firstRequest);
            }
            return ListTasksPublisher.this.client.listTasks((ListTasksRequest)((Object)ListTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

