/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyCopier;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem;
import software.amazon.awssdk.services.ecs.model.DeploymentConfiguration;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.NetworkConfiguration;
import software.amazon.awssdk.services.ecs.model.PlacementConstraint;
import software.amazon.awssdk.services.ecs.model.PlacementConstraintsCopier;
import software.amazon.awssdk.services.ecs.model.PlacementStrategiesCopier;
import software.amazon.awssdk.services.ecs.model.PlacementStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServiceRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, UpdateServiceRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateServiceRequest.getter(UpdateServiceRequest::cluster)).setter(UpdateServiceRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateServiceRequest.getter(UpdateServiceRequest::service)).setter(UpdateServiceRequest.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()}).build();
    private static final SdkField<Integer> DESIRED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateServiceRequest.getter(UpdateServiceRequest::desiredCount)).setter(UpdateServiceRequest.setter(Builder::desiredCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCount").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateServiceRequest.getter(UpdateServiceRequest::taskDefinition)).setter(UpdateServiceRequest.setter(Builder::taskDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()}).build();
    private static final SdkField<List<CapacityProviderStrategyItem>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateServiceRequest.getter(UpdateServiceRequest::capacityProviderStrategy)).setter(UpdateServiceRequest.setter(Builder::capacityProviderStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityProviderStrategyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateServiceRequest.getter(UpdateServiceRequest::deploymentConfiguration)).setter(UpdateServiceRequest.setter(Builder::deploymentConfiguration)).constructor(DeploymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateServiceRequest.getter(UpdateServiceRequest::networkConfiguration)).setter(UpdateServiceRequest.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<List<PlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateServiceRequest.getter(UpdateServiceRequest::placementConstraints)).setter(UpdateServiceRequest.setter(Builder::placementConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PlacementStrategy>> PLACEMENT_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateServiceRequest.getter(UpdateServiceRequest::placementStrategy)).setter(UpdateServiceRequest.setter(Builder::placementStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateServiceRequest.getter(UpdateServiceRequest::platformVersion)).setter(UpdateServiceRequest.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<Boolean> FORCE_NEW_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateServiceRequest.getter(UpdateServiceRequest::forceNewDeployment)).setter(UpdateServiceRequest.setter(Builder::forceNewDeployment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceNewDeployment").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateServiceRequest.getter(UpdateServiceRequest::healthCheckGracePeriodSeconds)).setter(UpdateServiceRequest.setter(Builder::healthCheckGracePeriodSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckGracePeriodSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, SERVICE_FIELD, DESIRED_COUNT_FIELD, TASK_DEFINITION_FIELD, CAPACITY_PROVIDER_STRATEGY_FIELD, DEPLOYMENT_CONFIGURATION_FIELD, NETWORK_CONFIGURATION_FIELD, PLACEMENT_CONSTRAINTS_FIELD, PLACEMENT_STRATEGY_FIELD, PLATFORM_VERSION_FIELD, FORCE_NEW_DEPLOYMENT_FIELD, HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD));
    private final String cluster;
    private final String service;
    private final Integer desiredCount;
    private final String taskDefinition;
    private final List<CapacityProviderStrategyItem> capacityProviderStrategy;
    private final DeploymentConfiguration deploymentConfiguration;
    private final NetworkConfiguration networkConfiguration;
    private final List<PlacementConstraint> placementConstraints;
    private final List<PlacementStrategy> placementStrategy;
    private final String platformVersion;
    private final Boolean forceNewDeployment;
    private final Integer healthCheckGracePeriodSeconds;

    private UpdateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.service = builder.service;
        this.desiredCount = builder.desiredCount;
        this.taskDefinition = builder.taskDefinition;
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.networkConfiguration = builder.networkConfiguration;
        this.placementConstraints = builder.placementConstraints;
        this.placementStrategy = builder.placementStrategy;
        this.platformVersion = builder.platformVersion;
        this.forceNewDeployment = builder.forceNewDeployment;
        this.healthCheckGracePeriodSeconds = builder.healthCheckGracePeriodSeconds;
    }

    public String cluster() {
        return this.cluster;
    }

    public String service() {
        return this.service;
    }

    public Integer desiredCount() {
        return this.desiredCount;
    }

    public String taskDefinition() {
        return this.taskDefinition;
    }

    public boolean hasCapacityProviderStrategy() {
        return this.capacityProviderStrategy != null && !(this.capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    public List<CapacityProviderStrategyItem> capacityProviderStrategy() {
        return this.capacityProviderStrategy;
    }

    public DeploymentConfiguration deploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public boolean hasPlacementConstraints() {
        return this.placementConstraints != null && !(this.placementConstraints instanceof SdkAutoConstructList);
    }

    public List<PlacementConstraint> placementConstraints() {
        return this.placementConstraints;
    }

    public boolean hasPlacementStrategy() {
        return this.placementStrategy != null && !(this.placementStrategy instanceof SdkAutoConstructList);
    }

    public List<PlacementStrategy> placementStrategy() {
        return this.placementStrategy;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public Boolean forceNewDeployment() {
        return this.forceNewDeployment;
    }

    public Integer healthCheckGracePeriodSeconds() {
        return this.healthCheckGracePeriodSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProviderStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementConstraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceNewDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckGracePeriodSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceRequest)) {
            return false;
        }
        UpdateServiceRequest other = (UpdateServiceRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.desiredCount(), other.desiredCount()) && Objects.equals(this.taskDefinition(), other.taskDefinition()) && Objects.equals(this.capacityProviderStrategy(), other.capacityProviderStrategy()) && Objects.equals(this.deploymentConfiguration(), other.deploymentConfiguration()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.placementConstraints(), other.placementConstraints()) && Objects.equals(this.placementStrategy(), other.placementStrategy()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.forceNewDeployment(), other.forceNewDeployment()) && Objects.equals(this.healthCheckGracePeriodSeconds(), other.healthCheckGracePeriodSeconds());
    }

    public String toString() {
        return ToString.builder((String)"UpdateServiceRequest").add("Cluster", (Object)this.cluster()).add("Service", (Object)this.service()).add("DesiredCount", (Object)this.desiredCount()).add("TaskDefinition", (Object)this.taskDefinition()).add("CapacityProviderStrategy", this.capacityProviderStrategy()).add("DeploymentConfiguration", (Object)this.deploymentConfiguration()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("PlacementConstraints", this.placementConstraints()).add("PlacementStrategy", this.placementStrategy()).add("PlatformVersion", (Object)this.platformVersion()).add("ForceNewDeployment", (Object)this.forceNewDeployment()).add("HealthCheckGracePeriodSeconds", (Object)this.healthCheckGracePeriodSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "desiredCount": {
                return Optional.ofNullable(clazz.cast(this.desiredCount()));
            }
            case "taskDefinition": {
                return Optional.ofNullable(clazz.cast(this.taskDefinition()));
            }
            case "capacityProviderStrategy": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderStrategy()));
            }
            case "deploymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfiguration()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "placementConstraints": {
                return Optional.ofNullable(clazz.cast(this.placementConstraints()));
            }
            case "placementStrategy": {
                return Optional.ofNullable(clazz.cast(this.placementStrategy()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "forceNewDeployment": {
                return Optional.ofNullable(clazz.cast(this.forceNewDeployment()));
            }
            case "healthCheckGracePeriodSeconds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckGracePeriodSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceRequest, T> g) {
        return obj -> g.apply((UpdateServiceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private String service;
        private Integer desiredCount;
        private String taskDefinition;
        private List<CapacityProviderStrategyItem> capacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();
        private DeploymentConfiguration deploymentConfiguration;
        private NetworkConfiguration networkConfiguration;
        private List<PlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();
        private List<PlacementStrategy> placementStrategy = DefaultSdkAutoConstructList.getInstance();
        private String platformVersion;
        private Boolean forceNewDeployment;
        private Integer healthCheckGracePeriodSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.service(model.service);
            this.desiredCount(model.desiredCount);
            this.taskDefinition(model.taskDefinition);
            this.capacityProviderStrategy(model.capacityProviderStrategy);
            this.deploymentConfiguration(model.deploymentConfiguration);
            this.networkConfiguration(model.networkConfiguration);
            this.placementConstraints(model.placementConstraints);
            this.placementStrategy(model.placementStrategy);
            this.platformVersion(model.platformVersion);
            this.forceNewDeployment(model.forceNewDeployment);
            this.healthCheckGracePeriodSeconds(model.healthCheckGracePeriodSeconds);
        }

        public final String getCluster() {
            return this.cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getService() {
            return this.service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final Integer getDesiredCount() {
            return this.desiredCount;
        }

        @Override
        public final Builder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final void setDesiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
        }

        public final String getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        public final Collection<CapacityProviderStrategyItem.Builder> getCapacityProviderStrategy() {
            return this.capacityProviderStrategy != null ? (Collection)this.capacityProviderStrategy.stream().map(CapacityProviderStrategyItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(CapacityProviderStrategyItem ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Stream.of(capacityProviderStrategy).map(c -> (CapacityProviderStrategyItem)((CapacityProviderStrategyItem.Builder)CapacityProviderStrategyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCapacityProviderStrategy(Collection<CapacityProviderStrategyItem.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(capacityProviderStrategy);
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return this.deploymentConfiguration != null ? this.deploymentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final Collection<PlacementConstraint.Builder> getPlacementConstraints() {
            return this.placementConstraints != null ? (Collection)this.placementConstraints.stream().map(PlacementConstraint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementConstraints(Collection<PlacementConstraint> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(PlacementConstraint ... placementConstraints) {
            this.placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<PlacementConstraint.Builder> ... placementConstraints) {
            this.placementConstraints(Stream.of(placementConstraints).map(c -> (PlacementConstraint)((PlacementConstraint.Builder)PlacementConstraint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementConstraints(Collection<PlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        public final Collection<PlacementStrategy.Builder> getPlacementStrategy() {
            return this.placementStrategy != null ? (Collection)this.placementStrategy.stream().map(PlacementStrategy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementStrategy(Collection<PlacementStrategy> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copy(placementStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(PlacementStrategy ... placementStrategy) {
            this.placementStrategy(Arrays.asList(placementStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(Consumer<PlacementStrategy.Builder> ... placementStrategy) {
            this.placementStrategy(Stream.of(placementStrategy).map(c -> (PlacementStrategy)((PlacementStrategy.Builder)PlacementStrategy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementStrategy(Collection<PlacementStrategy.BuilderImpl> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copyFromBuilder(placementStrategy);
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final Boolean getForceNewDeployment() {
            return this.forceNewDeployment;
        }

        @Override
        public final Builder forceNewDeployment(Boolean forceNewDeployment) {
            this.forceNewDeployment = forceNewDeployment;
            return this;
        }

        public final void setForceNewDeployment(Boolean forceNewDeployment) {
            this.forceNewDeployment = forceNewDeployment;
        }

        public final Integer getHealthCheckGracePeriodSeconds() {
            return this.healthCheckGracePeriodSeconds;
        }

        @Override
        public final Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
            return this;
        }

        public final void setHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceRequest build() {
            return new UpdateServiceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServiceRequest> {
        public Builder cluster(String var1);

        public Builder service(String var1);

        public Builder desiredCount(Integer var1);

        public Builder taskDefinition(String var1);

        public Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> var1);

        public Builder capacityProviderStrategy(CapacityProviderStrategyItem ... var1);

        public Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... var1);

        public Builder deploymentConfiguration(DeploymentConfiguration var1);

        default public Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return this.deploymentConfiguration((DeploymentConfiguration)((DeploymentConfiguration.Builder)DeploymentConfiguration.builder().applyMutation(deploymentConfiguration)).build());
        }

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder placementConstraints(Collection<PlacementConstraint> var1);

        public Builder placementConstraints(PlacementConstraint ... var1);

        public Builder placementConstraints(Consumer<PlacementConstraint.Builder> ... var1);

        public Builder placementStrategy(Collection<PlacementStrategy> var1);

        public Builder placementStrategy(PlacementStrategy ... var1);

        public Builder placementStrategy(Consumer<PlacementStrategy.Builder> ... var1);

        public Builder platformVersion(String var1);

        public Builder forceNewDeployment(Boolean var1);

        public Builder healthCheckGracePeriodSeconds(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

