/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum UlimitName {
    CORE("core"),
    CPU("cpu"),
    DATA("data"),
    FSIZE("fsize"),
    LOCKS("locks"),
    MEMLOCK("memlock"),
    MSGQUEUE("msgqueue"),
    NICE("nice"),
    NOFILE("nofile"),
    NPROC("nproc"),
    RSS("rss"),
    RTPRIO("rtprio"),
    RTTIME("rttime"),
    SIGPENDING("sigpending"),
    STACK("stack"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private UlimitName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UlimitName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(UlimitName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UlimitName> knownValues() {
        return Stream.of(UlimitName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

