/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes properties of a Dedicated Host.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HostProperties implements SdkPojo, Serializable, ToCopyableBuilder<HostProperties.Builder, HostProperties> {
    private static final SdkField<Integer> CORES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HostProperties::cores))
            .setter(setter(Builder::cores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cores")
                    .unmarshallLocationName("cores").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HostProperties::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<Integer> SOCKETS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HostProperties::sockets))
            .setter(setter(Builder::sockets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sockets")
                    .unmarshallLocationName("sockets").build()).build();

    private static final SdkField<Integer> TOTAL_V_CPUS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HostProperties::totalVCpus))
            .setter(setter(Builder::totalVCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalVCpus")
                    .unmarshallLocationName("totalVCpus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORES_FIELD,
            INSTANCE_TYPE_FIELD, SOCKETS_FIELD, TOTAL_V_CPUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer cores;

    private final String instanceType;

    private final Integer sockets;

    private final Integer totalVCpus;

    private HostProperties(BuilderImpl builder) {
        this.cores = builder.cores;
        this.instanceType = builder.instanceType;
        this.sockets = builder.sockets;
        this.totalVCpus = builder.totalVCpus;
    }

    /**
     * <p>
     * The number of cores on the Dedicated Host.
     * </p>
     * 
     * @return The number of cores on the Dedicated Host.
     */
    public Integer cores() {
        return cores;
    }

    /**
     * <p>
     * The instance type size that the Dedicated Host supports (for example, <code>m3.medium</code>).
     * </p>
     * 
     * @return The instance type size that the Dedicated Host supports (for example, <code>m3.medium</code>).
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The number of sockets on the Dedicated Host.
     * </p>
     * 
     * @return The number of sockets on the Dedicated Host.
     */
    public Integer sockets() {
        return sockets;
    }

    /**
     * <p>
     * The number of vCPUs on the Dedicated Host.
     * </p>
     * 
     * @return The number of vCPUs on the Dedicated Host.
     */
    public Integer totalVCpus() {
        return totalVCpus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cores());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(sockets());
        hashCode = 31 * hashCode + Objects.hashCode(totalVCpus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostProperties)) {
            return false;
        }
        HostProperties other = (HostProperties) obj;
        return Objects.equals(cores(), other.cores()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(sockets(), other.sockets()) && Objects.equals(totalVCpus(), other.totalVCpus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HostProperties").add("Cores", cores()).add("InstanceType", instanceType())
                .add("Sockets", sockets()).add("TotalVCpus", totalVCpus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cores":
            return Optional.ofNullable(clazz.cast(cores()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "Sockets":
            return Optional.ofNullable(clazz.cast(sockets()));
        case "TotalVCpus":
            return Optional.ofNullable(clazz.cast(totalVCpus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HostProperties, T> g) {
        return obj -> g.apply((HostProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HostProperties> {
        /**
         * <p>
         * The number of cores on the Dedicated Host.
         * </p>
         * 
         * @param cores
         *        The number of cores on the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cores(Integer cores);

        /**
         * <p>
         * The instance type size that the Dedicated Host supports (for example, <code>m3.medium</code>).
         * </p>
         * 
         * @param instanceType
         *        The instance type size that the Dedicated Host supports (for example, <code>m3.medium</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The number of sockets on the Dedicated Host.
         * </p>
         * 
         * @param sockets
         *        The number of sockets on the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sockets(Integer sockets);

        /**
         * <p>
         * The number of vCPUs on the Dedicated Host.
         * </p>
         * 
         * @param totalVCpus
         *        The number of vCPUs on the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalVCpus(Integer totalVCpus);
    }

    static final class BuilderImpl implements Builder {
        private Integer cores;

        private String instanceType;

        private Integer sockets;

        private Integer totalVCpus;

        private BuilderImpl() {
        }

        private BuilderImpl(HostProperties model) {
            cores(model.cores);
            instanceType(model.instanceType);
            sockets(model.sockets);
            totalVCpus(model.totalVCpus);
        }

        public final Integer getCores() {
            return cores;
        }

        @Override
        public final Builder cores(Integer cores) {
            this.cores = cores;
            return this;
        }

        public final void setCores(Integer cores) {
            this.cores = cores;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getSockets() {
            return sockets;
        }

        @Override
        public final Builder sockets(Integer sockets) {
            this.sockets = sockets;
            return this;
        }

        public final void setSockets(Integer sockets) {
            this.sockets = sockets;
        }

        public final Integer getTotalVCpus() {
            return totalVCpus;
        }

        @Override
        public final Builder totalVCpus(Integer totalVCpus) {
            this.totalVCpus = totalVCpus;
            return this;
        }

        public final void setTotalVCpus(Integer totalVCpus) {
            this.totalVCpus = totalVCpus;
        }

        @Override
        public HostProperties build() {
            return new HostProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
