/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateTransitGatewayRouteTableResponse extends Ec2Response implements
        ToCopyableBuilder<DisassociateTransitGatewayRouteTableResponse.Builder, DisassociateTransitGatewayRouteTableResponse> {
    private static final SdkField<TransitGatewayAssociation> ASSOCIATION_FIELD = SdkField
            .<TransitGatewayAssociation> builder(MarshallingType.SDK_POJO)
            .getter(getter(DisassociateTransitGatewayRouteTableResponse::association))
            .setter(setter(Builder::association))
            .constructor(TransitGatewayAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association")
                    .unmarshallLocationName("association").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FIELD));

    private final TransitGatewayAssociation association;

    private DisassociateTransitGatewayRouteTableResponse(BuilderImpl builder) {
        super(builder);
        this.association = builder.association;
    }

    /**
     * <p>
     * Information about the association.
     * </p>
     * 
     * @return Information about the association.
     */
    public TransitGatewayAssociation association() {
        return association;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(association());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateTransitGatewayRouteTableResponse)) {
            return false;
        }
        DisassociateTransitGatewayRouteTableResponse other = (DisassociateTransitGatewayRouteTableResponse) obj;
        return Objects.equals(association(), other.association());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DisassociateTransitGatewayRouteTableResponse").add("Association", association()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Association":
            return Optional.ofNullable(clazz.cast(association()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateTransitGatewayRouteTableResponse, T> g) {
        return obj -> g.apply((DisassociateTransitGatewayRouteTableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateTransitGatewayRouteTableResponse> {
        /**
         * <p>
         * Information about the association.
         * </p>
         * 
         * @param association
         *        Information about the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder association(TransitGatewayAssociation association);

        /**
         * <p>
         * Information about the association.
         * </p>
         * This is a convenience that creates an instance of the {@link TransitGatewayAssociation.Builder} avoiding the
         * need to create one manually via {@link TransitGatewayAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayAssociation.Builder#build()} is called immediately
         * and its result is passed to {@link #association(TransitGatewayAssociation)}.
         * 
         * @param association
         *        a consumer that will call methods on {@link TransitGatewayAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #association(TransitGatewayAssociation)
         */
        default Builder association(Consumer<TransitGatewayAssociation.Builder> association) {
            return association(TransitGatewayAssociation.builder().applyMutation(association).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGatewayAssociation association;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateTransitGatewayRouteTableResponse model) {
            super(model);
            association(model.association);
        }

        public final TransitGatewayAssociation.Builder getAssociation() {
            return association != null ? association.toBuilder() : null;
        }

        @Override
        public final Builder association(TransitGatewayAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(TransitGatewayAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        @Override
        public DisassociateTransitGatewayRouteTableResponse build() {
            return new DisassociateTransitGatewayRouteTableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
