/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeVpnConnections.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpnConnectionsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeVpnConnectionsRequest.Builder, DescribeVpnConnectionsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeVpnConnectionsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> VPN_CONNECTION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeVpnConnectionsRequest::vpnConnectionIds))
            .setter(setter(Builder::vpnConnectionIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId")
                    .unmarshallLocationName("VpnConnectionId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpnConnectionId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpnConnectionId").unmarshallLocationName("VpnConnectionId")
                                                    .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            VPN_CONNECTION_IDS_FIELD));

    private final List<Filter> filters;

    private final List<String> vpnConnectionIds;

    private DescribeVpnConnectionsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.vpnConnectionIds = builder.vpnConnectionIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
     * <code>deleting</code> | <code>deleted</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used for
     * devices that do not support Border Gateway Protocol (BGP).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet used in a
     * customer data center.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>type</code> - The type of VPN connection. Currently the only supported type is <code>ipsec.1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpn-connection-id</code> - The ID of the VPN connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
     *         <code>deleting</code> | <code>deleted</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used
     *         for devices that do not support Border Gateway Protocol (BGP).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet
     *         used in a customer data center.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>type</code> - The type of VPN connection. Currently the only supported type is <code>ipsec.1</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpn-connection-id</code> - The ID of the VPN connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more VPN connection IDs.
     * </p>
     * <p>
     * Default: Describes your VPN connections.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more VPN connection IDs.</p>
     *         <p>
     *         Default: Describes your VPN connections.
     */
    public List<String> vpnConnectionIds() {
        return vpnConnectionIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnectionIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnConnectionsRequest)) {
            return false;
        }
        DescribeVpnConnectionsRequest other = (DescribeVpnConnectionsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(vpnConnectionIds(), other.vpnConnectionIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeVpnConnectionsRequest").add("Filters", filters())
                .add("VpnConnectionIds", vpnConnectionIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "VpnConnectionIds":
            return Optional.ofNullable(clazz.cast(vpnConnectionIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpnConnectionsRequest, T> g) {
        return obj -> g.apply((DescribeVpnConnectionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVpnConnectionsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used for
         * devices that do not support Border Gateway Protocol (BGP).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet used
         * in a customer data center.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of VPN connection. Currently the only supported type is <code>ipsec.1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpn-connection-id</code> - The ID of the VPN connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
         *        <code>deleting</code> | <code>deleted</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used
         *        for devices that do not support Border Gateway Protocol (BGP).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet
         *        used in a customer data center.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - The type of VPN connection. Currently the only supported type is
         *        <code>ipsec.1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpn-connection-id</code> - The ID of the VPN connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used for
         * devices that do not support Border Gateway Protocol (BGP).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet used
         * in a customer data center.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of VPN connection. Currently the only supported type is <code>ipsec.1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpn-connection-id</code> - The ID of the VPN connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
         *        <code>deleting</code> | <code>deleted</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used
         *        for devices that do not support Border Gateway Protocol (BGP).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet
         *        used in a customer data center.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - The type of VPN connection. Currently the only supported type is
         *        <code>ipsec.1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpn-connection-id</code> - The ID of the VPN connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used for
         * devices that do not support Border Gateway Protocol (BGP).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet used
         * in a customer data center.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of VPN connection. Currently the only supported type is <code>ipsec.1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpn-connection-id</code> - The ID of the VPN connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * One or more VPN connection IDs.
         * </p>
         * <p>
         * Default: Describes your VPN connections.
         * </p>
         * 
         * @param vpnConnectionIds
         *        One or more VPN connection IDs.</p>
         *        <p>
         *        Default: Describes your VPN connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionIds(Collection<String> vpnConnectionIds);

        /**
         * <p>
         * One or more VPN connection IDs.
         * </p>
         * <p>
         * Default: Describes your VPN connections.
         * </p>
         * 
         * @param vpnConnectionIds
         *        One or more VPN connection IDs.</p>
         *        <p>
         *        Default: Describes your VPN connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionIds(String... vpnConnectionIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpnConnectionIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnConnectionsRequest model) {
            super(model);
            filters(model.filters);
            vpnConnectionIds(model.vpnConnectionIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getVpnConnectionIds() {
            return vpnConnectionIds;
        }

        @Override
        public final Builder vpnConnectionIds(Collection<String> vpnConnectionIds) {
            this.vpnConnectionIds = VpnConnectionIdStringListCopier.copy(vpnConnectionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnConnectionIds(String... vpnConnectionIds) {
            vpnConnectionIds(Arrays.asList(vpnConnectionIds));
            return this;
        }

        public final void setVpnConnectionIds(Collection<String> vpnConnectionIds) {
            this.vpnConnectionIds = VpnConnectionIdStringListCopier.copy(vpnConnectionIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVpnConnectionsRequest build() {
            return new DescribeVpnConnectionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
