/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSnapshotAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSnapshotAttributeResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeSnapshotAttributeResponse.Builder, DescribeSnapshotAttributeResponse> {
    private static final SdkField<List<CreateVolumePermission>> CREATE_VOLUME_PERMISSIONS_FIELD = SdkField
            .<List<CreateVolumePermission>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSnapshotAttributeResponse::createVolumePermissions))
            .setter(setter(Builder::createVolumePermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateVolumePermission")
                    .unmarshallLocationName("createVolumePermission").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CreateVolumePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateVolumePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField
            .<List<ProductCode>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSnapshotAttributeResponse::productCodes))
            .setter(setter(Builder::productCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes")
                    .unmarshallLocationName("productCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ProductCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSnapshotAttributeResponse::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CREATE_VOLUME_PERMISSIONS_FIELD, PRODUCT_CODES_FIELD, SNAPSHOT_ID_FIELD));

    private final List<CreateVolumePermission> createVolumePermissions;

    private final List<ProductCode> productCodes;

    private final String snapshotId;

    private DescribeSnapshotAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.createVolumePermissions = builder.createVolumePermissions;
        this.productCodes = builder.productCodes;
        this.snapshotId = builder.snapshotId;
    }

    /**
     * <p>
     * The users and groups that have the permissions for creating volumes from the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The users and groups that have the permissions for creating volumes from the snapshot.
     */
    public List<CreateVolumePermission> createVolumePermissions() {
        return createVolumePermissions;
    }

    /**
     * <p>
     * The product codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The product codes.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * The ID of the EBS snapshot.
     * </p>
     * 
     * @return The ID of the EBS snapshot.
     */
    public String snapshotId() {
        return snapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createVolumePermissions());
        hashCode = 31 * hashCode + Objects.hashCode(productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotAttributeResponse)) {
            return false;
        }
        DescribeSnapshotAttributeResponse other = (DescribeSnapshotAttributeResponse) obj;
        return Objects.equals(createVolumePermissions(), other.createVolumePermissions())
                && Objects.equals(productCodes(), other.productCodes()) && Objects.equals(snapshotId(), other.snapshotId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSnapshotAttributeResponse").add("CreateVolumePermissions", createVolumePermissions())
                .add("ProductCodes", productCodes()).add("SnapshotId", snapshotId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateVolumePermissions":
            return Optional.ofNullable(clazz.cast(createVolumePermissions()));
        case "ProductCodes":
            return Optional.ofNullable(clazz.cast(productCodes()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotAttributeResponse, T> g) {
        return obj -> g.apply((DescribeSnapshotAttributeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSnapshotAttributeResponse> {
        /**
         * <p>
         * The users and groups that have the permissions for creating volumes from the snapshot.
         * </p>
         * 
         * @param createVolumePermissions
         *        The users and groups that have the permissions for creating volumes from the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVolumePermissions(Collection<CreateVolumePermission> createVolumePermissions);

        /**
         * <p>
         * The users and groups that have the permissions for creating volumes from the snapshot.
         * </p>
         * 
         * @param createVolumePermissions
         *        The users and groups that have the permissions for creating volumes from the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVolumePermissions(CreateVolumePermission... createVolumePermissions);

        /**
         * <p>
         * The users and groups that have the permissions for creating volumes from the snapshot.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CreateVolumePermission>.Builder} avoiding
         * the need to create one manually via {@link List<CreateVolumePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CreateVolumePermission>.Builder#build()} is called
         * immediately and its result is passed to {@link #createVolumePermissions(List<CreateVolumePermission>)}.
         * 
         * @param createVolumePermissions
         *        a consumer that will call methods on {@link List<CreateVolumePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createVolumePermissions(List<CreateVolumePermission>)
         */
        Builder createVolumePermissions(Consumer<CreateVolumePermission.Builder>... createVolumePermissions);

        /**
         * <p>
         * The product codes.
         * </p>
         * 
         * @param productCodes
         *        The product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * The product codes.
         * </p>
         * 
         * @param productCodes
         *        The product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * The product codes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProductCode>.Builder} avoiding the need to
         * create one manually via {@link List<ProductCode>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductCode>.Builder#build()} is called immediately and its
         * result is passed to {@link #productCodes(List<ProductCode>)}.
         * 
         * @param productCodes
         *        a consumer that will call methods on {@link List<ProductCode>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productCodes(List<ProductCode>)
         */
        Builder productCodes(Consumer<ProductCode.Builder>... productCodes);

        /**
         * <p>
         * The ID of the EBS snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the EBS snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<CreateVolumePermission> createVolumePermissions = DefaultSdkAutoConstructList.getInstance();

        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();

        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotAttributeResponse model) {
            super(model);
            createVolumePermissions(model.createVolumePermissions);
            productCodes(model.productCodes);
            snapshotId(model.snapshotId);
        }

        public final Collection<CreateVolumePermission.Builder> getCreateVolumePermissions() {
            return createVolumePermissions != null ? createVolumePermissions.stream().map(CreateVolumePermission::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder createVolumePermissions(Collection<CreateVolumePermission> createVolumePermissions) {
            this.createVolumePermissions = CreateVolumePermissionListCopier.copy(createVolumePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createVolumePermissions(CreateVolumePermission... createVolumePermissions) {
            createVolumePermissions(Arrays.asList(createVolumePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createVolumePermissions(Consumer<CreateVolumePermission.Builder>... createVolumePermissions) {
            createVolumePermissions(Stream.of(createVolumePermissions)
                    .map(c -> CreateVolumePermission.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCreateVolumePermissions(Collection<CreateVolumePermission.BuilderImpl> createVolumePermissions) {
            this.createVolumePermissions = CreateVolumePermissionListCopier.copyFromBuilder(createVolumePermissions);
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return productCodes != null ? productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder>... productCodes) {
            productCodes(Stream.of(productCodes).map(c -> ProductCode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public DescribeSnapshotAttributeResponse build() {
            return new DescribeSnapshotAttributeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
