/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrafficMirrorSessionRequest extends Ec2Request implements
        ToCopyableBuilder<CreateTrafficMirrorSessionRequest.Builder, CreateTrafficMirrorSessionRequest> {
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTrafficMirrorSessionRequest::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("NetworkInterfaceId").build()).build();

    private static final SdkField<String> TRAFFIC_MIRROR_TARGET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTrafficMirrorSessionRequest::trafficMirrorTargetId))
            .setter(setter(Builder::trafficMirrorTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorTargetId")
                    .unmarshallLocationName("TrafficMirrorTargetId").build()).build();

    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTrafficMirrorSessionRequest::trafficMirrorFilterId))
            .setter(setter(Builder::trafficMirrorFilterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId")
                    .unmarshallLocationName("TrafficMirrorFilterId").build()).build();

    private static final SdkField<Integer> PACKET_LENGTH_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateTrafficMirrorSessionRequest::packetLength))
            .setter(setter(Builder::packetLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PacketLength")
                    .unmarshallLocationName("PacketLength").build()).build();

    private static final SdkField<Integer> SESSION_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateTrafficMirrorSessionRequest::sessionNumber))
            .setter(setter(Builder::sessionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionNumber")
                    .unmarshallLocationName("SessionNumber").build()).build();

    private static final SdkField<Integer> VIRTUAL_NETWORK_ID_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateTrafficMirrorSessionRequest::virtualNetworkId))
            .setter(setter(Builder::virtualNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualNetworkId")
                    .unmarshallLocationName("VirtualNetworkId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTrafficMirrorSessionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .getter(getter(CreateTrafficMirrorSessionRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTrafficMirrorSessionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ID_FIELD,
            TRAFFIC_MIRROR_TARGET_ID_FIELD, TRAFFIC_MIRROR_FILTER_ID_FIELD, PACKET_LENGTH_FIELD, SESSION_NUMBER_FIELD,
            VIRTUAL_NETWORK_ID_FIELD, DESCRIPTION_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD));

    private final String networkInterfaceId;

    private final String trafficMirrorTargetId;

    private final String trafficMirrorFilterId;

    private final Integer packetLength;

    private final Integer sessionNumber;

    private final Integer virtualNetworkId;

    private final String description;

    private final List<TagSpecification> tagSpecifications;

    private final String clientToken;

    private CreateTrafficMirrorSessionRequest(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.trafficMirrorTargetId = builder.trafficMirrorTargetId;
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.packetLength = builder.packetLength;
        this.sessionNumber = builder.sessionNumber;
        this.virtualNetworkId = builder.virtualNetworkId;
        this.description = builder.description;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the source network interface.
     * </p>
     * 
     * @return The ID of the source network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror target.
     * </p>
     * 
     * @return The ID of the Traffic Mirror target.
     */
    public String trafficMirrorTargetId() {
        return trafficMirrorTargetId;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror filter.
     * </p>
     * 
     * @return The ID of the Traffic Mirror filter.
     */
    public String trafficMirrorFilterId() {
        return trafficMirrorFilterId;
    }

    /**
     * <p>
     * The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this
     * parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the length (in
     * bytes) that you want to mirror. For example, if you set this value to 1network0, then the first 100 bytes that
     * meet the filter criteria are copied to the target.
     * </p>
     * <p>
     * If you do not want to mirror the entire packet, use the <code>PacketLength</code> parameter to specify the number
     * of bytes in each packet to mirror.
     * </p>
     * 
     * @return The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this
     *         parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the
     *         length (in bytes) that you want to mirror. For example, if you set this value to 1network0, then the
     *         first 100 bytes that meet the filter criteria are copied to the target.</p>
     *         <p>
     *         If you do not want to mirror the entire packet, use the <code>PacketLength</code> parameter to specify
     *         the number of bytes in each packet to mirror.
     */
    public Integer packetLength() {
        return packetLength;
    }

    /**
     * <p>
     * The session number determines the order in which sessions are evaluated when an interface is used by multiple
     * sessions. The first session with a matching filter is the one that mirrors the packets.
     * </p>
     * <p>
     * Valid values are 1-32766.
     * </p>
     * 
     * @return The session number determines the order in which sessions are evaluated when an interface is used by
     *         multiple sessions. The first session with a matching filter is the one that mirrors the packets.</p>
     *         <p>
     *         Valid values are 1-32766.
     */
    public Integer sessionNumber() {
        return sessionNumber;
    }

    /**
     * <p>
     * The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see <a
     * href="https://tools.ietf.org/html/rfc7348">RFC 7348</a>. If you do not specify a <code>VirtualNetworkId</code>,
     * an account-wide unique id is chosen at random.
     * </p>
     * 
     * @return The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see <a
     *         href="https://tools.ietf.org/html/rfc7348">RFC 7348</a>. If you do not specify a
     *         <code>VirtualNetworkId</code>, an account-wide unique id is chosen at random.
     */
    public Integer virtualNetworkId() {
        return virtualNetworkId;
    }

    /**
     * <p>
     * The description of the Traffic Mirror session.
     * </p>
     * 
     * @return The description of the Traffic Mirror session.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The tags to assign to a Traffic Mirror session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags to assign to a Traffic Mirror session.
     */
    public List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(packetLength());
        hashCode = 31 * hashCode + Objects.hashCode(sessionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(virtualNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(tagSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficMirrorSessionRequest)) {
            return false;
        }
        CreateTrafficMirrorSessionRequest other = (CreateTrafficMirrorSessionRequest) obj;
        return Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(trafficMirrorTargetId(), other.trafficMirrorTargetId())
                && Objects.equals(trafficMirrorFilterId(), other.trafficMirrorFilterId())
                && Objects.equals(packetLength(), other.packetLength()) && Objects.equals(sessionNumber(), other.sessionNumber())
                && Objects.equals(virtualNetworkId(), other.virtualNetworkId())
                && Objects.equals(description(), other.description())
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateTrafficMirrorSessionRequest").add("NetworkInterfaceId", networkInterfaceId())
                .add("TrafficMirrorTargetId", trafficMirrorTargetId()).add("TrafficMirrorFilterId", trafficMirrorFilterId())
                .add("PacketLength", packetLength()).add("SessionNumber", sessionNumber())
                .add("VirtualNetworkId", virtualNetworkId()).add("Description", description())
                .add("TagSpecifications", tagSpecifications()).add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "TrafficMirrorTargetId":
            return Optional.ofNullable(clazz.cast(trafficMirrorTargetId()));
        case "TrafficMirrorFilterId":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilterId()));
        case "PacketLength":
            return Optional.ofNullable(clazz.cast(packetLength()));
        case "SessionNumber":
            return Optional.ofNullable(clazz.cast(sessionNumber()));
        case "VirtualNetworkId":
            return Optional.ofNullable(clazz.cast(virtualNetworkId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficMirrorSessionRequest, T> g) {
        return obj -> g.apply((CreateTrafficMirrorSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrafficMirrorSessionRequest> {
        /**
         * <p>
         * The ID of the source network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the source network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The ID of the Traffic Mirror target.
         * </p>
         * 
         * @param trafficMirrorTargetId
         *        The ID of the Traffic Mirror target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorTargetId(String trafficMirrorTargetId);

        /**
         * <p>
         * The ID of the Traffic Mirror filter.
         * </p>
         * 
         * @param trafficMirrorFilterId
         *        The ID of the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilterId(String trafficMirrorFilterId);

        /**
         * <p>
         * The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this
         * parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the length
         * (in bytes) that you want to mirror. For example, if you set this value to 1network0, then the first 100 bytes
         * that meet the filter criteria are copied to the target.
         * </p>
         * <p>
         * If you do not want to mirror the entire packet, use the <code>PacketLength</code> parameter to specify the
         * number of bytes in each packet to mirror.
         * </p>
         * 
         * @param packetLength
         *        The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify
         *        this parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this
         *        to the length (in bytes) that you want to mirror. For example, if you set this value to 1network0,
         *        then the first 100 bytes that meet the filter criteria are copied to the target.</p>
         *        <p>
         *        If you do not want to mirror the entire packet, use the <code>PacketLength</code> parameter to specify
         *        the number of bytes in each packet to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packetLength(Integer packetLength);

        /**
         * <p>
         * The session number determines the order in which sessions are evaluated when an interface is used by multiple
         * sessions. The first session with a matching filter is the one that mirrors the packets.
         * </p>
         * <p>
         * Valid values are 1-32766.
         * </p>
         * 
         * @param sessionNumber
         *        The session number determines the order in which sessions are evaluated when an interface is used by
         *        multiple sessions. The first session with a matching filter is the one that mirrors the packets.</p>
         *        <p>
         *        Valid values are 1-32766.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionNumber(Integer sessionNumber);

        /**
         * <p>
         * The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see <a
         * href="https://tools.ietf.org/html/rfc7348">RFC 7348</a>. If you do not specify a
         * <code>VirtualNetworkId</code>, an account-wide unique id is chosen at random.
         * </p>
         * 
         * @param virtualNetworkId
         *        The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see <a
         *        href="https://tools.ietf.org/html/rfc7348">RFC 7348</a>. If you do not specify a
         *        <code>VirtualNetworkId</code>, an account-wide unique id is chosen at random.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualNetworkId(Integer virtualNetworkId);

        /**
         * <p>
         * The description of the Traffic Mirror session.
         * </p>
         * 
         * @param description
         *        The description of the Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tags to assign to a Traffic Mirror session.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to assign to a Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to assign to a Traffic Mirror session.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to assign to a Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to assign to a Traffic Mirror session.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to
         *        Ensure Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String networkInterfaceId;

        private String trafficMirrorTargetId;

        private String trafficMirrorFilterId;

        private Integer packetLength;

        private Integer sessionNumber;

        private Integer virtualNetworkId;

        private String description;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficMirrorSessionRequest model) {
            super(model);
            networkInterfaceId(model.networkInterfaceId);
            trafficMirrorTargetId(model.trafficMirrorTargetId);
            trafficMirrorFilterId(model.trafficMirrorFilterId);
            packetLength(model.packetLength);
            sessionNumber(model.sessionNumber);
            virtualNetworkId(model.virtualNetworkId);
            description(model.description);
            tagSpecifications(model.tagSpecifications);
            clientToken(model.clientToken);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getTrafficMirrorTargetId() {
            return trafficMirrorTargetId;
        }

        @Override
        public final Builder trafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
            return this;
        }

        public final void setTrafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
        }

        public final String getTrafficMirrorFilterId() {
            return trafficMirrorFilterId;
        }

        @Override
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        public final Integer getPacketLength() {
            return packetLength;
        }

        @Override
        public final Builder packetLength(Integer packetLength) {
            this.packetLength = packetLength;
            return this;
        }

        public final void setPacketLength(Integer packetLength) {
            this.packetLength = packetLength;
        }

        public final Integer getSessionNumber() {
            return sessionNumber;
        }

        @Override
        public final Builder sessionNumber(Integer sessionNumber) {
            this.sessionNumber = sessionNumber;
            return this;
        }

        public final void setSessionNumber(Integer sessionNumber) {
            this.sessionNumber = sessionNumber;
        }

        public final Integer getVirtualNetworkId() {
            return virtualNetworkId;
        }

        @Override
        public final Builder virtualNetworkId(Integer virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
            return this;
        }

        public final void setVirtualNetworkId(Integer virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return tagSpecifications != null ? tagSpecifications.stream().map(TagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrafficMirrorSessionRequest build() {
            return new CreateTrafficMirrorSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
