/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a launch permission modification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchPermissionModifications implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchPermissionModifications.Builder, LaunchPermissionModifications> {
    private static final SdkField<List<LaunchPermission>> ADD_FIELD = SdkField
            .<List<LaunchPermission>> builder(MarshallingType.LIST)
            .getter(getter(LaunchPermissionModifications::add))
            .setter(setter(Builder::add))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Add").unmarshallLocationName("Add")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<LaunchPermission>> REMOVE_FIELD = SdkField
            .<List<LaunchPermission>> builder(MarshallingType.LIST)
            .getter(getter(LaunchPermissionModifications::remove))
            .setter(setter(Builder::remove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Remove")
                    .unmarshallLocationName("Remove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_FIELD, REMOVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<LaunchPermission> add;

    private final List<LaunchPermission> remove;

    private LaunchPermissionModifications(BuilderImpl builder) {
        this.add = builder.add;
        this.remove = builder.remove;
    }

    /**
     * <p>
     * The AWS account ID to add to the list of launch permissions for the AMI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The AWS account ID to add to the list of launch permissions for the AMI.
     */
    public List<LaunchPermission> add() {
        return add;
    }

    /**
     * <p>
     * The AWS account ID to remove from the list of launch permissions for the AMI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The AWS account ID to remove from the list of launch permissions for the AMI.
     */
    public List<LaunchPermission> remove() {
        return remove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(add());
        hashCode = 31 * hashCode + Objects.hashCode(remove());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchPermissionModifications)) {
            return false;
        }
        LaunchPermissionModifications other = (LaunchPermissionModifications) obj;
        return Objects.equals(add(), other.add()) && Objects.equals(remove(), other.remove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LaunchPermissionModifications").add("Add", add()).add("Remove", remove()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Add":
            return Optional.ofNullable(clazz.cast(add()));
        case "Remove":
            return Optional.ofNullable(clazz.cast(remove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchPermissionModifications, T> g) {
        return obj -> g.apply((LaunchPermissionModifications) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchPermissionModifications> {
        /**
         * <p>
         * The AWS account ID to add to the list of launch permissions for the AMI.
         * </p>
         * 
         * @param add
         *        The AWS account ID to add to the list of launch permissions for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder add(Collection<LaunchPermission> add);

        /**
         * <p>
         * The AWS account ID to add to the list of launch permissions for the AMI.
         * </p>
         * 
         * @param add
         *        The AWS account ID to add to the list of launch permissions for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder add(LaunchPermission... add);

        /**
         * <p>
         * The AWS account ID to add to the list of launch permissions for the AMI.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LaunchPermission>.Builder} avoiding the
         * need to create one manually via {@link List<LaunchPermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchPermission>.Builder#build()} is called immediately and
         * its result is passed to {@link #add(List<LaunchPermission>)}.
         * 
         * @param add
         *        a consumer that will call methods on {@link List<LaunchPermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #add(List<LaunchPermission>)
         */
        Builder add(Consumer<LaunchPermission.Builder>... add);

        /**
         * <p>
         * The AWS account ID to remove from the list of launch permissions for the AMI.
         * </p>
         * 
         * @param remove
         *        The AWS account ID to remove from the list of launch permissions for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remove(Collection<LaunchPermission> remove);

        /**
         * <p>
         * The AWS account ID to remove from the list of launch permissions for the AMI.
         * </p>
         * 
         * @param remove
         *        The AWS account ID to remove from the list of launch permissions for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remove(LaunchPermission... remove);

        /**
         * <p>
         * The AWS account ID to remove from the list of launch permissions for the AMI.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LaunchPermission>.Builder} avoiding the
         * need to create one manually via {@link List<LaunchPermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchPermission>.Builder#build()} is called immediately and
         * its result is passed to {@link #remove(List<LaunchPermission>)}.
         * 
         * @param remove
         *        a consumer that will call methods on {@link List<LaunchPermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remove(List<LaunchPermission>)
         */
        Builder remove(Consumer<LaunchPermission.Builder>... remove);
    }

    static final class BuilderImpl implements Builder {
        private List<LaunchPermission> add = DefaultSdkAutoConstructList.getInstance();

        private List<LaunchPermission> remove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchPermissionModifications model) {
            add(model.add);
            remove(model.remove);
        }

        public final Collection<LaunchPermission.Builder> getAdd() {
            return add != null ? add.stream().map(LaunchPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder add(Collection<LaunchPermission> add) {
            this.add = LaunchPermissionListCopier.copy(add);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder add(LaunchPermission... add) {
            add(Arrays.asList(add));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder add(Consumer<LaunchPermission.Builder>... add) {
            add(Stream.of(add).map(c -> LaunchPermission.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdd(Collection<LaunchPermission.BuilderImpl> add) {
            this.add = LaunchPermissionListCopier.copyFromBuilder(add);
        }

        public final Collection<LaunchPermission.Builder> getRemove() {
            return remove != null ? remove.stream().map(LaunchPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remove(Collection<LaunchPermission> remove) {
            this.remove = LaunchPermissionListCopier.copy(remove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remove(LaunchPermission... remove) {
            remove(Arrays.asList(remove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remove(Consumer<LaunchPermission.Builder>... remove) {
            remove(Stream.of(remove).map(c -> LaunchPermission.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRemove(Collection<LaunchPermission.BuilderImpl> remove) {
            this.remove = LaunchPermissionListCopier.copyFromBuilder(remove);
        }

        @Override
        public LaunchPermissionModifications build() {
            return new LaunchPermissionModifications(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
