/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFpgaImageAttributeRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeFpgaImageAttributeRequest.Builder, DescribeFpgaImageAttributeRequest> {
    private static final SdkField<String> FPGA_IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFpgaImageAttributeRequest::fpgaImageId))
            .setter(setter(Builder::fpgaImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageId")
                    .unmarshallLocationName("FpgaImageId").build()).build();

    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFpgaImageAttributeRequest::attributeAsString))
            .setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute")
                    .unmarshallLocationName("Attribute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPGA_IMAGE_ID_FIELD,
            ATTRIBUTE_FIELD));

    private final String fpgaImageId;

    private final String attribute;

    private DescribeFpgaImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.fpgaImageId = builder.fpgaImageId;
        this.attribute = builder.attribute;
    }

    /**
     * <p>
     * The ID of the AFI.
     * </p>
     * 
     * @return The ID of the AFI.
     */
    public String fpgaImageId() {
        return fpgaImageId;
    }

    /**
     * <p>
     * The AFI attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link FpgaImageAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The AFI attribute.
     * @see FpgaImageAttributeName
     */
    public FpgaImageAttributeName attribute() {
        return FpgaImageAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The AFI attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link FpgaImageAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The AFI attribute.
     * @see FpgaImageAttributeName
     */
    public String attributeAsString() {
        return attribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFpgaImageAttributeRequest)) {
            return false;
        }
        DescribeFpgaImageAttributeRequest other = (DescribeFpgaImageAttributeRequest) obj;
        return Objects.equals(fpgaImageId(), other.fpgaImageId())
                && Objects.equals(attributeAsString(), other.attributeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeFpgaImageAttributeRequest").add("FpgaImageId", fpgaImageId())
                .add("Attribute", attributeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FpgaImageId":
            return Optional.ofNullable(clazz.cast(fpgaImageId()));
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFpgaImageAttributeRequest, T> g) {
        return obj -> g.apply((DescribeFpgaImageAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFpgaImageAttributeRequest> {
        /**
         * <p>
         * The ID of the AFI.
         * </p>
         * 
         * @param fpgaImageId
         *        The ID of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageId(String fpgaImageId);

        /**
         * <p>
         * The AFI attribute.
         * </p>
         * 
         * @param attribute
         *        The AFI attribute.
         * @see FpgaImageAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FpgaImageAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The AFI attribute.
         * </p>
         * 
         * @param attribute
         *        The AFI attribute.
         * @see FpgaImageAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FpgaImageAttributeName
         */
        Builder attribute(FpgaImageAttributeName attribute);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String fpgaImageId;

        private String attribute;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFpgaImageAttributeRequest model) {
            super(model);
            fpgaImageId(model.fpgaImageId);
            attribute(model.attribute);
        }

        public final String getFpgaImageId() {
            return fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getAttributeAsString() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(FpgaImageAttributeName attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFpgaImageAttributeRequest build() {
            return new DescribeFpgaImageAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
