/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.InstanceStatusDetails;
import software.amazon.awssdk.services.ec2.model.InstanceStatusDetailsListCopier;
import software.amazon.awssdk.services.ec2.model.SummaryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceStatusSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceStatusSummary> {
    private static final SdkField<List<InstanceStatusDetails>> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceStatusSummary.getter(InstanceStatusSummary::details)).setter(InstanceStatusSummary.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").unmarshallLocationName("details").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceStatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceStatusSummary.getter(InstanceStatusSummary::statusAsString)).setter(InstanceStatusSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<InstanceStatusDetails> details;
    private final String status;

    private InstanceStatusSummary(BuilderImpl builder) {
        this.details = builder.details;
        this.status = builder.status;
    }

    public List<InstanceStatusDetails> details() {
        return this.details;
    }

    public SummaryStatus status() {
        return SummaryStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatusSummary)) {
            return false;
        }
        InstanceStatusSummary other = (InstanceStatusSummary)obj;
        return Objects.equals(this.details(), other.details()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"InstanceStatusSummary").add("Details", this.details()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceStatusSummary, T> g) {
        return obj -> g.apply((InstanceStatusSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InstanceStatusDetails> details = DefaultSdkAutoConstructList.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatusSummary model) {
            this.details(model.details);
            this.status(model.status);
        }

        public final Collection<InstanceStatusDetails.Builder> getDetails() {
            return this.details != null ? (Collection)this.details.stream().map(InstanceStatusDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder details(Collection<InstanceStatusDetails> details) {
            this.details = InstanceStatusDetailsListCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(InstanceStatusDetails ... details) {
            this.details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<InstanceStatusDetails.Builder> ... details) {
            this.details(Stream.of(details).map(c -> (InstanceStatusDetails)((InstanceStatusDetails.Builder)InstanceStatusDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDetails(Collection<InstanceStatusDetails.BuilderImpl> details) {
            this.details = InstanceStatusDetailsListCopier.copyFromBuilder(details);
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SummaryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public InstanceStatusSummary build() {
            return new InstanceStatusSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceStatusSummary> {
        public Builder details(Collection<InstanceStatusDetails> var1);

        public Builder details(InstanceStatusDetails ... var1);

        public Builder details(Consumer<InstanceStatusDetails.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(SummaryStatus var1);
    }
}

