/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.DomainType;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AllocateAddressResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, AllocateAddressResponse> {
    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AllocateAddressResponse.getter(AllocateAddressResponse::publicIp)).setter(AllocateAddressResponse.setter(Builder::publicIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").unmarshallLocationName("publicIp").build()}).build();
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AllocateAddressResponse.getter(AllocateAddressResponse::allocationId)).setter(AllocateAddressResponse.setter(Builder::allocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("allocationId").build()}).build();
    private static final SdkField<String> PUBLIC_IPV4_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AllocateAddressResponse.getter(AllocateAddressResponse::publicIpv4Pool)).setter(AllocateAddressResponse.setter(Builder::publicIpv4Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpv4Pool").unmarshallLocationName("publicIpv4Pool").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AllocateAddressResponse.getter(AllocateAddressResponse::domainAsString)).setter(AllocateAddressResponse.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").unmarshallLocationName("domain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_IP_FIELD, ALLOCATION_ID_FIELD, PUBLIC_IPV4_POOL_FIELD, DOMAIN_FIELD));
    private final String publicIp;
    private final String allocationId;
    private final String publicIpv4Pool;
    private final String domain;

    private AllocateAddressResponse(BuilderImpl builder) {
        super(builder);
        this.publicIp = builder.publicIp;
        this.allocationId = builder.allocationId;
        this.publicIpv4Pool = builder.publicIpv4Pool;
        this.domain = builder.domain;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public String allocationId() {
        return this.allocationId;
    }

    public String publicIpv4Pool() {
        return this.publicIpv4Pool;
    }

    public DomainType domain() {
        return DomainType.fromValue(this.domain);
    }

    public String domainAsString() {
        return this.domain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateAddressResponse)) {
            return false;
        }
        AllocateAddressResponse other = (AllocateAddressResponse)((Object)obj);
        return Objects.equals(this.publicIp(), other.publicIp()) && Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.publicIpv4Pool(), other.publicIpv4Pool()) && Objects.equals(this.domainAsString(), other.domainAsString());
    }

    public String toString() {
        return ToString.builder((String)"AllocateAddressResponse").add("PublicIp", (Object)this.publicIp()).add("AllocationId", (Object)this.allocationId()).add("PublicIpv4Pool", (Object)this.publicIpv4Pool()).add("Domain", (Object)this.domainAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublicIp": {
                return Optional.ofNullable(clazz.cast(this.publicIp()));
            }
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
            case "PublicIpv4Pool": {
                return Optional.ofNullable(clazz.cast(this.publicIpv4Pool()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domainAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllocateAddressResponse, T> g) {
        return obj -> g.apply((AllocateAddressResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String publicIp;
        private String allocationId;
        private String publicIpv4Pool;
        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateAddressResponse model) {
            super(model);
            this.publicIp(model.publicIp);
            this.allocationId(model.allocationId);
            this.publicIpv4Pool(model.publicIpv4Pool);
            this.domain(model.domain);
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getPublicIpv4Pool() {
            return this.publicIpv4Pool;
        }

        @Override
        public final Builder publicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
            return this;
        }

        public final void setPublicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
        }

        public final String getDomainAsString() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public AllocateAddressResponse build() {
            return new AllocateAddressResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AllocateAddressResponse> {
        public Builder publicIp(String var1);

        public Builder allocationId(String var1);

        public Builder publicIpv4Pool(String var1);

        public Builder domain(String var1);

        public Builder domain(DomainType var1);
    }
}

