/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse;
import software.amazon.awssdk.services.ec2.model.Vpc;

public class DescribeVpcsPublisher
implements SdkPublisher<DescribeVpcsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVpcsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVpcsPublisher(Ec2AsyncClient client, DescribeVpcsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVpcsPublisher(Ec2AsyncClient client, DescribeVpcsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVpcsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVpcsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Vpc> vpcs() {
        Function<DescribeVpcsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vpcs() != null) {
                return response.vpcs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeVpcsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeVpcsResponseFetcher
    implements AsyncPageFetcher<DescribeVpcsResponse> {
        private DescribeVpcsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpcsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVpcsResponse> nextPage(DescribeVpcsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpcsPublisher.this.client.describeVpcs(DescribeVpcsPublisher.this.firstRequest);
            }
            return DescribeVpcsPublisher.this.client.describeVpcs((DescribeVpcsRequest)((Object)DescribeVpcsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

