/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.GatewayType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VpcAttachment;
import software.amazon.awssdk.services.ec2.model.VpcAttachmentListCopier;
import software.amazon.awssdk.services.ec2.model.VpnState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpnGateway
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpnGateway> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpnGateway.getter(VpnGateway::availabilityZone)).setter(VpnGateway.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpnGateway.getter(VpnGateway::stateAsString)).setter(VpnGateway.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpnGateway.getter(VpnGateway::typeAsString)).setter(VpnGateway.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<List<VpcAttachment>> VPC_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpnGateway.getter(VpnGateway::vpcAttachments)).setter(VpnGateway.setter(Builder::vpcAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").unmarshallLocationName("attachments").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VPN_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpnGateway.getter(VpnGateway::vpnGatewayId)).setter(VpnGateway.setter(Builder::vpnGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGatewayId").unmarshallLocationName("vpnGatewayId").build()}).build();
    private static final SdkField<Long> AMAZON_SIDE_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(VpnGateway.getter(VpnGateway::amazonSideAsn)).setter(VpnGateway.setter(Builder::amazonSideAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonSideAsn").unmarshallLocationName("amazonSideAsn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpnGateway.getter(VpnGateway::tags)).setter(VpnGateway.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, STATE_FIELD, TYPE_FIELD, VPC_ATTACHMENTS_FIELD, VPN_GATEWAY_ID_FIELD, AMAZON_SIDE_ASN_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final String state;
    private final String type;
    private final List<VpcAttachment> vpcAttachments;
    private final String vpnGatewayId;
    private final Long amazonSideAsn;
    private final List<Tag> tags;

    private VpnGateway(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.state = builder.state;
        this.type = builder.type;
        this.vpcAttachments = builder.vpcAttachments;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.amazonSideAsn = builder.amazonSideAsn;
        this.tags = builder.tags;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public VpnState state() {
        return VpnState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public GatewayType type() {
        return GatewayType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public List<VpcAttachment> vpcAttachments() {
        return this.vpcAttachments;
    }

    public String vpnGatewayId() {
        return this.vpnGatewayId;
    }

    public Long amazonSideAsn() {
        return this.amazonSideAsn;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnGateway)) {
            return false;
        }
        VpnGateway other = (VpnGateway)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.vpcAttachments(), other.vpcAttachments()) && Objects.equals(this.vpnGatewayId(), other.vpnGatewayId()) && Objects.equals(this.amazonSideAsn(), other.amazonSideAsn()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"VpnGateway").add("AvailabilityZone", (Object)this.availabilityZone()).add("State", (Object)this.stateAsString()).add("Type", (Object)this.typeAsString()).add("VpcAttachments", this.vpcAttachments()).add("VpnGatewayId", (Object)this.vpnGatewayId()).add("AmazonSideAsn", (Object)this.amazonSideAsn()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "VpcAttachments": {
                return Optional.ofNullable(clazz.cast(this.vpcAttachments()));
            }
            case "VpnGatewayId": {
                return Optional.ofNullable(clazz.cast(this.vpnGatewayId()));
            }
            case "AmazonSideAsn": {
                return Optional.ofNullable(clazz.cast(this.amazonSideAsn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpnGateway, T> g) {
        return obj -> g.apply((VpnGateway)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String state;
        private String type;
        private List<VpcAttachment> vpcAttachments = DefaultSdkAutoConstructList.getInstance();
        private String vpnGatewayId;
        private Long amazonSideAsn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpnGateway model) {
            this.availabilityZone(model.availabilityZone);
            this.state(model.state);
            this.type(model.type);
            this.vpcAttachments(model.vpcAttachments);
            this.vpnGatewayId(model.vpnGatewayId);
            this.amazonSideAsn(model.amazonSideAsn);
            this.tags(model.tags);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpnState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GatewayType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<VpcAttachment.Builder> getVpcAttachments() {
            return this.vpcAttachments != null ? (Collection)this.vpcAttachments.stream().map(VpcAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcAttachments(Collection<VpcAttachment> vpcAttachments) {
            this.vpcAttachments = VpcAttachmentListCopier.copy(vpcAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcAttachments(VpcAttachment ... vpcAttachments) {
            this.vpcAttachments(Arrays.asList(vpcAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcAttachments(Consumer<VpcAttachment.Builder> ... vpcAttachments) {
            this.vpcAttachments(Stream.of(vpcAttachments).map(c -> (VpcAttachment)((VpcAttachment.Builder)VpcAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcAttachments(Collection<VpcAttachment.BuilderImpl> vpcAttachments) {
            this.vpcAttachments = VpcAttachmentListCopier.copyFromBuilder(vpcAttachments);
        }

        public final String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        public final Long getAmazonSideAsn() {
            return this.amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public VpnGateway build() {
            return new VpnGateway(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpnGateway> {
        public Builder availabilityZone(String var1);

        public Builder state(String var1);

        public Builder state(VpnState var1);

        public Builder type(String var1);

        public Builder type(GatewayType var1);

        public Builder vpcAttachments(Collection<VpcAttachment> var1);

        public Builder vpcAttachments(VpcAttachment ... var1);

        public Builder vpcAttachments(Consumer<VpcAttachment.Builder> ... var1);

        public Builder vpnGatewayId(String var1);

        public Builder amazonSideAsn(Long var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

