/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteTableAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteTableAssociation> {
    private static final SdkField<Boolean> MAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(RouteTableAssociation.getter(RouteTableAssociation::main)).setter(RouteTableAssociation.setter(Builder::main)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Main").unmarshallLocationName("main").build()}).build();
    private static final SdkField<String> ROUTE_TABLE_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RouteTableAssociation.getter(RouteTableAssociation::routeTableAssociationId)).setter(RouteTableAssociation.setter(Builder::routeTableAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableAssociationId").unmarshallLocationName("routeTableAssociationId").build()}).build();
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RouteTableAssociation.getter(RouteTableAssociation::routeTableId)).setter(RouteTableAssociation.setter(Builder::routeTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").unmarshallLocationName("routeTableId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RouteTableAssociation.getter(RouteTableAssociation::subnetId)).setter(RouteTableAssociation.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAIN_FIELD, ROUTE_TABLE_ASSOCIATION_ID_FIELD, ROUTE_TABLE_ID_FIELD, SUBNET_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean main;
    private final String routeTableAssociationId;
    private final String routeTableId;
    private final String subnetId;

    private RouteTableAssociation(BuilderImpl builder) {
        this.main = builder.main;
        this.routeTableAssociationId = builder.routeTableAssociationId;
        this.routeTableId = builder.routeTableId;
        this.subnetId = builder.subnetId;
    }

    public Boolean main() {
        return this.main;
    }

    public String routeTableAssociationId() {
        return this.routeTableAssociationId;
    }

    public String routeTableId() {
        return this.routeTableId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.main());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTableAssociation)) {
            return false;
        }
        RouteTableAssociation other = (RouteTableAssociation)obj;
        return Objects.equals(this.main(), other.main()) && Objects.equals(this.routeTableAssociationId(), other.routeTableAssociationId()) && Objects.equals(this.routeTableId(), other.routeTableId()) && Objects.equals(this.subnetId(), other.subnetId());
    }

    public String toString() {
        return ToString.builder((String)"RouteTableAssociation").add("Main", (Object)this.main()).add("RouteTableAssociationId", (Object)this.routeTableAssociationId()).add("RouteTableId", (Object)this.routeTableId()).add("SubnetId", (Object)this.subnetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Main": {
                return Optional.ofNullable(clazz.cast(this.main()));
            }
            case "RouteTableAssociationId": {
                return Optional.ofNullable(clazz.cast(this.routeTableAssociationId()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteTableAssociation, T> g) {
        return obj -> g.apply((RouteTableAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean main;
        private String routeTableAssociationId;
        private String routeTableId;
        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTableAssociation model) {
            this.main(model.main);
            this.routeTableAssociationId(model.routeTableAssociationId);
            this.routeTableId(model.routeTableId);
            this.subnetId(model.subnetId);
        }

        public final Boolean getMain() {
            return this.main;
        }

        @Override
        public final Builder main(Boolean main) {
            this.main = main;
            return this;
        }

        public final void setMain(Boolean main) {
            this.main = main;
        }

        public final String getRouteTableAssociationId() {
            return this.routeTableAssociationId;
        }

        @Override
        public final Builder routeTableAssociationId(String routeTableAssociationId) {
            this.routeTableAssociationId = routeTableAssociationId;
            return this;
        }

        public final void setRouteTableAssociationId(String routeTableAssociationId) {
            this.routeTableAssociationId = routeTableAssociationId;
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public RouteTableAssociation build() {
            return new RouteTableAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteTableAssociation> {
        public Builder main(Boolean var1);

        public Builder routeTableAssociationId(String var1);

        public Builder routeTableId(String var1);

        public Builder subnetId(String var1);
    }
}

