/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressConfigSetCopier;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesIpv6Address;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesIpv6AddressListCopier;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesSecurityGroupIdSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledInstancesNetworkInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledInstancesNetworkInterface> {
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ScheduledInstancesNetworkInterface.getter(ScheduledInstancesNetworkInterface::associatePublicIpAddress)).setter(ScheduledInstancesNetworkInterface.setter(Builder::associatePublicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").unmarshallLocationName("AssociatePublicIpAddress").build()}).build();
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ScheduledInstancesNetworkInterface.getter(ScheduledInstancesNetworkInterface::deleteOnTermination)).setter(ScheduledInstancesNetworkInterface.setter(Builder::deleteOnTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").unmarshallLocationName("DeleteOnTermination").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScheduledInstancesNetworkInterface.getter(ScheduledInstancesNetworkInterface::description)).setter(ScheduledInstancesNetworkInterface.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ScheduledInstancesNetworkInterface.getter(ScheduledInstancesNetworkInterface::deviceIndex)).setter(ScheduledInstancesNetworkInterface.setter(Builder::deviceIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex").unmarshallLocationName("DeviceIndex").build()}).build();
    private static final SdkField<List<String>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ScheduledInstancesNetworkInterface.getter(ScheduledInstancesNetworkInterface::groups)).setter(ScheduledInstancesNetworkInterface.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").unmarshallLocationName("Group").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ScheduledInstancesNetworkInterface.getter(ScheduledInstancesNetworkInterface::ipv6AddressCount)).setter(ScheduledInstancesNetworkInterface.setter(Builder::ipv6AddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount").unmarshallLocationName("Ipv6AddressCount").build()}).build();
    private static final SdkField<List<ScheduledInstancesIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ScheduledInstancesNetworkInterface.getter(ScheduledInstancesNetworkInterface::ipv6Addresses)).setter(ScheduledInstancesNetworkInterface.setter(Builder::ipv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Address").unmarshallLocationName("Ipv6Address").build(), ListTrait.builder().memberLocationName("Ipv6Address").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledInstancesIpv6Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Address").unmarshallLocationName("Ipv6Address").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScheduledInstancesNetworkInterface.getter(ScheduledInstancesNetworkInterface::networkInterfaceId)).setter(ScheduledInstancesNetworkInterface.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("NetworkInterfaceId").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScheduledInstancesNetworkInterface.getter(ScheduledInstancesNetworkInterface::privateIpAddress)).setter(ScheduledInstancesNetworkInterface.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("PrivateIpAddress").build()}).build();
    private static final SdkField<List<ScheduledInstancesPrivateIpAddressConfig>> PRIVATE_IP_ADDRESS_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ScheduledInstancesNetworkInterface.getter(ScheduledInstancesNetworkInterface::privateIpAddressConfigs)).setter(ScheduledInstancesNetworkInterface.setter(Builder::privateIpAddressConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddressConfig").unmarshallLocationName("PrivateIpAddressConfig").build(), ListTrait.builder().memberLocationName("PrivateIpAddressConfigSet").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledInstancesPrivateIpAddressConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddressConfigSet").unmarshallLocationName("PrivateIpAddressConfigSet").build()}).build()).build()}).build();
    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ScheduledInstancesNetworkInterface.getter(ScheduledInstancesNetworkInterface::secondaryPrivateIpAddressCount)).setter(ScheduledInstancesNetworkInterface.setter(Builder::secondaryPrivateIpAddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount").unmarshallLocationName("SecondaryPrivateIpAddressCount").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScheduledInstancesNetworkInterface.getter(ScheduledInstancesNetworkInterface::subnetId)).setter(ScheduledInstancesNetworkInterface.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("SubnetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, DELETE_ON_TERMINATION_FIELD, DESCRIPTION_FIELD, DEVICE_INDEX_FIELD, GROUPS_FIELD, IPV6_ADDRESS_COUNT_FIELD, IPV6_ADDRESSES_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESS_CONFIGS_FIELD, SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD, SUBNET_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean associatePublicIpAddress;
    private final Boolean deleteOnTermination;
    private final String description;
    private final Integer deviceIndex;
    private final List<String> groups;
    private final Integer ipv6AddressCount;
    private final List<ScheduledInstancesIpv6Address> ipv6Addresses;
    private final String networkInterfaceId;
    private final String privateIpAddress;
    private final List<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs;
    private final Integer secondaryPrivateIpAddressCount;
    private final String subnetId;

    private ScheduledInstancesNetworkInterface(BuilderImpl builder) {
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.description = builder.description;
        this.deviceIndex = builder.deviceIndex;
        this.groups = builder.groups;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddressConfigs = builder.privateIpAddressConfigs;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.subnetId = builder.subnetId;
    }

    public Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public String description() {
        return this.description;
    }

    public Integer deviceIndex() {
        return this.deviceIndex;
    }

    public List<String> groups() {
        return this.groups;
    }

    public Integer ipv6AddressCount() {
        return this.ipv6AddressCount;
    }

    public List<ScheduledInstancesIpv6Address> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public List<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs() {
        return this.privateIpAddressConfigs;
    }

    public Integer secondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddressConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryPrivateIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesNetworkInterface)) {
            return false;
        }
        ScheduledInstancesNetworkInterface other = (ScheduledInstancesNetworkInterface)obj;
        return Objects.equals(this.associatePublicIpAddress(), other.associatePublicIpAddress()) && Objects.equals(this.deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deviceIndex(), other.deviceIndex()) && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.ipv6AddressCount(), other.ipv6AddressCount()) && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && Objects.equals(this.privateIpAddressConfigs(), other.privateIpAddressConfigs()) && Objects.equals(this.secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount()) && Objects.equals(this.subnetId(), other.subnetId());
    }

    public String toString() {
        return ToString.builder((String)"ScheduledInstancesNetworkInterface").add("AssociatePublicIpAddress", (Object)this.associatePublicIpAddress()).add("DeleteOnTermination", (Object)this.deleteOnTermination()).add("Description", (Object)this.description()).add("DeviceIndex", (Object)this.deviceIndex()).add("Groups", this.groups()).add("Ipv6AddressCount", (Object)this.ipv6AddressCount()).add("Ipv6Addresses", this.ipv6Addresses()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("PrivateIpAddressConfigs", this.privateIpAddressConfigs()).add("SecondaryPrivateIpAddressCount", (Object)this.secondaryPrivateIpAddressCount()).add("SubnetId", (Object)this.subnetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociatePublicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.associatePublicIpAddress()));
            }
            case "DeleteOnTermination": {
                return Optional.ofNullable(clazz.cast(this.deleteOnTermination()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeviceIndex": {
                return Optional.ofNullable(clazz.cast(this.deviceIndex()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Ipv6AddressCount": {
                return Optional.ofNullable(clazz.cast(this.ipv6AddressCount()));
            }
            case "Ipv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv6Addresses()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "PrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "PrivateIpAddressConfigs": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddressConfigs()));
            }
            case "SecondaryPrivateIpAddressCount": {
                return Optional.ofNullable(clazz.cast(this.secondaryPrivateIpAddressCount()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledInstancesNetworkInterface, T> g) {
        return obj -> g.apply((ScheduledInstancesNetworkInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean associatePublicIpAddress;
        private Boolean deleteOnTermination;
        private String description;
        private Integer deviceIndex;
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private Integer ipv6AddressCount;
        private List<ScheduledInstancesIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private String networkInterfaceId;
        private String privateIpAddress;
        private List<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs = DefaultSdkAutoConstructList.getInstance();
        private Integer secondaryPrivateIpAddressCount;
        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstancesNetworkInterface model) {
            this.associatePublicIpAddress(model.associatePublicIpAddress);
            this.deleteOnTermination(model.deleteOnTermination);
            this.description(model.description);
            this.deviceIndex(model.deviceIndex);
            this.groups(model.groups);
            this.ipv6AddressCount(model.ipv6AddressCount);
            this.ipv6Addresses(model.ipv6Addresses);
            this.networkInterfaceId(model.networkInterfaceId);
            this.privateIpAddress(model.privateIpAddress);
            this.privateIpAddressConfigs(model.privateIpAddressConfigs);
            this.secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            this.subnetId(model.subnetId);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getDeviceIndex() {
            return this.deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        public final Collection<String> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = ScheduledInstancesSecurityGroupIdSetCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = ScheduledInstancesSecurityGroupIdSetCopier.copy(groups);
        }

        public final Integer getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        public final Collection<ScheduledInstancesIpv6Address.Builder> getIpv6Addresses() {
            return this.ipv6Addresses != null ? (Collection)this.ipv6Addresses.stream().map(ScheduledInstancesIpv6Address::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Addresses(Collection<ScheduledInstancesIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = ScheduledInstancesIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(ScheduledInstancesIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<ScheduledInstancesIpv6Address.Builder> ... ipv6Addresses) {
            this.ipv6Addresses(Stream.of(ipv6Addresses).map(c -> (ScheduledInstancesIpv6Address)((ScheduledInstancesIpv6Address.Builder)ScheduledInstancesIpv6Address.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6Addresses(Collection<ScheduledInstancesIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = ScheduledInstancesIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<ScheduledInstancesPrivateIpAddressConfig.Builder> getPrivateIpAddressConfigs() {
            return this.privateIpAddressConfigs != null ? (Collection)this.privateIpAddressConfigs.stream().map(ScheduledInstancesPrivateIpAddressConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder privateIpAddressConfigs(Collection<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs) {
            this.privateIpAddressConfigs = PrivateIpAddressConfigSetCopier.copy(privateIpAddressConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddressConfigs(ScheduledInstancesPrivateIpAddressConfig ... privateIpAddressConfigs) {
            this.privateIpAddressConfigs(Arrays.asList(privateIpAddressConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddressConfigs(Consumer<ScheduledInstancesPrivateIpAddressConfig.Builder> ... privateIpAddressConfigs) {
            this.privateIpAddressConfigs(Stream.of(privateIpAddressConfigs).map(c -> (ScheduledInstancesPrivateIpAddressConfig)((ScheduledInstancesPrivateIpAddressConfig.Builder)ScheduledInstancesPrivateIpAddressConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrivateIpAddressConfigs(Collection<ScheduledInstancesPrivateIpAddressConfig.BuilderImpl> privateIpAddressConfigs) {
            this.privateIpAddressConfigs = PrivateIpAddressConfigSetCopier.copyFromBuilder(privateIpAddressConfigs);
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return this.secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public ScheduledInstancesNetworkInterface build() {
            return new ScheduledInstancesNetworkInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledInstancesNetworkInterface> {
        public Builder associatePublicIpAddress(Boolean var1);

        public Builder deleteOnTermination(Boolean var1);

        public Builder description(String var1);

        public Builder deviceIndex(Integer var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder ipv6AddressCount(Integer var1);

        public Builder ipv6Addresses(Collection<ScheduledInstancesIpv6Address> var1);

        public Builder ipv6Addresses(ScheduledInstancesIpv6Address ... var1);

        public Builder ipv6Addresses(Consumer<ScheduledInstancesIpv6Address.Builder> ... var1);

        public Builder networkInterfaceId(String var1);

        public Builder privateIpAddress(String var1);

        public Builder privateIpAddressConfigs(Collection<ScheduledInstancesPrivateIpAddressConfig> var1);

        public Builder privateIpAddressConfigs(ScheduledInstancesPrivateIpAddressConfig ... var1);

        public Builder privateIpAddressConfigs(Consumer<ScheduledInstancesPrivateIpAddressConfig.Builder> ... var1);

        public Builder secondaryPrivateIpAddressCount(Integer var1);

        public Builder subnetId(String var1);
    }
}

