/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionedBandwidth
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisionedBandwidth> {
    private static final SdkField<Instant> PROVISION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ProvisionedBandwidth.getter(ProvisionedBandwidth::provisionTime)).setter(ProvisionedBandwidth.setter(Builder::provisionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionTime").unmarshallLocationName("provisionTime").build()}).build();
    private static final SdkField<String> PROVISIONED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProvisionedBandwidth.getter(ProvisionedBandwidth::provisioned)).setter(ProvisionedBandwidth.setter(Builder::provisioned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provisioned").unmarshallLocationName("provisioned").build()}).build();
    private static final SdkField<Instant> REQUEST_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ProvisionedBandwidth.getter(ProvisionedBandwidth::requestTime)).setter(ProvisionedBandwidth.setter(Builder::requestTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTime").unmarshallLocationName("requestTime").build()}).build();
    private static final SdkField<String> REQUESTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProvisionedBandwidth.getter(ProvisionedBandwidth::requested)).setter(ProvisionedBandwidth.setter(Builder::requested)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Requested").unmarshallLocationName("requested").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProvisionedBandwidth.getter(ProvisionedBandwidth::status)).setter(ProvisionedBandwidth.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISION_TIME_FIELD, PROVISIONED_FIELD, REQUEST_TIME_FIELD, REQUESTED_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant provisionTime;
    private final String provisioned;
    private final Instant requestTime;
    private final String requested;
    private final String status;

    private ProvisionedBandwidth(BuilderImpl builder) {
        this.provisionTime = builder.provisionTime;
        this.provisioned = builder.provisioned;
        this.requestTime = builder.requestTime;
        this.requested = builder.requested;
        this.status = builder.status;
    }

    public Instant provisionTime() {
        return this.provisionTime;
    }

    public String provisioned() {
        return this.provisioned;
    }

    public Instant requestTime() {
        return this.requestTime;
    }

    public String requested() {
        return this.requested;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioned());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.requested());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedBandwidth)) {
            return false;
        }
        ProvisionedBandwidth other = (ProvisionedBandwidth)obj;
        return Objects.equals(this.provisionTime(), other.provisionTime()) && Objects.equals(this.provisioned(), other.provisioned()) && Objects.equals(this.requestTime(), other.requestTime()) && Objects.equals(this.requested(), other.requested()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"ProvisionedBandwidth").add("ProvisionTime", (Object)this.provisionTime()).add("Provisioned", (Object)this.provisioned()).add("RequestTime", (Object)this.requestTime()).add("Requested", (Object)this.requested()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionTime": {
                return Optional.ofNullable(clazz.cast(this.provisionTime()));
            }
            case "Provisioned": {
                return Optional.ofNullable(clazz.cast(this.provisioned()));
            }
            case "RequestTime": {
                return Optional.ofNullable(clazz.cast(this.requestTime()));
            }
            case "Requested": {
                return Optional.ofNullable(clazz.cast(this.requested()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedBandwidth, T> g) {
        return obj -> g.apply((ProvisionedBandwidth)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant provisionTime;
        private String provisioned;
        private Instant requestTime;
        private String requested;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedBandwidth model) {
            this.provisionTime(model.provisionTime);
            this.provisioned(model.provisioned);
            this.requestTime(model.requestTime);
            this.requested(model.requested);
            this.status(model.status);
        }

        public final Instant getProvisionTime() {
            return this.provisionTime;
        }

        @Override
        public final Builder provisionTime(Instant provisionTime) {
            this.provisionTime = provisionTime;
            return this;
        }

        public final void setProvisionTime(Instant provisionTime) {
            this.provisionTime = provisionTime;
        }

        public final String getProvisioned() {
            return this.provisioned;
        }

        @Override
        public final Builder provisioned(String provisioned) {
            this.provisioned = provisioned;
            return this;
        }

        public final void setProvisioned(String provisioned) {
            this.provisioned = provisioned;
        }

        public final Instant getRequestTime() {
            return this.requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        public final String getRequested() {
            return this.requested;
        }

        @Override
        public final Builder requested(String requested) {
            this.requested = requested;
            return this;
        }

        public final void setRequested(String requested) {
            this.requested = requested;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public ProvisionedBandwidth build() {
            return new ProvisionedBandwidth(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisionedBandwidth> {
        public Builder provisionTime(Instant var1);

        public Builder provisioned(String var1);

        public Builder requestTime(Instant var1);

        public Builder requested(String var1);

        public Builder status(String var1);
    }
}

