/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the recurring schedule for a Scheduled Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledInstanceRecurrence implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledInstanceRecurrence.Builder, ScheduledInstanceRecurrence> {
    private static final SdkField<String> FREQUENCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ScheduledInstanceRecurrence::frequency))
            .setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency")
                    .unmarshallLocationName("frequency").build()).build();

    private static final SdkField<Integer> INTERVAL_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ScheduledInstanceRecurrence::interval))
            .setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval")
                    .unmarshallLocationName("interval").build()).build();

    private static final SdkField<List<Integer>> OCCURRENCE_DAY_SET_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .getter(getter(ScheduledInstanceRecurrence::occurrenceDaySet))
            .setter(setter(Builder::occurrenceDaySet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurrenceDaySet")
                    .unmarshallLocationName("occurrenceDaySet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> OCCURRENCE_RELATIVE_TO_END_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ScheduledInstanceRecurrence::occurrenceRelativeToEnd))
            .setter(setter(Builder::occurrenceRelativeToEnd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurrenceRelativeToEnd")
                    .unmarshallLocationName("occurrenceRelativeToEnd").build()).build();

    private static final SdkField<String> OCCURRENCE_UNIT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ScheduledInstanceRecurrence::occurrenceUnit))
            .setter(setter(Builder::occurrenceUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurrenceUnit")
                    .unmarshallLocationName("occurrenceUnit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREQUENCY_FIELD,
            INTERVAL_FIELD, OCCURRENCE_DAY_SET_FIELD, OCCURRENCE_RELATIVE_TO_END_FIELD, OCCURRENCE_UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String frequency;

    private final Integer interval;

    private final List<Integer> occurrenceDaySet;

    private final Boolean occurrenceRelativeToEnd;

    private final String occurrenceUnit;

    private ScheduledInstanceRecurrence(BuilderImpl builder) {
        this.frequency = builder.frequency;
        this.interval = builder.interval;
        this.occurrenceDaySet = builder.occurrenceDaySet;
        this.occurrenceRelativeToEnd = builder.occurrenceRelativeToEnd;
        this.occurrenceUnit = builder.occurrenceUnit;
    }

    /**
     * <p>
     * The frequency (<code>Daily</code>, <code>Weekly</code>, or <code>Monthly</code>).
     * </p>
     * 
     * @return The frequency (<code>Daily</code>, <code>Weekly</code>, or <code>Monthly</code>).
     */
    public String frequency() {
        return frequency;
    }

    /**
     * <p>
     * The interval quantity. The interval unit depends on the value of <code>frequency</code>. For example, every 2
     * weeks or every 2 months.
     * </p>
     * 
     * @return The interval quantity. The interval unit depends on the value of <code>frequency</code>. For example,
     *         every 2 weeks or every 2 months.
     */
    public Integer interval() {
        return interval;
    }

    /**
     * <p>
     * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is
     * one or more days of the week (1-7, where 1 is Sunday).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule,
     *         this is one or more days of the week (1-7, where 1 is Sunday).
     */
    public List<Integer> occurrenceDaySet() {
        return occurrenceDaySet;
    }

    /**
     * <p>
     * Indicates whether the occurrence is relative to the end of the specified week or month.
     * </p>
     * 
     * @return Indicates whether the occurrence is relative to the end of the specified week or month.
     */
    public Boolean occurrenceRelativeToEnd() {
        return occurrenceRelativeToEnd;
    }

    /**
     * <p>
     * The unit for <code>occurrenceDaySet</code> (<code>DayOfWeek</code> or <code>DayOfMonth</code>).
     * </p>
     * 
     * @return The unit for <code>occurrenceDaySet</code> (<code>DayOfWeek</code> or <code>DayOfMonth</code>).
     */
    public String occurrenceUnit() {
        return occurrenceUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(frequency());
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(occurrenceDaySet());
        hashCode = 31 * hashCode + Objects.hashCode(occurrenceRelativeToEnd());
        hashCode = 31 * hashCode + Objects.hashCode(occurrenceUnit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstanceRecurrence)) {
            return false;
        }
        ScheduledInstanceRecurrence other = (ScheduledInstanceRecurrence) obj;
        return Objects.equals(frequency(), other.frequency()) && Objects.equals(interval(), other.interval())
                && Objects.equals(occurrenceDaySet(), other.occurrenceDaySet())
                && Objects.equals(occurrenceRelativeToEnd(), other.occurrenceRelativeToEnd())
                && Objects.equals(occurrenceUnit(), other.occurrenceUnit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ScheduledInstanceRecurrence").add("Frequency", frequency()).add("Interval", interval())
                .add("OccurrenceDaySet", occurrenceDaySet()).add("OccurrenceRelativeToEnd", occurrenceRelativeToEnd())
                .add("OccurrenceUnit", occurrenceUnit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Frequency":
            return Optional.ofNullable(clazz.cast(frequency()));
        case "Interval":
            return Optional.ofNullable(clazz.cast(interval()));
        case "OccurrenceDaySet":
            return Optional.ofNullable(clazz.cast(occurrenceDaySet()));
        case "OccurrenceRelativeToEnd":
            return Optional.ofNullable(clazz.cast(occurrenceRelativeToEnd()));
        case "OccurrenceUnit":
            return Optional.ofNullable(clazz.cast(occurrenceUnit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledInstanceRecurrence, T> g) {
        return obj -> g.apply((ScheduledInstanceRecurrence) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledInstanceRecurrence> {
        /**
         * <p>
         * The frequency (<code>Daily</code>, <code>Weekly</code>, or <code>Monthly</code>).
         * </p>
         * 
         * @param frequency
         *        The frequency (<code>Daily</code>, <code>Weekly</code>, or <code>Monthly</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * The interval quantity. The interval unit depends on the value of <code>frequency</code>. For example, every 2
         * weeks or every 2 months.
         * </p>
         * 
         * @param interval
         *        The interval quantity. The interval unit depends on the value of <code>frequency</code>. For example,
         *        every 2 weeks or every 2 months.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(Integer interval);

        /**
         * <p>
         * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this
         * is one or more days of the week (1-7, where 1 is Sunday).
         * </p>
         * 
         * @param occurrenceDaySet
         *        The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule,
         *        this is one or more days of the week (1-7, where 1 is Sunday).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occurrenceDaySet(Collection<Integer> occurrenceDaySet);

        /**
         * <p>
         * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this
         * is one or more days of the week (1-7, where 1 is Sunday).
         * </p>
         * 
         * @param occurrenceDaySet
         *        The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule,
         *        this is one or more days of the week (1-7, where 1 is Sunday).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occurrenceDaySet(Integer... occurrenceDaySet);

        /**
         * <p>
         * Indicates whether the occurrence is relative to the end of the specified week or month.
         * </p>
         * 
         * @param occurrenceRelativeToEnd
         *        Indicates whether the occurrence is relative to the end of the specified week or month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd);

        /**
         * <p>
         * The unit for <code>occurrenceDaySet</code> (<code>DayOfWeek</code> or <code>DayOfMonth</code>).
         * </p>
         * 
         * @param occurrenceUnit
         *        The unit for <code>occurrenceDaySet</code> (<code>DayOfWeek</code> or <code>DayOfMonth</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occurrenceUnit(String occurrenceUnit);
    }

    static final class BuilderImpl implements Builder {
        private String frequency;

        private Integer interval;

        private List<Integer> occurrenceDaySet = DefaultSdkAutoConstructList.getInstance();

        private Boolean occurrenceRelativeToEnd;

        private String occurrenceUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstanceRecurrence model) {
            frequency(model.frequency);
            interval(model.interval);
            occurrenceDaySet(model.occurrenceDaySet);
            occurrenceRelativeToEnd(model.occurrenceRelativeToEnd);
            occurrenceUnit(model.occurrenceUnit);
        }

        public final String getFrequency() {
            return frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final Integer getInterval() {
            return interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        public final Collection<Integer> getOccurrenceDaySet() {
            return occurrenceDaySet;
        }

        @Override
        public final Builder occurrenceDaySet(Collection<Integer> occurrenceDaySet) {
            this.occurrenceDaySet = OccurrenceDaySetCopier.copy(occurrenceDaySet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder occurrenceDaySet(Integer... occurrenceDaySet) {
            occurrenceDaySet(Arrays.asList(occurrenceDaySet));
            return this;
        }

        public final void setOccurrenceDaySet(Collection<Integer> occurrenceDaySet) {
            this.occurrenceDaySet = OccurrenceDaySetCopier.copy(occurrenceDaySet);
        }

        public final Boolean getOccurrenceRelativeToEnd() {
            return occurrenceRelativeToEnd;
        }

        @Override
        public final Builder occurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
            this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
            return this;
        }

        public final void setOccurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
            this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
        }

        public final String getOccurrenceUnit() {
            return occurrenceUnit;
        }

        @Override
        public final Builder occurrenceUnit(String occurrenceUnit) {
            this.occurrenceUnit = occurrenceUnit;
            return this;
        }

        public final void setOccurrenceUnit(String occurrenceUnit) {
            this.occurrenceUnit = occurrenceUnit;
        }

        @Override
        public ScheduledInstanceRecurrence build() {
            return new ScheduledInstanceRecurrence(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
