/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of RunScheduledInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunScheduledInstancesResponse extends Ec2Response implements
        ToCopyableBuilder<RunScheduledInstancesResponse.Builder, RunScheduledInstancesResponse> {
    private static final SdkField<List<String>> INSTANCE_ID_SET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RunScheduledInstancesResponse::instanceIdSet))
            .setter(setter(Builder::instanceIdSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIdSet")
                    .unmarshallLocationName("instanceIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_SET_FIELD));

    private final List<String> instanceIdSet;

    private RunScheduledInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceIdSet = builder.instanceIdSet;
    }

    /**
     * <p>
     * The IDs of the newly launched instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the newly launched instances.
     */
    public List<String> instanceIdSet() {
        return instanceIdSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceIdSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunScheduledInstancesResponse)) {
            return false;
        }
        RunScheduledInstancesResponse other = (RunScheduledInstancesResponse) obj;
        return Objects.equals(instanceIdSet(), other.instanceIdSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RunScheduledInstancesResponse").add("InstanceIdSet", instanceIdSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceIdSet":
            return Optional.ofNullable(clazz.cast(instanceIdSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunScheduledInstancesResponse, T> g) {
        return obj -> g.apply((RunScheduledInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, RunScheduledInstancesResponse> {
        /**
         * <p>
         * The IDs of the newly launched instances.
         * </p>
         * 
         * @param instanceIdSet
         *        The IDs of the newly launched instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIdSet(Collection<String> instanceIdSet);

        /**
         * <p>
         * The IDs of the newly launched instances.
         * </p>
         * 
         * @param instanceIdSet
         *        The IDs of the newly launched instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIdSet(String... instanceIdSet);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<String> instanceIdSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RunScheduledInstancesResponse model) {
            super(model);
            instanceIdSet(model.instanceIdSet);
        }

        public final Collection<String> getInstanceIdSet() {
            return instanceIdSet;
        }

        @Override
        public final Builder instanceIdSet(Collection<String> instanceIdSet) {
            this.instanceIdSet = InstanceIdSetCopier.copy(instanceIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIdSet(String... instanceIdSet) {
            instanceIdSet(Arrays.asList(instanceIdSet));
            return this;
        }

        public final void setInstanceIdSet(Collection<String> instanceIdSet) {
            this.instanceIdSet = InstanceIdSetCopier.copy(instanceIdSet);
        }

        @Override
        public RunScheduledInstancesResponse build() {
            return new RunScheduledInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
