/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpcEndpointServicePermissionsRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVpcEndpointServicePermissionsRequest.Builder, ModifyVpcEndpointServicePermissionsRequest> {
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyVpcEndpointServicePermissionsRequest::serviceId))
            .setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId")
                    .unmarshallLocationName("ServiceId").build()).build();

    private static final SdkField<List<String>> ADD_ALLOWED_PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyVpcEndpointServicePermissionsRequest::addAllowedPrincipals))
            .setter(setter(Builder::addAllowedPrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddAllowedPrincipals")
                    .unmarshallLocationName("AddAllowedPrincipals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_ALLOWED_PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyVpcEndpointServicePermissionsRequest::removeAllowedPrincipals))
            .setter(setter(Builder::removeAllowedPrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveAllowedPrincipals")
                    .unmarshallLocationName("RemoveAllowedPrincipals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ID_FIELD,
            ADD_ALLOWED_PRINCIPALS_FIELD, REMOVE_ALLOWED_PRINCIPALS_FIELD));

    private final String serviceId;

    private final List<String> addAllowedPrincipals;

    private final List<String> removeAllowedPrincipals;

    private ModifyVpcEndpointServicePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceId = builder.serviceId;
        this.addAllowedPrincipals = builder.addAllowedPrincipals;
        this.removeAllowedPrincipals = builder.removeAllowedPrincipals;
    }

    /**
     * <p>
     * The ID of the service.
     * </p>
     * 
     * @return The ID of the service.
     */
    public String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of one or more principals. Permissions are granted to the principals in this
     * list. To grant permissions to all principals, specify an asterisk (*).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of one or more principals. Permissions are granted to the principals in
     *         this list. To grant permissions to all principals, specify an asterisk (*).
     */
    public List<String> addAllowedPrincipals() {
        return addAllowedPrincipals;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of one or more principals. Permissions are revoked for principals in this list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of one or more principals. Permissions are revoked for principals in this
     *         list.
     */
    public List<String> removeAllowedPrincipals() {
        return removeAllowedPrincipals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(addAllowedPrincipals());
        hashCode = 31 * hashCode + Objects.hashCode(removeAllowedPrincipals());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointServicePermissionsRequest)) {
            return false;
        }
        ModifyVpcEndpointServicePermissionsRequest other = (ModifyVpcEndpointServicePermissionsRequest) obj;
        return Objects.equals(serviceId(), other.serviceId())
                && Objects.equals(addAllowedPrincipals(), other.addAllowedPrincipals())
                && Objects.equals(removeAllowedPrincipals(), other.removeAllowedPrincipals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyVpcEndpointServicePermissionsRequest").add("ServiceId", serviceId())
                .add("AddAllowedPrincipals", addAllowedPrincipals()).add("RemoveAllowedPrincipals", removeAllowedPrincipals())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "AddAllowedPrincipals":
            return Optional.ofNullable(clazz.cast(addAllowedPrincipals()));
        case "RemoveAllowedPrincipals":
            return Optional.ofNullable(clazz.cast(removeAllowedPrincipals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEndpointServicePermissionsRequest, T> g) {
        return obj -> g.apply((ModifyVpcEndpointServicePermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyVpcEndpointServicePermissionsRequest> {
        /**
         * <p>
         * The ID of the service.
         * </p>
         * 
         * @param serviceId
         *        The ID of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of one or more principals. Permissions are granted to the principals in this
         * list. To grant permissions to all principals, specify an asterisk (*).
         * </p>
         * 
         * @param addAllowedPrincipals
         *        The Amazon Resource Names (ARN) of one or more principals. Permissions are granted to the principals
         *        in this list. To grant permissions to all principals, specify an asterisk (*).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addAllowedPrincipals(Collection<String> addAllowedPrincipals);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of one or more principals. Permissions are granted to the principals in this
         * list. To grant permissions to all principals, specify an asterisk (*).
         * </p>
         * 
         * @param addAllowedPrincipals
         *        The Amazon Resource Names (ARN) of one or more principals. Permissions are granted to the principals
         *        in this list. To grant permissions to all principals, specify an asterisk (*).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addAllowedPrincipals(String... addAllowedPrincipals);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of one or more principals. Permissions are revoked for principals in this
         * list.
         * </p>
         * 
         * @param removeAllowedPrincipals
         *        The Amazon Resource Names (ARN) of one or more principals. Permissions are revoked for principals in
         *        this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAllowedPrincipals(Collection<String> removeAllowedPrincipals);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of one or more principals. Permissions are revoked for principals in this
         * list.
         * </p>
         * 
         * @param removeAllowedPrincipals
         *        The Amazon Resource Names (ARN) of one or more principals. Permissions are revoked for principals in
         *        this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAllowedPrincipals(String... removeAllowedPrincipals);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String serviceId;

        private List<String> addAllowedPrincipals = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeAllowedPrincipals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointServicePermissionsRequest model) {
            super(model);
            serviceId(model.serviceId);
            addAllowedPrincipals(model.addAllowedPrincipals);
            removeAllowedPrincipals(model.removeAllowedPrincipals);
        }

        public final String getServiceId() {
            return serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final Collection<String> getAddAllowedPrincipals() {
            return addAllowedPrincipals;
        }

        @Override
        public final Builder addAllowedPrincipals(Collection<String> addAllowedPrincipals) {
            this.addAllowedPrincipals = ValueStringListCopier.copy(addAllowedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllowedPrincipals(String... addAllowedPrincipals) {
            addAllowedPrincipals(Arrays.asList(addAllowedPrincipals));
            return this;
        }

        public final void setAddAllowedPrincipals(Collection<String> addAllowedPrincipals) {
            this.addAllowedPrincipals = ValueStringListCopier.copy(addAllowedPrincipals);
        }

        public final Collection<String> getRemoveAllowedPrincipals() {
            return removeAllowedPrincipals;
        }

        @Override
        public final Builder removeAllowedPrincipals(Collection<String> removeAllowedPrincipals) {
            this.removeAllowedPrincipals = ValueStringListCopier.copy(removeAllowedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAllowedPrincipals(String... removeAllowedPrincipals) {
            removeAllowedPrincipals(Arrays.asList(removeAllowedPrincipals));
            return this;
        }

        public final void setRemoveAllowedPrincipals(Collection<String> removeAllowedPrincipals) {
            this.removeAllowedPrincipals = ValueStringListCopier.copy(removeAllowedPrincipals);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEndpointServicePermissionsRequest build() {
            return new ModifyVpcEndpointServicePermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
