/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeReservedInstancesModifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedInstancesModificationsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeReservedInstancesModificationsRequest.Builder, DescribeReservedInstancesModificationsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeReservedInstancesModificationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> RESERVED_INSTANCES_MODIFICATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeReservedInstancesModificationsRequest::reservedInstancesModificationIds))
            .setter(setter(Builder::reservedInstancesModificationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesModificationId")
                    .unmarshallLocationName("ReservedInstancesModificationId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReservedInstancesModificationId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReservedInstancesModificationId")
                                                    .unmarshallLocationName("ReservedInstancesModificationId").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservedInstancesModificationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            RESERVED_INSTANCES_MODIFICATION_IDS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Filter> filters;

    private final List<String> reservedInstancesModificationIds;

    private final String nextToken;

    private DescribeReservedInstancesModificationsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.reservedInstancesModificationIds = builder.reservedInstancesModificationIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client-token</code> - The idempotency token for the modification request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>create-date</code> - The time when the modification request was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>effective-date</code> - The time when the modification becomes effective.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as part of the
     * modification request. This ID is only available when the status of the modification is <code>fulfilled</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for the new
     * Reserved Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>modification-result.target-configuration.instance-type</code> - The instance type of the new Reserved
     * Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>modification-result.target-configuration.platform</code> - The network platform of the new Reserved
     * Instances (<code>EC2-Classic</code> | <code>EC2-VPC</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reserved-instances-modification-id</code> - The ID of the modification request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status</code> - The status of the Reserved Instances modification request (<code>processing</code> |
     * <code>fulfilled</code> | <code>failed</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status-message</code> - The reason for the status.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>update-date</code> - The time when the modification request was last updated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>client-token</code> - The idempotency token for the modification request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>create-date</code> - The time when the modification request was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>effective-date</code> - The time when the modification becomes effective.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as
     *         part of the modification request. This ID is only available when the status of the modification is
     *         <code>fulfilled</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for the
     *         new Reserved Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved
     *         Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>modification-result.target-configuration.instance-type</code> - The instance type of the new
     *         Reserved Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>modification-result.target-configuration.platform</code> - The network platform of the new Reserved
     *         Instances (<code>EC2-Classic</code> | <code>EC2-VPC</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reserved-instances-modification-id</code> - The ID of the modification request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status</code> - The status of the Reserved Instances modification request (<code>processing</code>
     *         | <code>fulfilled</code> | <code>failed</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status-message</code> - The reason for the status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>update-date</code> - The time when the modification request was last updated.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * IDs for the submitted modification request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return IDs for the submitted modification request.
     */
    public List<String> reservedInstancesModificationIds() {
        return reservedInstancesModificationIds;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesModificationIds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesModificationsRequest)) {
            return false;
        }
        DescribeReservedInstancesModificationsRequest other = (DescribeReservedInstancesModificationsRequest) obj;
        return Objects.equals(filters(), other.filters())
                && Objects.equals(reservedInstancesModificationIds(), other.reservedInstancesModificationIds())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeReservedInstancesModificationsRequest").add("Filters", filters())
                .add("ReservedInstancesModificationIds", reservedInstancesModificationIds()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "ReservedInstancesModificationIds":
            return Optional.ofNullable(clazz.cast(reservedInstancesModificationIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedInstancesModificationsRequest, T> g) {
        return obj -> g.apply((DescribeReservedInstancesModificationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedInstancesModificationsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token for the modification request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>create-date</code> - The time when the modification request was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>effective-date</code> - The time when the modification becomes effective.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as part of
         * the modification request. This ID is only available when the status of the modification is
         * <code>fulfilled</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for the new
         * Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.instance-type</code> - The instance type of the new Reserved
         * Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.platform</code> - The network platform of the new Reserved
         * Instances (<code>EC2-Classic</code> | <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-modification-id</code> - The ID of the modification request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the Reserved Instances modification request (<code>processing</code> |
         * <code>fulfilled</code> | <code>failed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - The reason for the status.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update-date</code> - The time when the modification request was last updated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>client-token</code> - The idempotency token for the modification request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>create-date</code> - The time when the modification request was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>effective-date</code> - The time when the modification becomes effective.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as
         *        part of the modification request. This ID is only available when the status of the modification is
         *        <code>fulfilled</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for
         *        the new Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved
         *        Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.target-configuration.instance-type</code> - The instance type of the new
         *        Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.target-configuration.platform</code> - The network platform of the new
         *        Reserved Instances (<code>EC2-Classic</code> | <code>EC2-VPC</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-modification-id</code> - The ID of the modification request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the Reserved Instances modification request (
         *        <code>processing</code> | <code>fulfilled</code> | <code>failed</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-message</code> - The reason for the status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update-date</code> - The time when the modification request was last updated.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token for the modification request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>create-date</code> - The time when the modification request was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>effective-date</code> - The time when the modification becomes effective.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as part of
         * the modification request. This ID is only available when the status of the modification is
         * <code>fulfilled</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for the new
         * Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.instance-type</code> - The instance type of the new Reserved
         * Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.platform</code> - The network platform of the new Reserved
         * Instances (<code>EC2-Classic</code> | <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-modification-id</code> - The ID of the modification request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the Reserved Instances modification request (<code>processing</code> |
         * <code>fulfilled</code> | <code>failed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - The reason for the status.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update-date</code> - The time when the modification request was last updated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>client-token</code> - The idempotency token for the modification request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>create-date</code> - The time when the modification request was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>effective-date</code> - The time when the modification becomes effective.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as
         *        part of the modification request. This ID is only available when the status of the modification is
         *        <code>fulfilled</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for
         *        the new Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved
         *        Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.target-configuration.instance-type</code> - The instance type of the new
         *        Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.target-configuration.platform</code> - The network platform of the new
         *        Reserved Instances (<code>EC2-Classic</code> | <code>EC2-VPC</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-modification-id</code> - The ID of the modification request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the Reserved Instances modification request (
         *        <code>processing</code> | <code>fulfilled</code> | <code>failed</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-message</code> - The reason for the status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update-date</code> - The time when the modification request was last updated.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token for the modification request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>create-date</code> - The time when the modification request was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>effective-date</code> - The time when the modification becomes effective.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as part of
         * the modification request. This ID is only available when the status of the modification is
         * <code>fulfilled</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for the new
         * Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.instance-type</code> - The instance type of the new Reserved
         * Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.platform</code> - The network platform of the new Reserved
         * Instances (<code>EC2-Classic</code> | <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-modification-id</code> - The ID of the modification request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the Reserved Instances modification request (<code>processing</code> |
         * <code>fulfilled</code> | <code>failed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - The reason for the status.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update-date</code> - The time when the modification request was last updated.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * IDs for the submitted modification request.
         * </p>
         * 
         * @param reservedInstancesModificationIds
         *        IDs for the submitted modification request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesModificationIds(Collection<String> reservedInstancesModificationIds);

        /**
         * <p>
         * IDs for the submitted modification request.
         * </p>
         * 
         * @param reservedInstancesModificationIds
         *        IDs for the submitted modification request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesModificationIds(String... reservedInstancesModificationIds);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> reservedInstancesModificationIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesModificationsRequest model) {
            super(model);
            filters(model.filters);
            reservedInstancesModificationIds(model.reservedInstancesModificationIds);
            nextToken(model.nextToken);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getReservedInstancesModificationIds() {
            return reservedInstancesModificationIds;
        }

        @Override
        public final Builder reservedInstancesModificationIds(Collection<String> reservedInstancesModificationIds) {
            this.reservedInstancesModificationIds = ReservedInstancesModificationIdStringListCopier
                    .copy(reservedInstancesModificationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesModificationIds(String... reservedInstancesModificationIds) {
            reservedInstancesModificationIds(Arrays.asList(reservedInstancesModificationIds));
            return this;
        }

        public final void setReservedInstancesModificationIds(Collection<String> reservedInstancesModificationIds) {
            this.reservedInstancesModificationIds = ReservedInstancesModificationIdStringListCopier
                    .copy(reservedInstancesModificationIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedInstancesModificationsRequest build() {
            return new DescribeReservedInstancesModificationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
