/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRouteRequest extends Ec2Request implements
        ToCopyableBuilder<DeleteRouteRequest.Builder, DeleteRouteRequest> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteRouteRequest::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock")
                    .unmarshallLocationName("destinationCidrBlock").build()).build();

    private static final SdkField<String> DESTINATION_IPV6_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteRouteRequest::destinationIpv6CidrBlock))
            .setter(setter(Builder::destinationIpv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpv6CidrBlock")
                    .unmarshallLocationName("destinationIpv6CidrBlock").build()).build();

    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteRouteRequest::routeTableId))
            .setter(setter(Builder::routeTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId")
                    .unmarshallLocationName("routeTableId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD,
            DESTINATION_IPV6_CIDR_BLOCK_FIELD, ROUTE_TABLE_ID_FIELD));

    private final String destinationCidrBlock;

    private final String destinationIpv6CidrBlock;

    private final String routeTableId;

    private DeleteRouteRequest(BuilderImpl builder) {
        super(builder);
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
        this.routeTableId = builder.routeTableId;
    }

    /**
     * <p>
     * The IPv4 CIDR range for the route. The value you specify must match the CIDR for the route exactly.
     * </p>
     * 
     * @return The IPv4 CIDR range for the route. The value you specify must match the CIDR for the route exactly.
     */
    public String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The IPv6 CIDR range for the route. The value you specify must match the CIDR for the route exactly.
     * </p>
     * 
     * @return The IPv6 CIDR range for the route. The value you specify must match the CIDR for the route exactly.
     */
    public String destinationIpv6CidrBlock() {
        return destinationIpv6CidrBlock;
    }

    /**
     * <p>
     * The ID of the route table.
     * </p>
     * 
     * @return The ID of the route table.
     */
    public String routeTableId() {
        return routeTableId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(destinationIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRouteRequest)) {
            return false;
        }
        DeleteRouteRequest other = (DeleteRouteRequest) obj;
        return Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(destinationIpv6CidrBlock(), other.destinationIpv6CidrBlock())
                && Objects.equals(routeTableId(), other.routeTableId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteRouteRequest").add("DestinationCidrBlock", destinationCidrBlock())
                .add("DestinationIpv6CidrBlock", destinationIpv6CidrBlock()).add("RouteTableId", routeTableId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "DestinationIpv6CidrBlock":
            return Optional.ofNullable(clazz.cast(destinationIpv6CidrBlock()));
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRouteRequest, T> g) {
        return obj -> g.apply((DeleteRouteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteRouteRequest> {
        /**
         * <p>
         * The IPv4 CIDR range for the route. The value you specify must match the CIDR for the route exactly.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The IPv4 CIDR range for the route. The value you specify must match the CIDR for the route exactly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The IPv6 CIDR range for the route. The value you specify must match the CIDR for the route exactly.
         * </p>
         * 
         * @param destinationIpv6CidrBlock
         *        The IPv6 CIDR range for the route. The value you specify must match the CIDR for the route exactly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock);

        /**
         * <p>
         * The ID of the route table.
         * </p>
         * 
         * @param routeTableId
         *        The ID of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String destinationCidrBlock;

        private String destinationIpv6CidrBlock;

        private String routeTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRouteRequest model) {
            super(model);
            destinationCidrBlock(model.destinationCidrBlock);
            destinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
            routeTableId(model.routeTableId);
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getDestinationIpv6CidrBlock() {
            return destinationIpv6CidrBlock;
        }

        @Override
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRouteRequest build() {
            return new DeleteRouteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
