/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the authentication methods used by a Client VPN endpoint. Client VPN supports Active Directory and mutual
 * authentication. For more information, see <a href=
 * "https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication"
 * >Authentication</a> in the <i>AWS Client VPN Administrator Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientVpnAuthentication implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientVpnAuthentication.Builder, ClientVpnAuthentication> {
    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ClientVpnAuthentication::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final SdkField<DirectoryServiceAuthentication> ACTIVE_DIRECTORY_FIELD = SdkField
            .<DirectoryServiceAuthentication> builder(MarshallingType.SDK_POJO)
            .getter(getter(ClientVpnAuthentication::activeDirectory))
            .setter(setter(Builder::activeDirectory))
            .constructor(DirectoryServiceAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectory")
                    .unmarshallLocationName("activeDirectory").build()).build();

    private static final SdkField<CertificateAuthentication> MUTUAL_AUTHENTICATION_FIELD = SdkField
            .<CertificateAuthentication> builder(MarshallingType.SDK_POJO)
            .getter(getter(ClientVpnAuthentication::mutualAuthentication))
            .setter(setter(Builder::mutualAuthentication))
            .constructor(CertificateAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MutualAuthentication")
                    .unmarshallLocationName("mutualAuthentication").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            ACTIVE_DIRECTORY_FIELD, MUTUAL_AUTHENTICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final DirectoryServiceAuthentication activeDirectory;

    private final CertificateAuthentication mutualAuthentication;

    private ClientVpnAuthentication(BuilderImpl builder) {
        this.type = builder.type;
        this.activeDirectory = builder.activeDirectory;
        this.mutualAuthentication = builder.mutualAuthentication;
    }

    /**
     * <p>
     * The authentication type used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ClientVpnAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The authentication type used.
     * @see ClientVpnAuthenticationType
     */
    public ClientVpnAuthenticationType type() {
        return ClientVpnAuthenticationType.fromValue(type);
    }

    /**
     * <p>
     * The authentication type used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ClientVpnAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The authentication type used.
     * @see ClientVpnAuthenticationType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Information about the Active Directory, if applicable.
     * </p>
     * 
     * @return Information about the Active Directory, if applicable.
     */
    public DirectoryServiceAuthentication activeDirectory() {
        return activeDirectory;
    }

    /**
     * <p>
     * Information about the authentication certificates, if applicable.
     * </p>
     * 
     * @return Information about the authentication certificates, if applicable.
     */
    public CertificateAuthentication mutualAuthentication() {
        return mutualAuthentication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(mutualAuthentication());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientVpnAuthentication)) {
            return false;
        }
        ClientVpnAuthentication other = (ClientVpnAuthentication) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(activeDirectory(), other.activeDirectory())
                && Objects.equals(mutualAuthentication(), other.mutualAuthentication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClientVpnAuthentication").add("Type", typeAsString()).add("ActiveDirectory", activeDirectory())
                .add("MutualAuthentication", mutualAuthentication()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ActiveDirectory":
            return Optional.ofNullable(clazz.cast(activeDirectory()));
        case "MutualAuthentication":
            return Optional.ofNullable(clazz.cast(mutualAuthentication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientVpnAuthentication, T> g) {
        return obj -> g.apply((ClientVpnAuthentication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientVpnAuthentication> {
        /**
         * <p>
         * The authentication type used.
         * </p>
         * 
         * @param type
         *        The authentication type used.
         * @see ClientVpnAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientVpnAuthenticationType
         */
        Builder type(String type);

        /**
         * <p>
         * The authentication type used.
         * </p>
         * 
         * @param type
         *        The authentication type used.
         * @see ClientVpnAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientVpnAuthenticationType
         */
        Builder type(ClientVpnAuthenticationType type);

        /**
         * <p>
         * Information about the Active Directory, if applicable.
         * </p>
         * 
         * @param activeDirectory
         *        Information about the Active Directory, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectory(DirectoryServiceAuthentication activeDirectory);

        /**
         * <p>
         * Information about the Active Directory, if applicable.
         * </p>
         * This is a convenience that creates an instance of the {@link DirectoryServiceAuthentication.Builder} avoiding
         * the need to create one manually via {@link DirectoryServiceAuthentication#builder()}.
         *
         * When the {@link Consumer} completes, {@link DirectoryServiceAuthentication.Builder#build()} is called
         * immediately and its result is passed to {@link #activeDirectory(DirectoryServiceAuthentication)}.
         * 
         * @param activeDirectory
         *        a consumer that will call methods on {@link DirectoryServiceAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeDirectory(DirectoryServiceAuthentication)
         */
        default Builder activeDirectory(Consumer<DirectoryServiceAuthentication.Builder> activeDirectory) {
            return activeDirectory(DirectoryServiceAuthentication.builder().applyMutation(activeDirectory).build());
        }

        /**
         * <p>
         * Information about the authentication certificates, if applicable.
         * </p>
         * 
         * @param mutualAuthentication
         *        Information about the authentication certificates, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mutualAuthentication(CertificateAuthentication mutualAuthentication);

        /**
         * <p>
         * Information about the authentication certificates, if applicable.
         * </p>
         * This is a convenience that creates an instance of the {@link CertificateAuthentication.Builder} avoiding the
         * need to create one manually via {@link CertificateAuthentication#builder()}.
         *
         * When the {@link Consumer} completes, {@link CertificateAuthentication.Builder#build()} is called immediately
         * and its result is passed to {@link #mutualAuthentication(CertificateAuthentication)}.
         * 
         * @param mutualAuthentication
         *        a consumer that will call methods on {@link CertificateAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mutualAuthentication(CertificateAuthentication)
         */
        default Builder mutualAuthentication(Consumer<CertificateAuthentication.Builder> mutualAuthentication) {
            return mutualAuthentication(CertificateAuthentication.builder().applyMutation(mutualAuthentication).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private DirectoryServiceAuthentication activeDirectory;

        private CertificateAuthentication mutualAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientVpnAuthentication model) {
            type(model.type);
            activeDirectory(model.activeDirectory);
            mutualAuthentication(model.mutualAuthentication);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ClientVpnAuthenticationType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final DirectoryServiceAuthentication.Builder getActiveDirectory() {
            return activeDirectory != null ? activeDirectory.toBuilder() : null;
        }

        @Override
        public final Builder activeDirectory(DirectoryServiceAuthentication activeDirectory) {
            this.activeDirectory = activeDirectory;
            return this;
        }

        public final void setActiveDirectory(DirectoryServiceAuthentication.BuilderImpl activeDirectory) {
            this.activeDirectory = activeDirectory != null ? activeDirectory.build() : null;
        }

        public final CertificateAuthentication.Builder getMutualAuthentication() {
            return mutualAuthentication != null ? mutualAuthentication.toBuilder() : null;
        }

        @Override
        public final Builder mutualAuthentication(CertificateAuthentication mutualAuthentication) {
            this.mutualAuthentication = mutualAuthentication;
            return this;
        }

        public final void setMutualAuthentication(CertificateAuthentication.BuilderImpl mutualAuthentication) {
            this.mutualAuthentication = mutualAuthentication != null ? mutualAuthentication.build() : null;
        }

        @Override
        public ClientVpnAuthentication build() {
            return new ClientVpnAuthentication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
