/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes telemetry for a VPN tunnel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VgwTelemetry implements SdkPojo, Serializable, ToCopyableBuilder<VgwTelemetry.Builder, VgwTelemetry> {
    private static final SdkField<Integer> ACCEPTED_ROUTE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(VgwTelemetry::acceptedRouteCount))
            .setter(setter(Builder::acceptedRouteCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptedRouteCount")
                    .unmarshallLocationName("acceptedRouteCount").build()).build();

    private static final SdkField<Instant> LAST_STATUS_CHANGE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(VgwTelemetry::lastStatusChange))
            .setter(setter(Builder::lastStatusChange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStatusChange")
                    .unmarshallLocationName("lastStatusChange").build()).build();

    private static final SdkField<String> OUTSIDE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(VgwTelemetry::outsideIpAddress))
            .setter(setter(Builder::outsideIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutsideIpAddress")
                    .unmarshallLocationName("outsideIpAddress").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(VgwTelemetry::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(VgwTelemetry::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTED_ROUTE_COUNT_FIELD,
            LAST_STATUS_CHANGE_FIELD, OUTSIDE_IP_ADDRESS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer acceptedRouteCount;

    private final Instant lastStatusChange;

    private final String outsideIpAddress;

    private final String status;

    private final String statusMessage;

    private VgwTelemetry(BuilderImpl builder) {
        this.acceptedRouteCount = builder.acceptedRouteCount;
        this.lastStatusChange = builder.lastStatusChange;
        this.outsideIpAddress = builder.outsideIpAddress;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The number of accepted routes.
     * </p>
     * 
     * @return The number of accepted routes.
     */
    public Integer acceptedRouteCount() {
        return acceptedRouteCount;
    }

    /**
     * <p>
     * The date and time of the last change in status.
     * </p>
     * 
     * @return The date and time of the last change in status.
     */
    public Instant lastStatusChange() {
        return lastStatusChange;
    }

    /**
     * <p>
     * The Internet-routable IP address of the virtual private gateway's outside interface.
     * </p>
     * 
     * @return The Internet-routable IP address of the virtual private gateway's outside interface.
     */
    public String outsideIpAddress() {
        return outsideIpAddress;
    }

    /**
     * <p>
     * The status of the VPN tunnel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TelemetryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the VPN tunnel.
     * @see TelemetryStatus
     */
    public TelemetryStatus status() {
        return TelemetryStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the VPN tunnel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TelemetryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the VPN tunnel.
     * @see TelemetryStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If an error occurs, a description of the error.
     * </p>
     * 
     * @return If an error occurs, a description of the error.
     */
    public String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acceptedRouteCount());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusChange());
        hashCode = 31 * hashCode + Objects.hashCode(outsideIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VgwTelemetry)) {
            return false;
        }
        VgwTelemetry other = (VgwTelemetry) obj;
        return Objects.equals(acceptedRouteCount(), other.acceptedRouteCount())
                && Objects.equals(lastStatusChange(), other.lastStatusChange())
                && Objects.equals(outsideIpAddress(), other.outsideIpAddress())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VgwTelemetry").add("AcceptedRouteCount", acceptedRouteCount())
                .add("LastStatusChange", lastStatusChange()).add("OutsideIpAddress", outsideIpAddress())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptedRouteCount":
            return Optional.ofNullable(clazz.cast(acceptedRouteCount()));
        case "LastStatusChange":
            return Optional.ofNullable(clazz.cast(lastStatusChange()));
        case "OutsideIpAddress":
            return Optional.ofNullable(clazz.cast(outsideIpAddress()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VgwTelemetry, T> g) {
        return obj -> g.apply((VgwTelemetry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VgwTelemetry> {
        /**
         * <p>
         * The number of accepted routes.
         * </p>
         * 
         * @param acceptedRouteCount
         *        The number of accepted routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptedRouteCount(Integer acceptedRouteCount);

        /**
         * <p>
         * The date and time of the last change in status.
         * </p>
         * 
         * @param lastStatusChange
         *        The date and time of the last change in status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusChange(Instant lastStatusChange);

        /**
         * <p>
         * The Internet-routable IP address of the virtual private gateway's outside interface.
         * </p>
         * 
         * @param outsideIpAddress
         *        The Internet-routable IP address of the virtual private gateway's outside interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outsideIpAddress(String outsideIpAddress);

        /**
         * <p>
         * The status of the VPN tunnel.
         * </p>
         * 
         * @param status
         *        The status of the VPN tunnel.
         * @see TelemetryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TelemetryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the VPN tunnel.
         * </p>
         * 
         * @param status
         *        The status of the VPN tunnel.
         * @see TelemetryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TelemetryStatus
         */
        Builder status(TelemetryStatus status);

        /**
         * <p>
         * If an error occurs, a description of the error.
         * </p>
         * 
         * @param statusMessage
         *        If an error occurs, a description of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private Integer acceptedRouteCount;

        private Instant lastStatusChange;

        private String outsideIpAddress;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(VgwTelemetry model) {
            acceptedRouteCount(model.acceptedRouteCount);
            lastStatusChange(model.lastStatusChange);
            outsideIpAddress(model.outsideIpAddress);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final Integer getAcceptedRouteCount() {
            return acceptedRouteCount;
        }

        @Override
        public final Builder acceptedRouteCount(Integer acceptedRouteCount) {
            this.acceptedRouteCount = acceptedRouteCount;
            return this;
        }

        public final void setAcceptedRouteCount(Integer acceptedRouteCount) {
            this.acceptedRouteCount = acceptedRouteCount;
        }

        public final Instant getLastStatusChange() {
            return lastStatusChange;
        }

        @Override
        public final Builder lastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
            return this;
        }

        public final void setLastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
        }

        public final String getOutsideIpAddress() {
            return outsideIpAddress;
        }

        @Override
        public final Builder outsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
            return this;
        }

        public final void setOutsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TelemetryStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public VgwTelemetry build() {
            return new VgwTelemetry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
