/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the modification request/s.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedInstancesModificationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedInstancesModificationResult.Builder, ReservedInstancesModificationResult> {
    private static final SdkField<String> RESERVED_INSTANCES_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesModificationResult::reservedInstancesId))
            .setter(setter(Builder::reservedInstancesId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId")
                    .unmarshallLocationName("reservedInstancesId").build()).build();

    private static final SdkField<ReservedInstancesConfiguration> TARGET_CONFIGURATION_FIELD = SdkField
            .<ReservedInstancesConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(ReservedInstancesModificationResult::targetConfiguration))
            .setter(setter(Builder::targetConfiguration))
            .constructor(ReservedInstancesConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration")
                    .unmarshallLocationName("targetConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_INSTANCES_ID_FIELD,
            TARGET_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reservedInstancesId;

    private final ReservedInstancesConfiguration targetConfiguration;

    private ReservedInstancesModificationResult(BuilderImpl builder) {
        this.reservedInstancesId = builder.reservedInstancesId;
        this.targetConfiguration = builder.targetConfiguration;
    }

    /**
     * <p>
     * The ID for the Reserved Instances that were created as part of the modification request. This field is only
     * available when the modification is fulfilled.
     * </p>
     * 
     * @return The ID for the Reserved Instances that were created as part of the modification request. This field is
     *         only available when the modification is fulfilled.
     */
    public String reservedInstancesId() {
        return reservedInstancesId;
    }

    /**
     * <p>
     * The target Reserved Instances configurations supplied as part of the modification request.
     * </p>
     * 
     * @return The target Reserved Instances configurations supplied as part of the modification request.
     */
    public ReservedInstancesConfiguration targetConfiguration() {
        return targetConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesId());
        hashCode = 31 * hashCode + Objects.hashCode(targetConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesModificationResult)) {
            return false;
        }
        ReservedInstancesModificationResult other = (ReservedInstancesModificationResult) obj;
        return Objects.equals(reservedInstancesId(), other.reservedInstancesId())
                && Objects.equals(targetConfiguration(), other.targetConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReservedInstancesModificationResult").add("ReservedInstancesId", reservedInstancesId())
                .add("TargetConfiguration", targetConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstancesId":
            return Optional.ofNullable(clazz.cast(reservedInstancesId()));
        case "TargetConfiguration":
            return Optional.ofNullable(clazz.cast(targetConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstancesModificationResult, T> g) {
        return obj -> g.apply((ReservedInstancesModificationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedInstancesModificationResult> {
        /**
         * <p>
         * The ID for the Reserved Instances that were created as part of the modification request. This field is only
         * available when the modification is fulfilled.
         * </p>
         * 
         * @param reservedInstancesId
         *        The ID for the Reserved Instances that were created as part of the modification request. This field is
         *        only available when the modification is fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);

        /**
         * <p>
         * The target Reserved Instances configurations supplied as part of the modification request.
         * </p>
         * 
         * @param targetConfiguration
         *        The target Reserved Instances configurations supplied as part of the modification request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfiguration(ReservedInstancesConfiguration targetConfiguration);

        /**
         * <p>
         * The target Reserved Instances configurations supplied as part of the modification request.
         * </p>
         * This is a convenience that creates an instance of the {@link ReservedInstancesConfiguration.Builder} avoiding
         * the need to create one manually via {@link ReservedInstancesConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservedInstancesConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #targetConfiguration(ReservedInstancesConfiguration)}.
         * 
         * @param targetConfiguration
         *        a consumer that will call methods on {@link ReservedInstancesConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfiguration(ReservedInstancesConfiguration)
         */
        default Builder targetConfiguration(Consumer<ReservedInstancesConfiguration.Builder> targetConfiguration) {
            return targetConfiguration(ReservedInstancesConfiguration.builder().applyMutation(targetConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String reservedInstancesId;

        private ReservedInstancesConfiguration targetConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesModificationResult model) {
            reservedInstancesId(model.reservedInstancesId);
            targetConfiguration(model.targetConfiguration);
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final ReservedInstancesConfiguration.Builder getTargetConfiguration() {
            return targetConfiguration != null ? targetConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetConfiguration(ReservedInstancesConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final void setTargetConfiguration(ReservedInstancesConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public ReservedInstancesModificationResult build() {
            return new ReservedInstancesModificationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
