/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance modification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedInstancesModification implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedInstancesModification.Builder, ReservedInstancesModification> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesModification::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ReservedInstancesModification::createDate))
            .setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate")
                    .unmarshallLocationName("createDate").build()).build();

    private static final SdkField<Instant> EFFECTIVE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ReservedInstancesModification::effectiveDate))
            .setter(setter(Builder::effectiveDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveDate")
                    .unmarshallLocationName("effectiveDate").build()).build();

    private static final SdkField<List<ReservedInstancesModificationResult>> MODIFICATION_RESULTS_FIELD = SdkField
            .<List<ReservedInstancesModificationResult>> builder(MarshallingType.LIST)
            .getter(getter(ReservedInstancesModification::modificationResults))
            .setter(setter(Builder::modificationResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationResultSet")
                    .unmarshallLocationName("modificationResultSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ReservedInstancesModificationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedInstancesModificationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<ReservedInstancesId>> RESERVED_INSTANCES_IDS_FIELD = SdkField
            .<List<ReservedInstancesId>> builder(MarshallingType.LIST)
            .getter(getter(ReservedInstancesModification::reservedInstancesIds))
            .setter(setter(Builder::reservedInstancesIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesSet")
                    .unmarshallLocationName("reservedInstancesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ReservedInstancesId> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedInstancesId::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> RESERVED_INSTANCES_MODIFICATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesModification::reservedInstancesModificationId))
            .setter(setter(Builder::reservedInstancesModificationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesModificationId")
                    .unmarshallLocationName("reservedInstancesModificationId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesModification::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesModification::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ReservedInstancesModification::updateDate))
            .setter(setter(Builder::updateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDate")
                    .unmarshallLocationName("updateDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CREATE_DATE_FIELD, EFFECTIVE_DATE_FIELD, MODIFICATION_RESULTS_FIELD, RESERVED_INSTANCES_IDS_FIELD,
            RESERVED_INSTANCES_MODIFICATION_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, UPDATE_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientToken;

    private final Instant createDate;

    private final Instant effectiveDate;

    private final List<ReservedInstancesModificationResult> modificationResults;

    private final List<ReservedInstancesId> reservedInstancesIds;

    private final String reservedInstancesModificationId;

    private final String status;

    private final String statusMessage;

    private final Instant updateDate;

    private ReservedInstancesModification(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.createDate = builder.createDate;
        this.effectiveDate = builder.effectiveDate;
        this.modificationResults = builder.modificationResults;
        this.reservedInstancesIds = builder.reservedInstancesIds;
        this.reservedInstancesModificationId = builder.reservedInstancesModificationId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.updateDate = builder.updateDate;
    }

    /**
     * <p>
     * A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The time when the modification request was created.
     * </p>
     * 
     * @return The time when the modification request was created.
     */
    public Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The time for the modification to become effective.
     * </p>
     * 
     * @return The time for the modification to become effective.
     */
    public Instant effectiveDate() {
        return effectiveDate;
    }

    /**
     * <p>
     * Contains target configurations along with their corresponding new Reserved Instance IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Contains target configurations along with their corresponding new Reserved Instance IDs.
     */
    public List<ReservedInstancesModificationResult> modificationResults() {
        return modificationResults;
    }

    /**
     * <p>
     * The IDs of one or more Reserved Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of one or more Reserved Instances.
     */
    public List<ReservedInstancesId> reservedInstancesIds() {
        return reservedInstancesIds;
    }

    /**
     * <p>
     * A unique ID for the Reserved Instance modification.
     * </p>
     * 
     * @return A unique ID for the Reserved Instance modification.
     */
    public String reservedInstancesModificationId() {
        return reservedInstancesModificationId;
    }

    /**
     * <p>
     * The status of the Reserved Instances modification request.
     * </p>
     * 
     * @return The status of the Reserved Instances modification request.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The reason for the status.
     * </p>
     * 
     * @return The reason for the status.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The time when the modification request was last updated.
     * </p>
     * 
     * @return The time when the modification request was last updated.
     */
    public Instant updateDate() {
        return updateDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(modificationResults());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesIds());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesModificationId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(updateDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesModification)) {
            return false;
        }
        ReservedInstancesModification other = (ReservedInstancesModification) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(createDate(), other.createDate())
                && Objects.equals(effectiveDate(), other.effectiveDate())
                && Objects.equals(modificationResults(), other.modificationResults())
                && Objects.equals(reservedInstancesIds(), other.reservedInstancesIds())
                && Objects.equals(reservedInstancesModificationId(), other.reservedInstancesModificationId())
                && Objects.equals(status(), other.status()) && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(updateDate(), other.updateDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReservedInstancesModification").add("ClientToken", clientToken())
                .add("CreateDate", createDate()).add("EffectiveDate", effectiveDate())
                .add("ModificationResults", modificationResults()).add("ReservedInstancesIds", reservedInstancesIds())
                .add("ReservedInstancesModificationId", reservedInstancesModificationId()).add("Status", status())
                .add("StatusMessage", statusMessage()).add("UpdateDate", updateDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "EffectiveDate":
            return Optional.ofNullable(clazz.cast(effectiveDate()));
        case "ModificationResults":
            return Optional.ofNullable(clazz.cast(modificationResults()));
        case "ReservedInstancesIds":
            return Optional.ofNullable(clazz.cast(reservedInstancesIds()));
        case "ReservedInstancesModificationId":
            return Optional.ofNullable(clazz.cast(reservedInstancesModificationId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "UpdateDate":
            return Optional.ofNullable(clazz.cast(updateDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstancesModification, T> g) {
        return obj -> g.apply((ReservedInstancesModification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedInstancesModification> {
        /**
         * <p>
         * A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The time when the modification request was created.
         * </p>
         * 
         * @param createDate
         *        The time when the modification request was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The time for the modification to become effective.
         * </p>
         * 
         * @param effectiveDate
         *        The time for the modification to become effective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveDate(Instant effectiveDate);

        /**
         * <p>
         * Contains target configurations along with their corresponding new Reserved Instance IDs.
         * </p>
         * 
         * @param modificationResults
         *        Contains target configurations along with their corresponding new Reserved Instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modificationResults(Collection<ReservedInstancesModificationResult> modificationResults);

        /**
         * <p>
         * Contains target configurations along with their corresponding new Reserved Instance IDs.
         * </p>
         * 
         * @param modificationResults
         *        Contains target configurations along with their corresponding new Reserved Instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modificationResults(ReservedInstancesModificationResult... modificationResults);

        /**
         * <p>
         * Contains target configurations along with their corresponding new Reserved Instance IDs.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ReservedInstancesModificationResult>.Builder} avoiding the need to create one manually via {@link List
         * <ReservedInstancesModificationResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservedInstancesModificationResult>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #modificationResults(List<ReservedInstancesModificationResult>)}.
         * 
         * @param modificationResults
         *        a consumer that will call methods on {@link List<ReservedInstancesModificationResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modificationResults(List<ReservedInstancesModificationResult>)
         */
        Builder modificationResults(Consumer<ReservedInstancesModificationResult.Builder>... modificationResults);

        /**
         * <p>
         * The IDs of one or more Reserved Instances.
         * </p>
         * 
         * @param reservedInstancesIds
         *        The IDs of one or more Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesIds(Collection<ReservedInstancesId> reservedInstancesIds);

        /**
         * <p>
         * The IDs of one or more Reserved Instances.
         * </p>
         * 
         * @param reservedInstancesIds
         *        The IDs of one or more Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesIds(ReservedInstancesId... reservedInstancesIds);

        /**
         * <p>
         * The IDs of one or more Reserved Instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReservedInstancesId>.Builder} avoiding the
         * need to create one manually via {@link List<ReservedInstancesId>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservedInstancesId>.Builder#build()} is called immediately
         * and its result is passed to {@link #reservedInstancesIds(List<ReservedInstancesId>)}.
         * 
         * @param reservedInstancesIds
         *        a consumer that will call methods on {@link List<ReservedInstancesId>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedInstancesIds(List<ReservedInstancesId>)
         */
        Builder reservedInstancesIds(Consumer<ReservedInstancesId.Builder>... reservedInstancesIds);

        /**
         * <p>
         * A unique ID for the Reserved Instance modification.
         * </p>
         * 
         * @param reservedInstancesModificationId
         *        A unique ID for the Reserved Instance modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesModificationId(String reservedInstancesModificationId);

        /**
         * <p>
         * The status of the Reserved Instances modification request.
         * </p>
         * 
         * @param status
         *        The status of the Reserved Instances modification request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The reason for the status.
         * </p>
         * 
         * @param statusMessage
         *        The reason for the status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The time when the modification request was last updated.
         * </p>
         * 
         * @param updateDate
         *        The time when the modification request was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDate(Instant updateDate);
    }

    static final class BuilderImpl implements Builder {
        private String clientToken;

        private Instant createDate;

        private Instant effectiveDate;

        private List<ReservedInstancesModificationResult> modificationResults = DefaultSdkAutoConstructList.getInstance();

        private List<ReservedInstancesId> reservedInstancesIds = DefaultSdkAutoConstructList.getInstance();

        private String reservedInstancesModificationId;

        private String status;

        private String statusMessage;

        private Instant updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesModification model) {
            clientToken(model.clientToken);
            createDate(model.createDate);
            effectiveDate(model.effectiveDate);
            modificationResults(model.modificationResults);
            reservedInstancesIds(model.reservedInstancesIds);
            reservedInstancesModificationId(model.reservedInstancesModificationId);
            status(model.status);
            statusMessage(model.statusMessage);
            updateDate(model.updateDate);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Instant getEffectiveDate() {
            return effectiveDate;
        }

        @Override
        public final Builder effectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final void setEffectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        public final Collection<ReservedInstancesModificationResult.Builder> getModificationResults() {
            return modificationResults != null ? modificationResults.stream().map(ReservedInstancesModificationResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder modificationResults(Collection<ReservedInstancesModificationResult> modificationResults) {
            this.modificationResults = ReservedInstancesModificationResultListCopier.copy(modificationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modificationResults(ReservedInstancesModificationResult... modificationResults) {
            modificationResults(Arrays.asList(modificationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modificationResults(Consumer<ReservedInstancesModificationResult.Builder>... modificationResults) {
            modificationResults(Stream.of(modificationResults)
                    .map(c -> ReservedInstancesModificationResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setModificationResults(Collection<ReservedInstancesModificationResult.BuilderImpl> modificationResults) {
            this.modificationResults = ReservedInstancesModificationResultListCopier.copyFromBuilder(modificationResults);
        }

        public final Collection<ReservedInstancesId.Builder> getReservedInstancesIds() {
            return reservedInstancesIds != null ? reservedInstancesIds.stream().map(ReservedInstancesId::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstancesIds(Collection<ReservedInstancesId> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedIntancesIdsCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(ReservedInstancesId... reservedInstancesIds) {
            reservedInstancesIds(Arrays.asList(reservedInstancesIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(Consumer<ReservedInstancesId.Builder>... reservedInstancesIds) {
            reservedInstancesIds(Stream.of(reservedInstancesIds).map(c -> ReservedInstancesId.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReservedInstancesIds(Collection<ReservedInstancesId.BuilderImpl> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedIntancesIdsCopier.copyFromBuilder(reservedInstancesIds);
        }

        public final String getReservedInstancesModificationId() {
            return reservedInstancesModificationId;
        }

        @Override
        public final Builder reservedInstancesModificationId(String reservedInstancesModificationId) {
            this.reservedInstancesModificationId = reservedInstancesModificationId;
            return this;
        }

        public final void setReservedInstancesModificationId(String reservedInstancesModificationId) {
            this.reservedInstancesModificationId = reservedInstancesModificationId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Instant getUpdateDate() {
            return updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public ReservedInstancesModification build() {
            return new ReservedInstancesModification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
