/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a reservation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Reservation implements SdkPojo, Serializable, ToCopyableBuilder<Reservation.Builder, Reservation> {
    private static final SdkField<List<GroupIdentifier>> GROUPS_FIELD = SdkField
            .<List<GroupIdentifier>> builder(MarshallingType.LIST)
            .getter(getter(Reservation::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet")
                    .unmarshallLocationName("groupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<GroupIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Instance>> INSTANCES_FIELD = SdkField
            .<List<Instance>> builder(MarshallingType.LIST)
            .getter(getter(Reservation::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesSet")
                    .unmarshallLocationName("instancesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Instance> builder(MarshallingType.SDK_POJO)
                                            .constructor(Instance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Reservation::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> REQUESTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Reservation::requesterId))
            .setter(setter(Builder::requesterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterId")
                    .unmarshallLocationName("requesterId").build()).build();

    private static final SdkField<String> RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Reservation::reservationId))
            .setter(setter(Builder::reservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationId")
                    .unmarshallLocationName("reservationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPS_FIELD, INSTANCES_FIELD,
            OWNER_ID_FIELD, REQUESTER_ID_FIELD, RESERVATION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<GroupIdentifier> groups;

    private final List<Instance> instances;

    private final String ownerId;

    private final String requesterId;

    private final String reservationId;

    private Reservation(BuilderImpl builder) {
        this.groups = builder.groups;
        this.instances = builder.instances;
        this.ownerId = builder.ownerId;
        this.requesterId = builder.requesterId;
        this.reservationId = builder.reservationId;
    }

    /**
     * <p>
     * [EC2-Classic only] One or more security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [EC2-Classic only] One or more security groups.
     */
    public List<GroupIdentifier> groups() {
        return groups;
    }

    /**
     * <p>
     * One or more instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more instances.
     */
    public List<Instance> instances() {
        return instances;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the reservation.
     * </p>
     * 
     * @return The ID of the AWS account that owns the reservation.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The ID of the requester that launched the instances on your behalf (for example, AWS Management Console or Auto
     * Scaling).
     * </p>
     * 
     * @return The ID of the requester that launched the instances on your behalf (for example, AWS Management Console
     *         or Auto Scaling).
     */
    public String requesterId() {
        return requesterId;
    }

    /**
     * <p>
     * The ID of the reservation.
     * </p>
     * 
     * @return The ID of the reservation.
     */
    public String reservationId() {
        return reservationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groups());
        hashCode = 31 * hashCode + Objects.hashCode(instances());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(requesterId());
        hashCode = 31 * hashCode + Objects.hashCode(reservationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reservation)) {
            return false;
        }
        Reservation other = (Reservation) obj;
        return Objects.equals(groups(), other.groups()) && Objects.equals(instances(), other.instances())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(requesterId(), other.requesterId())
                && Objects.equals(reservationId(), other.reservationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Reservation").add("Groups", groups()).add("Instances", instances()).add("OwnerId", ownerId())
                .add("RequesterId", requesterId()).add("ReservationId", reservationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "RequesterId":
            return Optional.ofNullable(clazz.cast(requesterId()));
        case "ReservationId":
            return Optional.ofNullable(clazz.cast(reservationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Reservation, T> g) {
        return obj -> g.apply((Reservation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Reservation> {
        /**
         * <p>
         * [EC2-Classic only] One or more security groups.
         * </p>
         * 
         * @param groups
         *        [EC2-Classic only] One or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupIdentifier> groups);

        /**
         * <p>
         * [EC2-Classic only] One or more security groups.
         * </p>
         * 
         * @param groups
         *        [EC2-Classic only] One or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupIdentifier... groups);

        /**
         * <p>
         * [EC2-Classic only] One or more security groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GroupIdentifier>.Builder} avoiding the need
         * to create one manually via {@link List<GroupIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupIdentifier>.Builder#build()} is called immediately and
         * its result is passed to {@link #groups(List<GroupIdentifier>)}.
         * 
         * @param groups
         *        a consumer that will call methods on {@link List<GroupIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(List<GroupIdentifier>)
         */
        Builder groups(Consumer<GroupIdentifier.Builder>... groups);

        /**
         * <p>
         * One or more instances.
         * </p>
         * 
         * @param instances
         *        One or more instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<Instance> instances);

        /**
         * <p>
         * One or more instances.
         * </p>
         * 
         * @param instances
         *        One or more instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Instance... instances);

        /**
         * <p>
         * One or more instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Instance>.Builder} avoiding the need to
         * create one manually via {@link List<Instance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Instance>.Builder#build()} is called immediately and its
         * result is passed to {@link #instances(List<Instance>)}.
         * 
         * @param instances
         *        a consumer that will call methods on {@link List<Instance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(List<Instance>)
         */
        Builder instances(Consumer<Instance.Builder>... instances);

        /**
         * <p>
         * The ID of the AWS account that owns the reservation.
         * </p>
         * 
         * @param ownerId
         *        The ID of the AWS account that owns the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The ID of the requester that launched the instances on your behalf (for example, AWS Management Console or
         * Auto Scaling).
         * </p>
         * 
         * @param requesterId
         *        The ID of the requester that launched the instances on your behalf (for example, AWS Management
         *        Console or Auto Scaling).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterId(String requesterId);

        /**
         * <p>
         * The ID of the reservation.
         * </p>
         * 
         * @param reservationId
         *        The ID of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationId(String reservationId);
    }

    static final class BuilderImpl implements Builder {
        private List<GroupIdentifier> groups = DefaultSdkAutoConstructList.getInstance();

        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();

        private String ownerId;

        private String requesterId;

        private String reservationId;

        private BuilderImpl() {
        }

        private BuilderImpl(Reservation model) {
            groups(model.groups);
            instances(model.instances);
            ownerId(model.ownerId);
            requesterId(model.requesterId);
            reservationId(model.reservationId);
        }

        public final Collection<GroupIdentifier.Builder> getGroups() {
            return groups != null ? groups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupIdentifier.Builder>... groups) {
            groups(Stream.of(groups).map(c -> GroupIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        public final Collection<Instance.Builder> getInstances() {
            return instances != null ? instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder>... instances) {
            instances(Stream.of(instances).map(c -> Instance.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstanceListCopier.copyFromBuilder(instances);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getRequesterId() {
            return requesterId;
        }

        @Override
        public final Builder requesterId(String requesterId) {
            this.requesterId = requesterId;
            return this;
        }

        public final void setRequesterId(String requesterId) {
            this.requesterId = requesterId;
        }

        public final String getReservationId() {
            return reservationId;
        }

        @Override
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        @Override
        public Reservation build() {
            return new Reservation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
