/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * PrincipalIdFormat description
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrincipalIdFormat implements SdkPojo, Serializable,
        ToCopyableBuilder<PrincipalIdFormat.Builder, PrincipalIdFormat> {
    private static final SdkField<String> ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PrincipalIdFormat::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").unmarshallLocationName("arn")
                    .build()).build();

    private static final SdkField<List<IdFormat>> STATUSES_FIELD = SdkField
            .<List<IdFormat>> builder(MarshallingType.LIST)
            .getter(getter(PrincipalIdFormat::statuses))
            .setter(setter(Builder::statuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusSet")
                    .unmarshallLocationName("statusSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IdFormat> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdFormat::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUSES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<IdFormat> statuses;

    private PrincipalIdFormat(BuilderImpl builder) {
        this.arn = builder.arn;
        this.statuses = builder.statuses;
    }

    /**
     * <p>
     * PrincipalIdFormatARN description
     * </p>
     * 
     * @return PrincipalIdFormatARN description
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * PrincipalIdFormatStatuses description
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return PrincipalIdFormatStatuses description
     */
    public List<IdFormat> statuses() {
        return statuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statuses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalIdFormat)) {
            return false;
        }
        PrincipalIdFormat other = (PrincipalIdFormat) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(statuses(), other.statuses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PrincipalIdFormat").add("Arn", arn()).add("Statuses", statuses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Statuses":
            return Optional.ofNullable(clazz.cast(statuses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrincipalIdFormat, T> g) {
        return obj -> g.apply((PrincipalIdFormat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrincipalIdFormat> {
        /**
         * <p>
         * PrincipalIdFormatARN description
         * </p>
         * 
         * @param arn
         *        PrincipalIdFormatARN description
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * PrincipalIdFormatStatuses description
         * </p>
         * 
         * @param statuses
         *        PrincipalIdFormatStatuses description
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<IdFormat> statuses);

        /**
         * <p>
         * PrincipalIdFormatStatuses description
         * </p>
         * 
         * @param statuses
         *        PrincipalIdFormatStatuses description
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(IdFormat... statuses);

        /**
         * <p>
         * PrincipalIdFormatStatuses description
         * </p>
         * This is a convenience that creates an instance of the {@link List<IdFormat>.Builder} avoiding the need to
         * create one manually via {@link List<IdFormat>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IdFormat>.Builder#build()} is called immediately and its
         * result is passed to {@link #statuses(List<IdFormat>)}.
         * 
         * @param statuses
         *        a consumer that will call methods on {@link List<IdFormat>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statuses(List<IdFormat>)
         */
        Builder statuses(Consumer<IdFormat.Builder>... statuses);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<IdFormat> statuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PrincipalIdFormat model) {
            arn(model.arn);
            statuses(model.statuses);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<IdFormat.Builder> getStatuses() {
            return statuses != null ? statuses.stream().map(IdFormat::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statuses(Collection<IdFormat> statuses) {
            this.statuses = IdFormatListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(IdFormat... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(Consumer<IdFormat.Builder>... statuses) {
            statuses(Stream.of(statuses).map(c -> IdFormat.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatuses(Collection<IdFormat.BuilderImpl> statuses) {
            this.statuses = IdFormatListCopier.copyFromBuilder(statuses);
        }

        @Override
        public PrincipalIdFormat build() {
            return new PrincipalIdFormat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
