/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportKeyPairResponse extends Ec2Response implements
        ToCopyableBuilder<ImportKeyPairResponse.Builder, ImportKeyPairResponse> {
    private static final SdkField<String> KEY_FINGERPRINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ImportKeyPairResponse::keyFingerprint))
            .setter(setter(Builder::keyFingerprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyFingerprint")
                    .unmarshallLocationName("keyFingerprint").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ImportKeyPairResponse::keyName))
            .setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName")
                    .unmarshallLocationName("keyName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FINGERPRINT_FIELD,
            KEY_NAME_FIELD));

    private final String keyFingerprint;

    private final String keyName;

    private ImportKeyPairResponse(BuilderImpl builder) {
        super(builder);
        this.keyFingerprint = builder.keyFingerprint;
        this.keyName = builder.keyName;
    }

    /**
     * <p>
     * The MD5 public key fingerprint as specified in section 4 of RFC 4716.
     * </p>
     * 
     * @return The MD5 public key fingerprint as specified in section 4 of RFC 4716.
     */
    public String keyFingerprint() {
        return keyFingerprint;
    }

    /**
     * <p>
     * The key pair name you provided.
     * </p>
     * 
     * @return The key pair name you provided.
     */
    public String keyName() {
        return keyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyPairResponse)) {
            return false;
        }
        ImportKeyPairResponse other = (ImportKeyPairResponse) obj;
        return Objects.equals(keyFingerprint(), other.keyFingerprint()) && Objects.equals(keyName(), other.keyName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImportKeyPairResponse").add("KeyFingerprint", keyFingerprint()).add("KeyName", keyName())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyFingerprint":
            return Optional.ofNullable(clazz.cast(keyFingerprint()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportKeyPairResponse, T> g) {
        return obj -> g.apply((ImportKeyPairResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ImportKeyPairResponse> {
        /**
         * <p>
         * The MD5 public key fingerprint as specified in section 4 of RFC 4716.
         * </p>
         * 
         * @param keyFingerprint
         *        The MD5 public key fingerprint as specified in section 4 of RFC 4716.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyFingerprint(String keyFingerprint);

        /**
         * <p>
         * The key pair name you provided.
         * </p>
         * 
         * @param keyName
         *        The key pair name you provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String keyFingerprint;

        private String keyName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyPairResponse model) {
            super(model);
            keyFingerprint(model.keyFingerprint);
            keyName(model.keyName);
        }

        public final String getKeyFingerprint() {
            return keyFingerprint;
        }

        @Override
        public final Builder keyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            return this;
        }

        public final void setKeyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public ImportKeyPairResponse build() {
            return new ImportKeyPairResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
