/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpcEndpointConnectionsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeVpcEndpointConnectionsResponse.Builder, DescribeVpcEndpointConnectionsResponse> {
    private static final SdkField<List<VpcEndpointConnection>> VPC_ENDPOINT_CONNECTIONS_FIELD = SdkField
            .<List<VpcEndpointConnection>> builder(MarshallingType.LIST)
            .getter(getter(DescribeVpcEndpointConnectionsResponse::vpcEndpointConnections))
            .setter(setter(Builder::vpcEndpointConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointConnectionSet")
                    .unmarshallLocationName("vpcEndpointConnectionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VpcEndpointConnection> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcEndpointConnection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeVpcEndpointConnectionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VPC_ENDPOINT_CONNECTIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<VpcEndpointConnection> vpcEndpointConnections;

    private final String nextToken;

    private DescribeVpcEndpointConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointConnections = builder.vpcEndpointConnections;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about one or more VPC endpoint connections.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more VPC endpoint connections.
     */
    public List<VpcEndpointConnection> vpcEndpointConnections() {
        return vpcEndpointConnections;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointConnections());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointConnectionsResponse)) {
            return false;
        }
        DescribeVpcEndpointConnectionsResponse other = (DescribeVpcEndpointConnectionsResponse) obj;
        return Objects.equals(vpcEndpointConnections(), other.vpcEndpointConnections())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeVpcEndpointConnectionsResponse").add("VpcEndpointConnections", vpcEndpointConnections())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointConnections":
            return Optional.ofNullable(clazz.cast(vpcEndpointConnections()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcEndpointConnectionsResponse, T> g) {
        return obj -> g.apply((DescribeVpcEndpointConnectionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVpcEndpointConnectionsResponse> {
        /**
         * <p>
         * Information about one or more VPC endpoint connections.
         * </p>
         * 
         * @param vpcEndpointConnections
         *        Information about one or more VPC endpoint connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointConnections(Collection<VpcEndpointConnection> vpcEndpointConnections);

        /**
         * <p>
         * Information about one or more VPC endpoint connections.
         * </p>
         * 
         * @param vpcEndpointConnections
         *        Information about one or more VPC endpoint connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointConnections(VpcEndpointConnection... vpcEndpointConnections);

        /**
         * <p>
         * Information about one or more VPC endpoint connections.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VpcEndpointConnection>.Builder} avoiding
         * the need to create one manually via {@link List<VpcEndpointConnection>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcEndpointConnection>.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcEndpointConnections(List<VpcEndpointConnection>)}.
         * 
         * @param vpcEndpointConnections
         *        a consumer that will call methods on {@link List<VpcEndpointConnection>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpointConnections(List<VpcEndpointConnection>)
         */
        Builder vpcEndpointConnections(Consumer<VpcEndpointConnection.Builder>... vpcEndpointConnections);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<VpcEndpointConnection> vpcEndpointConnections = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointConnectionsResponse model) {
            super(model);
            vpcEndpointConnections(model.vpcEndpointConnections);
            nextToken(model.nextToken);
        }

        public final Collection<VpcEndpointConnection.Builder> getVpcEndpointConnections() {
            return vpcEndpointConnections != null ? vpcEndpointConnections.stream().map(VpcEndpointConnection::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcEndpointConnections(Collection<VpcEndpointConnection> vpcEndpointConnections) {
            this.vpcEndpointConnections = VpcEndpointConnectionSetCopier.copy(vpcEndpointConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointConnections(VpcEndpointConnection... vpcEndpointConnections) {
            vpcEndpointConnections(Arrays.asList(vpcEndpointConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointConnections(Consumer<VpcEndpointConnection.Builder>... vpcEndpointConnections) {
            vpcEndpointConnections(Stream.of(vpcEndpointConnections)
                    .map(c -> VpcEndpointConnection.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcEndpointConnections(Collection<VpcEndpointConnection.BuilderImpl> vpcEndpointConnections) {
            this.vpcEndpointConnections = VpcEndpointConnectionSetCopier.copyFromBuilder(vpcEndpointConnections);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVpcEndpointConnectionsResponse build() {
            return new DescribeVpcEndpointConnectionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
