/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeSpotFleetRequests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSpotFleetRequestsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeSpotFleetRequestsRequest.Builder, DescribeSpotFleetRequestsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeSpotFleetRequestsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSpotFleetRequestsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<String>> SPOT_FLEET_REQUEST_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSpotFleetRequestsRequest::spotFleetRequestIds))
            .setter(setter(Builder::spotFleetRequestIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId")
                    .unmarshallLocationName("spotFleetRequestId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, SPOT_FLEET_REQUEST_IDS_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> spotFleetRequestIds;

    private DescribeSpotFleetRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.spotFleetRequestIds = builder.spotFleetRequestIds;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value
     * is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default
     *         value is 1000. To retrieve the remaining results, make another call with the returned
     *         <code>NextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The IDs of the Spot Fleet requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the Spot Fleet requests.
     */
    public List<String> spotFleetRequestIds() {
        return spotFleetRequestIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetRequestsRequest)) {
            return false;
        }
        DescribeSpotFleetRequestsRequest other = (DescribeSpotFleetRequestsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(spotFleetRequestIds(), other.spotFleetRequestIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSpotFleetRequestsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("SpotFleetRequestIds", spotFleetRequestIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SpotFleetRequestIds":
            return Optional.ofNullable(clazz.cast(spotFleetRequestIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpotFleetRequestsRequest, T> g) {
        return obj -> g.apply((DescribeSpotFleetRequestsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSpotFleetRequestsRequest> {
        /**
         * <p>
         * The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default
         * value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code>
         * value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. Specify a value between 1 and 1000. The
         *        default value is 1000. To retrieve the remaining results, make another call with the returned
         *        <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The IDs of the Spot Fleet requests.
         * </p>
         * 
         * @param spotFleetRequestIds
         *        The IDs of the Spot Fleet requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestIds(Collection<String> spotFleetRequestIds);

        /**
         * <p>
         * The IDs of the Spot Fleet requests.
         * </p>
         * 
         * @param spotFleetRequestIds
         *        The IDs of the Spot Fleet requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestIds(String... spotFleetRequestIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private List<String> spotFleetRequestIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetRequestsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            spotFleetRequestIds(model.spotFleetRequestIds);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getSpotFleetRequestIds() {
            return spotFleetRequestIds;
        }

        @Override
        public final Builder spotFleetRequestIds(Collection<String> spotFleetRequestIds) {
            this.spotFleetRequestIds = ValueStringListCopier.copy(spotFleetRequestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotFleetRequestIds(String... spotFleetRequestIds) {
            spotFleetRequestIds(Arrays.asList(spotFleetRequestIds));
            return this;
        }

        public final void setSpotFleetRequestIds(Collection<String> spotFleetRequestIds) {
            this.spotFleetRequestIds = ValueStringListCopier.copy(spotFleetRequestIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSpotFleetRequestsRequest build() {
            return new DescribeSpotFleetRequestsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
