/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeScheduledInstanceAvailability.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScheduledInstanceAvailabilityResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeScheduledInstanceAvailabilityResponse.Builder, DescribeScheduledInstanceAvailabilityResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeScheduledInstanceAvailabilityResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<ScheduledInstanceAvailability>> SCHEDULED_INSTANCE_AVAILABILITY_SET_FIELD = SdkField
            .<List<ScheduledInstanceAvailability>> builder(MarshallingType.LIST)
            .getter(getter(DescribeScheduledInstanceAvailabilityResponse::scheduledInstanceAvailabilitySet))
            .setter(setter(Builder::scheduledInstanceAvailabilitySet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledInstanceAvailabilitySet")
                    .unmarshallLocationName("scheduledInstanceAvailabilitySet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ScheduledInstanceAvailability> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledInstanceAvailability::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SCHEDULED_INSTANCE_AVAILABILITY_SET_FIELD));

    private final String nextToken;

    private final List<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet;

    private DescribeScheduledInstanceAvailabilityResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.scheduledInstanceAvailabilitySet = builder.scheduledInstanceAvailabilitySet;
    }

    /**
     * <p>
     * The token required to retrieve the next set of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token required to retrieve the next set of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Information about the available Scheduled Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the available Scheduled Instances.
     */
    public List<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet() {
        return scheduledInstanceAvailabilitySet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledInstanceAvailabilitySet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstanceAvailabilityResponse)) {
            return false;
        }
        DescribeScheduledInstanceAvailabilityResponse other = (DescribeScheduledInstanceAvailabilityResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(scheduledInstanceAvailabilitySet(), other.scheduledInstanceAvailabilitySet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeScheduledInstanceAvailabilityResponse").add("NextToken", nextToken())
                .add("ScheduledInstanceAvailabilitySet", scheduledInstanceAvailabilitySet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ScheduledInstanceAvailabilitySet":
            return Optional.ofNullable(clazz.cast(scheduledInstanceAvailabilitySet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledInstanceAvailabilityResponse, T> g) {
        return obj -> g.apply((DescribeScheduledInstanceAvailabilityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityResponse> {
        /**
         * <p>
         * The token required to retrieve the next set of results. This value is <code>null</code> when there are no
         * more results to return.
         * </p>
         * 
         * @param nextToken
         *        The token required to retrieve the next set of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the available Scheduled Instances.
         * </p>
         * 
         * @param scheduledInstanceAvailabilitySet
         *        Information about the available Scheduled Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledInstanceAvailabilitySet(Collection<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet);

        /**
         * <p>
         * Information about the available Scheduled Instances.
         * </p>
         * 
         * @param scheduledInstanceAvailabilitySet
         *        Information about the available Scheduled Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledInstanceAvailabilitySet(ScheduledInstanceAvailability... scheduledInstanceAvailabilitySet);

        /**
         * <p>
         * Information about the available Scheduled Instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ScheduledInstanceAvailability>.Builder}
         * avoiding the need to create one manually via {@link List<ScheduledInstanceAvailability>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScheduledInstanceAvailability>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #scheduledInstanceAvailabilitySet(List<ScheduledInstanceAvailability>)}.
         * 
         * @param scheduledInstanceAvailabilitySet
         *        a consumer that will call methods on {@link List<ScheduledInstanceAvailability>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledInstanceAvailabilitySet(List<ScheduledInstanceAvailability>)
         */
        Builder scheduledInstanceAvailabilitySet(
                Consumer<ScheduledInstanceAvailability.Builder>... scheduledInstanceAvailabilitySet);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstanceAvailabilityResponse model) {
            super(model);
            nextToken(model.nextToken);
            scheduledInstanceAvailabilitySet(model.scheduledInstanceAvailabilitySet);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ScheduledInstanceAvailability.Builder> getScheduledInstanceAvailabilitySet() {
            return scheduledInstanceAvailabilitySet != null ? scheduledInstanceAvailabilitySet.stream()
                    .map(ScheduledInstanceAvailability::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledInstanceAvailabilitySet(
                Collection<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet) {
            this.scheduledInstanceAvailabilitySet = ScheduledInstanceAvailabilitySetCopier.copy(scheduledInstanceAvailabilitySet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceAvailabilitySet(ScheduledInstanceAvailability... scheduledInstanceAvailabilitySet) {
            scheduledInstanceAvailabilitySet(Arrays.asList(scheduledInstanceAvailabilitySet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceAvailabilitySet(
                Consumer<ScheduledInstanceAvailability.Builder>... scheduledInstanceAvailabilitySet) {
            scheduledInstanceAvailabilitySet(Stream.of(scheduledInstanceAvailabilitySet)
                    .map(c -> ScheduledInstanceAvailability.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScheduledInstanceAvailabilitySet(
                Collection<ScheduledInstanceAvailability.BuilderImpl> scheduledInstanceAvailabilitySet) {
            this.scheduledInstanceAvailabilitySet = ScheduledInstanceAvailabilitySetCopier
                    .copyFromBuilder(scheduledInstanceAvailabilitySet);
        }

        @Override
        public DescribeScheduledInstanceAvailabilityResponse build() {
            return new DescribeScheduledInstanceAvailabilityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
