/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRouteTablesRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeRouteTablesRequest.Builder, DescribeRouteTablesRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeRouteTablesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> ROUTE_TABLE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeRouteTablesRequest::routeTableIds))
            .setter(setter(Builder::routeTableIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId")
                    .unmarshallLocationName("RouteTableId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeRouteTablesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeRouteTablesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            ROUTE_TABLE_IDS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<Filter> filters;

    private final List<String> routeTableIds;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeRouteTablesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.routeTableIds = builder.routeTableIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>association.route-table-association-id</code> - The ID of an association ID for the route table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.route-table-id</code> - The ID of the route table involved in the association.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.subnet-id</code> - The ID of the subnet involved in the association.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.main</code> - Indicates whether the route table is the main route table for the VPC (
     * <code>true</code> | <code>false</code>). Route tables that do not have an association ID are not returned in the
     * response.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The ID of the AWS account that owns the route table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route-table-id</code> - The ID of the route table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a route in the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.destination-prefix-list-id</code> - The ID (prefix) of the AWS service specified in a route in the
     * table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.egress-only-internet-gateway-id</code> - The ID of an egress-only Internet gateway specified in a
     * route in the route table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.instance-id</code> - The ID of an instance specified in a route in the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.nat-gateway-id</code> - The ID of a NAT gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.transit-gateway-id</code> - The ID of a transit gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code> indicates that the
     * route was automatically created when the route table was created; <code>CreateRoute</code> indicates that the
     * route was manually added to the route table; <code>EnableVgwRoutePropagation</code> indicates that the route was
     * propagated by route propagation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.state</code> - The state of a route in the route table (<code>active</code> | <code>blackhole</code>
     * ). The blackhole state indicates that the route's target isn't available (for example, the specified gateway
     * isn't attached to the VPC, the specified NAT instance has been terminated, and so on).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route in the
     * table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway-id</code> - The ID of a transit gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC for the route table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>association.route-table-association-id</code> - The ID of an association ID for the route table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.route-table-id</code> - The ID of the route table involved in the association.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.subnet-id</code> - The ID of the subnet involved in the association.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.main</code> - Indicates whether the route table is the main route table for the VPC (
     *         <code>true</code> | <code>false</code>). Route tables that do not have an association ID are not returned
     *         in the response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The ID of the AWS account that owns the route table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route-table-id</code> - The ID of the route table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a route in the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route
     *         table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.destination-prefix-list-id</code> - The ID (prefix) of the AWS service specified in a route
     *         in the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.egress-only-internet-gateway-id</code> - The ID of an egress-only Internet gateway specified
     *         in a route in the route table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.instance-id</code> - The ID of an instance specified in a route in the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.nat-gateway-id</code> - The ID of a NAT gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.transit-gateway-id</code> - The ID of a transit gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code> indicates
     *         that the route was automatically created when the route table was created; <code>CreateRoute</code>
     *         indicates that the route was manually added to the route table; <code>EnableVgwRoutePropagation</code>
     *         indicates that the route was propagated by route propagation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.state</code> - The state of a route in the route table (<code>active</code> |
     *         <code>blackhole</code>). The blackhole state indicates that the route's target isn't available (for
     *         example, the specified gateway isn't attached to the VPC, the specified NAT instance has been terminated,
     *         and so on).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route in
     *         the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway-id</code> - The ID of a transit gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC for the route table.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more route table IDs.
     * </p>
     * <p>
     * Default: Describes all your route tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more route table IDs.</p>
     *         <p>
     *         Default: Describes all your route tables.
     */
    public List<String> routeTableIds() {
        return routeTableIds;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned <b>NextToken</b> value. This value can be between 5 and 100.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *         call with the returned <b>NextToken</b> value. This value can be between 5 and 100.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableIds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouteTablesRequest)) {
            return false;
        }
        DescribeRouteTablesRequest other = (DescribeRouteTablesRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(routeTableIds(), other.routeTableIds())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeRouteTablesRequest").add("Filters", filters()).add("RouteTableIds", routeTableIds())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "RouteTableIds":
            return Optional.ofNullable(clazz.cast(routeTableIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRouteTablesRequest, T> g) {
        return obj -> g.apply((DescribeRouteTablesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRouteTablesRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>association.route-table-association-id</code> - The ID of an association ID for the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.route-table-id</code> - The ID of the route table involved in the association.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.subnet-id</code> - The ID of the subnet involved in the association.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.main</code> - Indicates whether the route table is the main route table for the VPC (
         * <code>true</code> | <code>false</code>). Route tables that do not have an association ID are not returned in
         * the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The ID of the AWS account that owns the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route-table-id</code> - The ID of the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a route in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-prefix-list-id</code> - The ID (prefix) of the AWS service specified in a route in
         * the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.egress-only-internet-gateway-id</code> - The ID of an egress-only Internet gateway specified in a
         * route in the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.instance-id</code> - The ID of an instance specified in a route in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.nat-gateway-id</code> - The ID of a NAT gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.transit-gateway-id</code> - The ID of a transit gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code> indicates that
         * the route was automatically created when the route table was created; <code>CreateRoute</code> indicates that
         * the route was manually added to the route table; <code>EnableVgwRoutePropagation</code> indicates that the
         * route was propagated by route propagation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.state</code> - The state of a route in the route table (<code>active</code> |
         * <code>blackhole</code>). The blackhole state indicates that the route's target isn't available (for example,
         * the specified gateway isn't attached to the VPC, the specified NAT instance has been terminated, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route in the
         * table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-id</code> - The ID of a transit gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the route table.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>association.route-table-association-id</code> - The ID of an association ID for the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.route-table-id</code> - The ID of the route table involved in the association.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.subnet-id</code> - The ID of the subnet involved in the association.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.main</code> - Indicates whether the route table is the main route table for the VPC
         *        (<code>true</code> | <code>false</code>). Route tables that do not have an association ID are not
         *        returned in the response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The ID of the AWS account that owns the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route-table-id</code> - The ID of the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a route in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route
         *        table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-prefix-list-id</code> - The ID (prefix) of the AWS service specified in a
         *        route in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.egress-only-internet-gateway-id</code> - The ID of an egress-only Internet gateway
         *        specified in a route in the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.instance-id</code> - The ID of an instance specified in a route in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.nat-gateway-id</code> - The ID of a NAT gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.transit-gateway-id</code> - The ID of a transit gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code>
         *        indicates that the route was automatically created when the route table was created;
         *        <code>CreateRoute</code> indicates that the route was manually added to the route table;
         *        <code>EnableVgwRoutePropagation</code> indicates that the route was propagated by route propagation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.state</code> - The state of a route in the route table (<code>active</code> |
         *        <code>blackhole</code>). The blackhole state indicates that the route's target isn't available (for
         *        example, the specified gateway isn't attached to the VPC, the specified NAT instance has been
         *        terminated, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route
         *        in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-id</code> - The ID of a transit gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the route table.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>association.route-table-association-id</code> - The ID of an association ID for the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.route-table-id</code> - The ID of the route table involved in the association.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.subnet-id</code> - The ID of the subnet involved in the association.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.main</code> - Indicates whether the route table is the main route table for the VPC (
         * <code>true</code> | <code>false</code>). Route tables that do not have an association ID are not returned in
         * the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The ID of the AWS account that owns the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route-table-id</code> - The ID of the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a route in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-prefix-list-id</code> - The ID (prefix) of the AWS service specified in a route in
         * the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.egress-only-internet-gateway-id</code> - The ID of an egress-only Internet gateway specified in a
         * route in the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.instance-id</code> - The ID of an instance specified in a route in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.nat-gateway-id</code> - The ID of a NAT gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.transit-gateway-id</code> - The ID of a transit gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code> indicates that
         * the route was automatically created when the route table was created; <code>CreateRoute</code> indicates that
         * the route was manually added to the route table; <code>EnableVgwRoutePropagation</code> indicates that the
         * route was propagated by route propagation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.state</code> - The state of a route in the route table (<code>active</code> |
         * <code>blackhole</code>). The blackhole state indicates that the route's target isn't available (for example,
         * the specified gateway isn't attached to the VPC, the specified NAT instance has been terminated, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route in the
         * table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-id</code> - The ID of a transit gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the route table.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>association.route-table-association-id</code> - The ID of an association ID for the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.route-table-id</code> - The ID of the route table involved in the association.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.subnet-id</code> - The ID of the subnet involved in the association.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.main</code> - Indicates whether the route table is the main route table for the VPC
         *        (<code>true</code> | <code>false</code>). Route tables that do not have an association ID are not
         *        returned in the response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The ID of the AWS account that owns the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route-table-id</code> - The ID of the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a route in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route
         *        table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-prefix-list-id</code> - The ID (prefix) of the AWS service specified in a
         *        route in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.egress-only-internet-gateway-id</code> - The ID of an egress-only Internet gateway
         *        specified in a route in the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.instance-id</code> - The ID of an instance specified in a route in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.nat-gateway-id</code> - The ID of a NAT gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.transit-gateway-id</code> - The ID of a transit gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code>
         *        indicates that the route was automatically created when the route table was created;
         *        <code>CreateRoute</code> indicates that the route was manually added to the route table;
         *        <code>EnableVgwRoutePropagation</code> indicates that the route was propagated by route propagation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.state</code> - The state of a route in the route table (<code>active</code> |
         *        <code>blackhole</code>). The blackhole state indicates that the route's target isn't available (for
         *        example, the specified gateway isn't attached to the VPC, the specified NAT instance has been
         *        terminated, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route
         *        in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-id</code> - The ID of a transit gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the route table.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>association.route-table-association-id</code> - The ID of an association ID for the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.route-table-id</code> - The ID of the route table involved in the association.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.subnet-id</code> - The ID of the subnet involved in the association.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.main</code> - Indicates whether the route table is the main route table for the VPC (
         * <code>true</code> | <code>false</code>). Route tables that do not have an association ID are not returned in
         * the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The ID of the AWS account that owns the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route-table-id</code> - The ID of the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a route in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-prefix-list-id</code> - The ID (prefix) of the AWS service specified in a route in
         * the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.egress-only-internet-gateway-id</code> - The ID of an egress-only Internet gateway specified in a
         * route in the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.instance-id</code> - The ID of an instance specified in a route in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.nat-gateway-id</code> - The ID of a NAT gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.transit-gateway-id</code> - The ID of a transit gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code> indicates that
         * the route was automatically created when the route table was created; <code>CreateRoute</code> indicates that
         * the route was manually added to the route table; <code>EnableVgwRoutePropagation</code> indicates that the
         * route was propagated by route propagation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.state</code> - The state of a route in the route table (<code>active</code> |
         * <code>blackhole</code>). The blackhole state indicates that the route's target isn't available (for example,
         * the specified gateway isn't attached to the VPC, the specified NAT instance has been terminated, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route in the
         * table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-id</code> - The ID of a transit gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the route table.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * One or more route table IDs.
         * </p>
         * <p>
         * Default: Describes all your route tables.
         * </p>
         * 
         * @param routeTableIds
         *        One or more route table IDs.</p>
         *        <p>
         *        Default: Describes all your route tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableIds(Collection<String> routeTableIds);

        /**
         * <p>
         * One or more route table IDs.
         * </p>
         * <p>
         * Default: Describes all your route tables.
         * </p>
         * 
         * @param routeTableIds
         *        One or more route table IDs.</p>
         *        <p>
         *        Default: Describes all your route tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableIds(String... routeTableIds);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another
         * call with the returned <b>NextToken</b> value. This value can be between 5 and 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. To retrieve the remaining results, make
         *        another call with the returned <b>NextToken</b> value. This value can be between 5 and 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> routeTableIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRouteTablesRequest model) {
            super(model);
            filters(model.filters);
            routeTableIds(model.routeTableIds);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getRouteTableIds() {
            return routeTableIds;
        }

        @Override
        public final Builder routeTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTableIds(String... routeTableIds) {
            routeTableIds(Arrays.asList(routeTableIds));
            return this;
        }

        public final void setRouteTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRouteTablesRequest build() {
            return new DescribeRouteTablesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
