/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNetworkAclsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeNetworkAclsResponse.Builder, DescribeNetworkAclsResponse> {
    private static final SdkField<List<NetworkAcl>> NETWORK_ACLS_FIELD = SdkField
            .<List<NetworkAcl>> builder(MarshallingType.LIST)
            .getter(getter(DescribeNetworkAclsResponse::networkAcls))
            .setter(setter(Builder::networkAcls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclSet")
                    .unmarshallLocationName("networkAclSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<NetworkAcl> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkAcl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ACLS_FIELD));

    private final List<NetworkAcl> networkAcls;

    private DescribeNetworkAclsResponse(BuilderImpl builder) {
        super(builder);
        this.networkAcls = builder.networkAcls;
    }

    /**
     * <p>
     * Information about one or more network ACLs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more network ACLs.
     */
    public List<NetworkAcl> networkAcls() {
        return networkAcls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkAcls());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkAclsResponse)) {
            return false;
        }
        DescribeNetworkAclsResponse other = (DescribeNetworkAclsResponse) obj;
        return Objects.equals(networkAcls(), other.networkAcls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeNetworkAclsResponse").add("NetworkAcls", networkAcls()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkAcls":
            return Optional.ofNullable(clazz.cast(networkAcls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkAclsResponse, T> g) {
        return obj -> g.apply((DescribeNetworkAclsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeNetworkAclsResponse> {
        /**
         * <p>
         * Information about one or more network ACLs.
         * </p>
         * 
         * @param networkAcls
         *        Information about one or more network ACLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAcls(Collection<NetworkAcl> networkAcls);

        /**
         * <p>
         * Information about one or more network ACLs.
         * </p>
         * 
         * @param networkAcls
         *        Information about one or more network ACLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAcls(NetworkAcl... networkAcls);

        /**
         * <p>
         * Information about one or more network ACLs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkAcl>.Builder} avoiding the need to
         * create one manually via {@link List<NetworkAcl>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkAcl>.Builder#build()} is called immediately and its
         * result is passed to {@link #networkAcls(List<NetworkAcl>)}.
         * 
         * @param networkAcls
         *        a consumer that will call methods on {@link List<NetworkAcl>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkAcls(List<NetworkAcl>)
         */
        Builder networkAcls(Consumer<NetworkAcl.Builder>... networkAcls);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<NetworkAcl> networkAcls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkAclsResponse model) {
            super(model);
            networkAcls(model.networkAcls);
        }

        public final Collection<NetworkAcl.Builder> getNetworkAcls() {
            return networkAcls != null ? networkAcls.stream().map(NetworkAcl::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkAcls(Collection<NetworkAcl> networkAcls) {
            this.networkAcls = NetworkAclListCopier.copy(networkAcls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAcls(NetworkAcl... networkAcls) {
            networkAcls(Arrays.asList(networkAcls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAcls(Consumer<NetworkAcl.Builder>... networkAcls) {
            networkAcls(Stream.of(networkAcls).map(c -> NetworkAcl.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkAcls(Collection<NetworkAcl.BuilderImpl> networkAcls) {
            this.networkAcls = NetworkAclListCopier.copyFromBuilder(networkAcls);
        }

        @Override
        public DescribeNetworkAclsResponse build() {
            return new DescribeNetworkAclsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
