/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNatGatewaysRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeNatGatewaysRequest.Builder, DescribeNatGatewaysRequest> {
    private static final SdkField<List<Filter>> FILTER_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeNatGatewaysRequest::filter))
            .setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeNatGatewaysRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<List<String>> NAT_GATEWAY_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeNatGatewaysRequest::natGatewayIds))
            .setter(setter(Builder::natGatewayIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId")
                    .unmarshallLocationName("NatGatewayId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNatGatewaysRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            MAX_RESULTS_FIELD, NAT_GATEWAY_IDS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Filter> filter;

    private final Integer maxResults;

    private final List<String> natGatewayIds;

    private final String nextToken;

    private DescribeNatGatewaysRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.natGatewayIds = builder.natGatewayIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>nat-gateway-id</code> - The ID of the NAT gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the NAT gateway (<code>pending</code> | <code>failed</code> |
     * <code>available</code> | <code>deleting</code> | <code>deleted</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>subnet-id</code> - The ID of the subnet in which the NAT gateway resides.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC in which the NAT gateway resides.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>nat-gateway-id</code> - The ID of the NAT gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the NAT gateway (<code>pending</code> | <code>failed</code> |
     *         <code>available</code> | <code>deleting</code> | <code>deleted</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>subnet-id</code> - The ID of the subnet in which the NAT gateway resides.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC in which the NAT gateway resides.
     *         </p>
     *         </li>
     */
    public List<Filter> filter() {
        return filter;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. The request returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * <p>
     * Constraint: If the value specified is greater than 1000, we return only 1000 items.
     * </p>
     * 
     * @return The maximum number of items to return for this request. The request returns a token that you can specify
     *         in a subsequent call to get the next set of results.</p>
     *         <p>
     *         Constraint: If the value specified is greater than 1000, we return only 1000 items.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * One or more NAT gateway IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more NAT gateway IDs.
     */
    public List<String> natGatewayIds() {
        return natGatewayIds;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(natGatewayIds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNatGatewaysRequest)) {
            return false;
        }
        DescribeNatGatewaysRequest other = (DescribeNatGatewaysRequest) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(natGatewayIds(), other.natGatewayIds()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeNatGatewaysRequest").add("Filter", filter()).add("MaxResults", maxResults())
                .add("NatGatewayIds", natGatewayIds()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NatGatewayIds":
            return Optional.ofNullable(clazz.cast(natGatewayIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNatGatewaysRequest, T> g) {
        return obj -> g.apply((DescribeNatGatewaysRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeNatGatewaysRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>nat-gateway-id</code> - The ID of the NAT gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the NAT gateway (<code>pending</code> | <code>failed</code> |
         * <code>available</code> | <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet in which the NAT gateway resides.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC in which the NAT gateway resides.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>nat-gateway-id</code> - The ID of the NAT gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the NAT gateway (<code>pending</code> | <code>failed</code> |
         *        <code>available</code> | <code>deleting</code> | <code>deleted</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet in which the NAT gateway resides.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC in which the NAT gateway resides.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Collection<Filter> filter);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>nat-gateway-id</code> - The ID of the NAT gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the NAT gateway (<code>pending</code> | <code>failed</code> |
         * <code>available</code> | <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet in which the NAT gateway resides.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC in which the NAT gateway resides.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>nat-gateway-id</code> - The ID of the NAT gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the NAT gateway (<code>pending</code> | <code>failed</code> |
         *        <code>available</code> | <code>deleting</code> | <code>deleted</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet in which the NAT gateway resides.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC in which the NAT gateway resides.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Filter... filter);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>nat-gateway-id</code> - The ID of the NAT gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the NAT gateway (<code>pending</code> | <code>failed</code> |
         * <code>available</code> | <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet in which the NAT gateway resides.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC in which the NAT gateway resides.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(List<Filter>)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(List<Filter>)
         */
        Builder filter(Consumer<Filter.Builder>... filter);

        /**
         * <p>
         * The maximum number of items to return for this request. The request returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * <p>
         * Constraint: If the value specified is greater than 1000, we return only 1000 items.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. The request returns a token that you can
         *        specify in a subsequent call to get the next set of results.</p>
         *        <p>
         *        Constraint: If the value specified is greater than 1000, we return only 1000 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * One or more NAT gateway IDs.
         * </p>
         * 
         * @param natGatewayIds
         *        One or more NAT gateway IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayIds(Collection<String> natGatewayIds);

        /**
         * <p>
         * One or more NAT gateway IDs.
         * </p>
         * 
         * @param natGatewayIds
         *        One or more NAT gateway IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayIds(String... natGatewayIds);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filter = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private List<String> natGatewayIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNatGatewaysRequest model) {
            super(model);
            filter(model.filter);
            maxResults(model.maxResults);
            natGatewayIds(model.natGatewayIds);
            nextToken(model.nextToken);
        }

        public final Collection<Filter.Builder> getFilter() {
            return filter != null ? filter.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Filter... filter) {
            filter(Arrays.asList(filter));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Consumer<Filter.Builder>... filter) {
            filter(Stream.of(filter).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilter(Collection<Filter.BuilderImpl> filter) {
            this.filter = FilterListCopier.copyFromBuilder(filter);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<String> getNatGatewayIds() {
            return natGatewayIds;
        }

        @Override
        public final Builder natGatewayIds(Collection<String> natGatewayIds) {
            this.natGatewayIds = ValueStringListCopier.copy(natGatewayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGatewayIds(String... natGatewayIds) {
            natGatewayIds(Arrays.asList(natGatewayIds));
            return this;
        }

        public final void setNatGatewayIds(Collection<String> natGatewayIds) {
            this.natGatewayIds = ValueStringListCopier.copy(natGatewayIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNatGatewaysRequest build() {
            return new DescribeNatGatewaysRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
