/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFpgaImageAttributeResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeFpgaImageAttributeResponse.Builder, DescribeFpgaImageAttributeResponse> {
    private static final SdkField<FpgaImageAttribute> FPGA_IMAGE_ATTRIBUTE_FIELD = SdkField
            .<FpgaImageAttribute> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeFpgaImageAttributeResponse::fpgaImageAttribute))
            .setter(setter(Builder::fpgaImageAttribute))
            .constructor(FpgaImageAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageAttribute")
                    .unmarshallLocationName("fpgaImageAttribute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPGA_IMAGE_ATTRIBUTE_FIELD));

    private final FpgaImageAttribute fpgaImageAttribute;

    private DescribeFpgaImageAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.fpgaImageAttribute = builder.fpgaImageAttribute;
    }

    /**
     * <p>
     * Information about the attribute.
     * </p>
     * 
     * @return Information about the attribute.
     */
    public FpgaImageAttribute fpgaImageAttribute() {
        return fpgaImageAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fpgaImageAttribute());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFpgaImageAttributeResponse)) {
            return false;
        }
        DescribeFpgaImageAttributeResponse other = (DescribeFpgaImageAttributeResponse) obj;
        return Objects.equals(fpgaImageAttribute(), other.fpgaImageAttribute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeFpgaImageAttributeResponse").add("FpgaImageAttribute", fpgaImageAttribute()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FpgaImageAttribute":
            return Optional.ofNullable(clazz.cast(fpgaImageAttribute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFpgaImageAttributeResponse, T> g) {
        return obj -> g.apply((DescribeFpgaImageAttributeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFpgaImageAttributeResponse> {
        /**
         * <p>
         * Information about the attribute.
         * </p>
         * 
         * @param fpgaImageAttribute
         *        Information about the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageAttribute(FpgaImageAttribute fpgaImageAttribute);

        /**
         * <p>
         * Information about the attribute.
         * </p>
         * This is a convenience that creates an instance of the {@link FpgaImageAttribute.Builder} avoiding the need to
         * create one manually via {@link FpgaImageAttribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link FpgaImageAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #fpgaImageAttribute(FpgaImageAttribute)}.
         * 
         * @param fpgaImageAttribute
         *        a consumer that will call methods on {@link FpgaImageAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fpgaImageAttribute(FpgaImageAttribute)
         */
        default Builder fpgaImageAttribute(Consumer<FpgaImageAttribute.Builder> fpgaImageAttribute) {
            return fpgaImageAttribute(FpgaImageAttribute.builder().applyMutation(fpgaImageAttribute).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private FpgaImageAttribute fpgaImageAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFpgaImageAttributeResponse model) {
            super(model);
            fpgaImageAttribute(model.fpgaImageAttribute);
        }

        public final FpgaImageAttribute.Builder getFpgaImageAttribute() {
            return fpgaImageAttribute != null ? fpgaImageAttribute.toBuilder() : null;
        }

        @Override
        public final Builder fpgaImageAttribute(FpgaImageAttribute fpgaImageAttribute) {
            this.fpgaImageAttribute = fpgaImageAttribute;
            return this;
        }

        public final void setFpgaImageAttribute(FpgaImageAttribute.BuilderImpl fpgaImageAttribute) {
            this.fpgaImageAttribute = fpgaImageAttribute != null ? fpgaImageAttribute.build() : null;
        }

        @Override
        public DescribeFpgaImageAttributeResponse build() {
            return new DescribeFpgaImageAttributeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
